/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.context;

import java.awt.Dimension;

public class GlimpseBounds {
    public static final GlimpseBounds EMPTY_BOUNDS = new GlimpseBounds(0, 0, 0, 0);
    private int x;
    private int y;
    private int width;
    private int height;

    public GlimpseBounds(Dimension d) {
        this(0, 0, d.width, d.height);
    }

    public GlimpseBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isValid() {
        return this.width > 0 && this.height > 0;
    }

    public boolean contains(int X, int Y) {
        int w = this.width;
        int h = this.height;
        if ((w | h) < 0) {
            return false;
        }
        int x = this.x;
        int y = this.y;
        if (X < x || Y < y) {
            return false;
        }
        h += y;
        return !((w += x) >= x && w <= X || h >= y && h <= Y);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + this.width;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlimpseBounds other = (GlimpseBounds)obj;
        if (this.height != other.height) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public String toString() {
        return String.format("%d,%d,%d,%d", this.x, this.y, this.width, this.height);
    }
}

