/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.tagged.painter;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.painter.NumericXAxisPainter;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.axis.tagged.Tag;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.support.color.GlimpseColor;
import javax.media.opengl.GL;

public class TaggedNumericXAxisPainter
extends NumericXAxisPainter {
    protected static final int DEFAULT_TAG_HEIGHT = 8;
    protected static final int DEFAULT_TAG_BASE = 8;
    protected float[] tagColor = GlimpseColor.fromColorRgba(0.0f, 0.0f, 0.0f, 0.9f);
    protected int tagWidth = 8;
    protected int tagHeight = 8;

    public TaggedNumericXAxisPainter(AxisLabelHandler ticks) {
        super(ticks);
    }

    public void setTagColor(float[] color) {
        this.tagColor = color;
    }

    public void setTagWidth(int width) {
        this.tagWidth = width;
    }

    public void setTagHeight(int height) {
        this.tagHeight = height;
    }

    @Override
    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis1D axis) {
        if (axis instanceof TaggedAxis1D) {
            TaggedAxis1D taggedAxis = (TaggedAxis1D)axis;
            GL gl = context.getGL();
            int width = bounds.getWidth();
            int height = bounds.getHeight();
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            gl.glOrtho(-0.5, (double)((float)(width - 1) + 0.5f), -0.5, (double)((float)(height - 1) + 0.5f), -1.0, 1.0);
            gl.glBlendFunc(770, 771);
            gl.glEnable(3042);
            this.paintTicks(gl, taggedAxis, width, height);
            this.paintSelectionLine(gl, taggedAxis, width, height);
            this.paintTags(gl, taggedAxis, width, height);
        }
    }

    protected void paintTags(GL gl, TaggedAxis1D taggedAxis, int width, int height) {
        for (Tag tag : taggedAxis.getSortedTags()) {
            this.paintTag(gl, tag, taggedAxis, width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintTag(GL gl, Tag tag, TaggedAxis1D taggedAxis, int width, int height) {
        int x = taggedAxis.valueToScreenPixel(tag.getValue());
        int y1 = height - 1 - this.tickBufferSize - this.tagHeight;
        int y2 = y1 + this.tagHeight;
        GlimpseColor.glColor(gl, this.tagColor);
        gl.glBegin(4);
        try {
            gl.glVertex2f((float)x, (float)y2);
            gl.glVertex2f((float)x - (float)this.tagWidth / 2.0f, (float)y1);
            gl.glVertex2f((float)x + (float)this.tagWidth / 2.0f, (float)y1);
        }
        finally {
            gl.glEnd();
        }
    }
}

