/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.tagged;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener1D;
import com.metsci.glimpse.axis.tagged.Tag;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.ModifierKey;
import com.metsci.glimpse.event.mouse.MouseButton;
import java.util.List;

public class TaggedAxisMouseListener1D
extends AxisMouseListener1D {
    public static final int MAX_PIXEL_DISTANCE = 20;
    protected double tagAnchor;
    protected int maxDistance;
    protected Tag selectedTag;
    protected boolean dragTogether;
    protected boolean enableDragTogether = true;

    public TaggedAxisMouseListener1D(int maxDistance) {
        this.maxDistance = maxDistance;
    }

    public TaggedAxisMouseListener1D() {
        this(20);
    }

    public void setDragTagsTogether(boolean enabled) {
        this.enableDragTogether = enabled;
    }

    @Override
    public void mouseMoved(GlimpseMouseEvent e, Axis1D axis, boolean horizontal) {
        TaggedAxis1D taggedAxis = (TaggedAxis1D)axis;
        if (this.selectedTag == null) {
            super.mouseMoved(e, taggedAxis, horizontal);
        } else if (e.isButtonDown(MouseButton.Button1)) {
            this.anchor(taggedAxis, horizontal, e.getX(), e.getY());
            int mousePosPixels = this.getDim(horizontal, e.getX(), taggedAxis.getSizePixels() - e.getY());
            int panPixels = this.getDim(horizontal, this.anchorPixelsX, this.anchorPixelsY) - mousePosPixels;
            double panValue = (double)panPixels / taggedAxis.getPixelsPerValue();
            double newTagValue = this.tagAnchor - panValue;
            if (e.isKeyDown(ModifierKey.Shift) || this.dragTogether) {
                double currentTagValue = this.selectedTag.getValue();
                double deltaTagValue = newTagValue - currentTagValue;
                for (Tag tag : taggedAxis.getSortedTags()) {
                    tag.setValue(tag.getValue() + deltaTagValue);
                }
            } else {
                this.selectedTag.setValue(newTagValue);
            }
            taggedAxis.validateTags();
        }
    }

    @Override
    public void mousePressed(GlimpseMouseEvent e, Axis1D axis, boolean horizontal) {
        TaggedAxis1D taggedAxis = (TaggedAxis1D)axis;
        super.mousePressed(e, taggedAxis, horizontal);
        List<Tag> tags = taggedAxis.getSortedTags();
        int pos = this.getDim(horizontal, e.getX(), taggedAxis.getSizePixels() - e.getY());
        this.selectedTag = this.getSelectedTag(taggedAxis, tags, pos, this.maxDistance);
        if (this.selectedTag != null) {
            this.tagAnchor = this.selectedTag.getValue();
        }
    }

    @Override
    public void mouseReleased(GlimpseMouseEvent e, Axis1D axis, boolean horizontal) {
        super.mouseReleased(e, axis, horizontal);
        this.selectedTag = null;
    }

    protected Tag getSelectedTag(TaggedAxis1D taggedAxis, List<Tag> tags, int mousePos, int maxPixelDist) {
        double maxDistance = (double)maxPixelDist / taggedAxis.getPixelsPerValue();
        double mouseValue = taggedAxis.screenPixelToValue(mousePos);
        this.dragTogether = false;
        Tag selectedTag = null;
        double minDistance = Double.POSITIVE_INFINITY;
        for (Tag tag : tags) {
            double distance = Math.abs(mouseValue - tag.getValue());
            if (!(distance < minDistance) || !(distance < maxDistance)) continue;
            minDistance = distance;
            selectedTag = tag;
        }
        if (this.enableDragTogether && selectedTag == null && tags.size() > 1 && mouseValue > tags.get(0).getValue() && mouseValue < tags.get(tags.size() - 1).getValue()) {
            selectedTag = tags.get(0);
            this.dragTogether = true;
        }
        return selectedTag;
    }
}

