/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.painter;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.painter.base.GlimpsePainter1D;
import com.metsci.glimpse.plot.timeline.data.Epoch;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.FontUtils;
import com.metsci.glimpse.util.units.time.Time;
import com.metsci.glimpse.util.units.time.TimeStamp;
import com.metsci.glimpse.util.units.time.format.TimeStampFormat;
import com.metsci.glimpse.util.units.time.format.TimeStampFormatStandard;
import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import javax.media.opengl.GLContext;

public abstract class TimeAxisPainter
extends GlimpsePainter1D {
    protected static final TimeZone defaultTimeZone = TimeZone.getTimeZone("UTC");
    protected static final TimeStampFormat defaultMinuteSecondFormat = new TimeStampFormatStandard("%m:%S", defaultTimeZone);
    protected static final TimeStampFormat defaultHourDayMonthFormat = new TimeStampFormatStandard("%d %3N %H:00 ", defaultTimeZone);
    protected static final TimeStampFormat defaultHourMinuteFormat = new TimeStampFormatStandard("%H:%m", defaultTimeZone);
    protected static final TimeStampFormat defaultDayMonthYearFormat = new TimeStampFormatStandard("%d %3N %y", defaultTimeZone);
    protected static final TimeStampFormat defaultDayFormat = new TimeStampFormatStandard("%d", defaultTimeZone);
    protected static final TimeStampFormat defaultMonthYearFormat = new TimeStampFormatStandard("%3N %y", defaultTimeZone);
    protected static final TimeStampFormat defaultMonthFormat = new TimeStampFormatStandard("%3N", defaultTimeZone);
    protected static final TimeStampFormat defaultYearFormat = new TimeStampFormatStandard("%y", defaultTimeZone);
    protected static final TimeStructFactory hourStructFactory = new HourStructFactory();
    protected static final TimeStructFactory dayStructFactory = new DayStructFactory();
    protected static final TimeStructFactory monthStructFactory = new MonthStructFactory();
    protected static final TimeStructFactory yearStructFactory = new YearStructFactory();
    protected float[] tickColor;
    protected float[] textColor;
    protected TextRenderer textRenderer;
    protected Font font = FontUtils.getBitstreamVeraSansPlain(12.0f);
    protected Epoch epoch;
    protected final TimeZone timeZone;
    protected final TimeStampFormat minuteSecondFormat;
    protected final TimeStampFormat hourDayMonthFormat;
    protected final TimeStampFormat hourMinuteFormat;
    protected final TimeStampFormat dayMonthYearFormat;
    protected final TimeStampFormat dayFormat;
    protected final TimeStampFormat monthFormat;
    protected final TimeStampFormat monthYearFormat;
    protected final TimeStampFormat yearFormat;
    protected boolean showCurrentTimeLabel = false;
    protected float[] currentTimeTextColor;
    protected float[] currentTimeTickColor;
    protected float currentTimeLineThickness;
    protected int hoverLabelOffset = 4;
    protected int tickLineLength = 4;
    protected int pixelsBetweenTicks = 60;
    protected double yearOrderFactor = 6.0;

    public TimeAxisPainter(TimeStampFormat minuteSecondFormat, TimeStampFormat hourDayMonthFormat, TimeStampFormat hourMinuteFormat, TimeStampFormat dayMonthYearFormat, TimeStampFormat dayFormat, TimeStampFormat monthFormat, TimeStampFormat monthYearFormat, TimeStampFormat yearFormat, TimeZone timeZone, Epoch epoch) {
        this.textRenderer = new TextRenderer(this.font);
        this.timeZone = timeZone;
        this.minuteSecondFormat = minuteSecondFormat;
        this.hourDayMonthFormat = hourDayMonthFormat;
        this.hourMinuteFormat = hourMinuteFormat;
        this.dayMonthYearFormat = dayMonthYearFormat;
        this.dayFormat = dayFormat;
        this.monthYearFormat = monthYearFormat;
        this.monthFormat = monthFormat;
        this.yearFormat = yearFormat;
        this.epoch = epoch;
        this.setTextColor(GlimpseColor.getBlack());
        this.setTickColor(GlimpseColor.getBlack());
        this.setCurrentTimeTextColor(GlimpseColor.getGreen(0.5f));
        this.setCurrentTimeTickColor(GlimpseColor.getGreen(1.0f));
        this.currentTimeLineThickness = 3.0f;
    }

    public void setTickLineLength(int pixels) {
        this.tickLineLength = pixels;
    }

    public void setPixelsBetweenTicks(int pixels) {
        this.pixelsBetweenTicks = pixels;
    }

    public void setEpoch(Epoch epoch) {
        this.epoch = epoch;
    }

    public Epoch getEpoch() {
        return this.epoch;
    }

    public TimeStamp toTimeStamp(double time) {
        return this.epoch.toTimeStamp(time);
    }

    public double fromTimeStamp(TimeStamp time) {
        return this.epoch.fromTimeStamp(time);
    }

    public void setTickColor(float[] color) {
        this.tickColor = color;
    }

    public void setTextColor(float[] color) {
        this.textColor = color;
    }

    public void setCurrentTimeTickColor(float[] color) {
        this.currentTimeTickColor = color;
    }

    public void setCurrentTimeTextColor(float[] color) {
        this.currentTimeTextColor = color;
    }

    public void showCurrentTimeLabel(boolean show) {
        this.showCurrentTimeLabel = show;
    }

    public void setFont(Font font) {
        this.setFont(font, true);
    }

    public void setFont(Font font, boolean antialias) {
        this.font = font;
        if (this.textRenderer != null) {
            this.textRenderer.dispose();
        }
        this.textRenderer = new TextRenderer(font, antialias, false);
    }

    protected double tickInterval(List<TimeStamp> list) {
        if (list == null || list.size() < 2) {
            return Time.fromSeconds((double)1.0);
        }
        TimeStamp t1 = list.get(0);
        TimeStamp t2 = list.get(1);
        return t2.durationAfter(t1);
    }

    protected static int getYearStep(double spanYears) {
        int order;
        double log10 = Math.log10(spanYears);
        if (log10 - (double)(order = (int)Math.floor(log10)) > 0.999999999999) {
            ++order;
        }
        return (int)Math.max(1.0, Math.pow(10.0, order));
    }

    protected static int getRoundedYear(int currentYear, int yearStep) {
        int numSteps = currentYear / yearStep;
        return numSteps * yearStep;
    }

    protected List<TimeStamp> tickTimes(Axis1D axis, double axisLengthPixels) {
        TimeStamp t0 = this.toTimeStamp(axis.getMin());
        TimeStamp t1 = this.toTimeStamp(axis.getMax());
        double approxTickInterval_SU = (double)this.pixelsBetweenTicks * t1.durationAfter(t0) / axisLengthPixels;
        if (approxTickInterval_SU > Time.fromDays((double)60.0)) {
            Calendar cal = t0.toCalendar();
            cal.setTimeZone(defaultTimeZone);
            int currentYear = cal.get(1);
            double daysPerYear = 365.25;
            double approxTickInterval_Years = Time.toDays((double)approxTickInterval_SU) / daysPerYear;
            int stepYears = TimeAxisPainter.getYearStep(approxTickInterval_Years * this.yearOrderFactor);
            int startYear = TimeAxisPainter.getRoundedYear(currentYear, stepYears);
            cal.set(1, startYear);
            cal.set(2, 0);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            long endTime = t1.toPosixMillis();
            ArrayList<TimeStamp> times = new ArrayList<TimeStamp>();
            while (cal.getTimeInMillis() <= endTime) {
                times.add(TimeStamp.fromCalendar((Calendar)cal));
                cal.add(1, stepYears);
            }
            return times;
        }
        if (approxTickInterval_SU > Time.fromDays((double)10.0)) {
            Calendar cal = t0.toCalendar();
            cal.setTimeZone(defaultTimeZone);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            long endTime = t1.toPosixMillis();
            ArrayList<TimeStamp> times = new ArrayList<TimeStamp>();
            while (cal.getTimeInMillis() <= endTime) {
                times.add(TimeStamp.fromCalendar((Calendar)cal));
                cal.add(2, 1);
            }
            return times;
        }
        if (approxTickInterval_SU > Time.fromDays((double)1.0)) {
            int tickInterval_Days = TimeAxisPainter.tickInterval_Days(approxTickInterval_SU);
            Calendar cal = t0.toCalendar();
            cal.setTimeZone(defaultTimeZone);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            long endTime = t1.toPosixMillis() + (long)Time.daysToMilliseconds((double)tickInterval_Days);
            int currentMonth = cal.get(2);
            ArrayList<TimeStamp> times = new ArrayList<TimeStamp>();
            while (cal.getTimeInMillis() <= endTime) {
                int day;
                int max_day;
                int newMonth = cal.get(2);
                if (newMonth != currentMonth) {
                    cal.set(5, 1);
                    currentMonth = newMonth;
                }
                if ((max_day = cal.getActualMaximum(5)) - (day = cal.get(5)) + 1 >= tickInterval_Days / 2) {
                    times.add(TimeStamp.fromCalendar((Calendar)cal));
                }
                cal.add(5, tickInterval_Days);
            }
            return times;
        }
        double tickInterval_SU = TimeAxisPainter.tickInterval_SU(approxTickInterval_SU);
        double zoneOffset_SU = Time.fromMilliseconds((double)this.timeZone.getOffset(t0.toPosixMillis()));
        TimeStamp epoch = TimeStamp.posixEpoch();
        TimeStamp firstTick = epoch.add(tickInterval_SU * Math.floor((t0.durationAfter(epoch) + zoneOffset_SU) / tickInterval_SU) - zoneOffset_SU);
        double numTicks = 1.0 + t1.durationAfter(firstTick) / tickInterval_SU;
        ArrayList<TimeStamp> times = new ArrayList<TimeStamp>();
        int i = 0;
        while ((double)i < numTicks) {
            times.add(firstTick.add((double)i * tickInterval_SU));
            ++i;
        }
        return times;
    }

    protected static int tickInterval_Days(double approxTickInterval_SU) {
        int[] rungs_SU;
        double approxTickInterval_Days = Time.secondsToDays((double)approxTickInterval_SU);
        for (int r : rungs_SU = new int[]{2, 3, 4, 5, 8, 10}) {
            if (!(approxTickInterval_Days <= (double)r)) continue;
            return r;
        }
        return 10;
    }

    protected static double tickInterval_SU(double approxTickInterval_SU) {
        double[] rungs_SU;
        for (double r : rungs_SU = new double[]{Time.fromSeconds((double)1.0), Time.fromSeconds((double)2.0), Time.fromSeconds((double)5.0), Time.fromSeconds((double)10.0), Time.fromSeconds((double)15.0), Time.fromSeconds((double)20.0), Time.fromSeconds((double)30.0), Time.fromMinutes((double)1.0), Time.fromMinutes((double)2.0), Time.fromMinutes((double)5.0), Time.fromMinutes((double)10.0), Time.fromMinutes((double)15.0), Time.fromMinutes((double)20.0), Time.fromMinutes((double)30.0), Time.fromHours((double)1.0), Time.fromHours((double)2.0), Time.fromHours((double)3.0), Time.fromHours((double)6.0), Time.fromHours((double)12.0), Time.fromDays((double)1.0)}) {
            if (!(approxTickInterval_SU <= r)) continue;
            return r;
        }
        return Time.fromDays((double)1.0);
    }

    protected static <T extends Comparable<T>> T min(T a, T b) {
        return a.compareTo(b) < 0 ? a : b;
    }

    protected static <T extends Comparable<T>> T max(T a, T b) {
        return a.compareTo(b) > 0 ? a : b;
    }

    protected List<TimeStruct> timeStructs(Axis1D axis, List<TimeStamp> tickTimes, TimeStructFactory factory) {
        TimeStamp viewStart = this.toTimeStamp(axis.getMin());
        TimeStamp viewEnd = this.toTimeStamp(axis.getMax());
        ArrayList<TimeStruct> days = new ArrayList<TimeStruct>();
        double maxDayViewDuration = Double.NEGATIVE_INFINITY;
        Calendar calendar = Calendar.getInstance(this.timeZone);
        for (TimeStamp t : tickTimes) {
            TimeStruct day = factory.newTimeStruct();
            days.add(day);
            day.setCalendar(t, calendar);
            day.start = TimeStamp.fromPosixMillis((long)calendar.getTimeInMillis());
            day.incrementCalendar(calendar);
            day.end = TimeStamp.fromPosixMillis((long)calendar.getTimeInMillis());
            day.viewStart = TimeAxisPainter.min(day.end, TimeAxisPainter.max(day.start, viewStart));
            day.viewEnd = TimeAxisPainter.min(day.end, TimeAxisPainter.max(day.start, viewEnd));
            maxDayViewDuration = Math.max(maxDayViewDuration, day.viewEnd.durationAfter(day.viewStart));
        }
        for (TimeStruct day : days) {
            double duration = day.viewEnd.durationAfter(day.viewStart);
            TimeStamp midpoint = day.viewStart.add(0.5 * duration);
            TimeStamp edge = day.viewStart.equals((Object)day.start) ? day.viewEnd : day.viewStart;
            double edginess = 1.0 - Math.max(0.0, Math.min(1.0, duration / maxDayViewDuration));
            day.textCenter = midpoint.add(edginess * edge.durationAfter(midpoint));
        }
        return days;
    }

    @Override
    public void dispose(GLContext context) {
        if (this.textRenderer != null) {
            this.textRenderer.dispose();
        }
        this.textRenderer = null;
    }

    protected static class HourStructFactory
    implements TimeStructFactory {
        protected HourStructFactory() {
        }

        @Override
        public TimeStruct newTimeStruct() {
            return new HourStruct();
        }
    }

    protected static class YearStructFactory
    implements TimeStructFactory {
        protected YearStructFactory() {
        }

        @Override
        public TimeStruct newTimeStruct() {
            return new YearStruct();
        }
    }

    protected static class MonthStructFactory
    implements TimeStructFactory {
        protected MonthStructFactory() {
        }

        @Override
        public TimeStruct newTimeStruct() {
            return new MonthStruct();
        }
    }

    protected static class DayStructFactory
    implements TimeStructFactory {
        protected DayStructFactory() {
        }

        @Override
        public TimeStruct newTimeStruct() {
            return new DayStruct();
        }
    }

    protected static interface TimeStructFactory {
        public TimeStruct newTimeStruct();
    }

    protected static class HourStruct
    extends TimeStruct {
        protected HourStruct() {
        }

        @Override
        public void setCalendar(TimeStamp time, Calendar calendar) {
            calendar.setTimeInMillis(time.toPosixMillis());
            calendar.set(12, 0);
            calendar.set(13, 0);
        }

        @Override
        public void incrementCalendar(Calendar calendar) {
            calendar.add(11, 1);
        }
    }

    protected static class DayStruct
    extends TimeStruct {
        protected DayStruct() {
        }

        @Override
        public void setCalendar(TimeStamp time, Calendar calendar) {
            calendar.setTimeInMillis(time.toPosixMillis());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
        }

        @Override
        public void incrementCalendar(Calendar calendar) {
            calendar.add(5, 1);
        }
    }

    protected static class MonthStruct
    extends TimeStruct {
        protected MonthStruct() {
        }

        @Override
        public void setCalendar(TimeStamp time, Calendar calendar) {
            calendar.setTimeInMillis(time.toPosixMillis());
            calendar.set(5, 0);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
        }

        @Override
        public void incrementCalendar(Calendar calendar) {
            calendar.add(2, 1);
        }
    }

    protected static class YearStruct
    extends TimeStruct {
        protected YearStruct() {
        }

        @Override
        public void setCalendar(TimeStamp time, Calendar calendar) {
            calendar.setTimeInMillis(time.toPosixMillis());
            calendar.set(2, 0);
            calendar.set(5, 0);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
        }

        @Override
        public void incrementCalendar(Calendar calendar) {
            calendar.add(1, 1);
        }
    }

    protected static abstract class TimeStruct {
        public TimeStamp start;
        public TimeStamp end;
        public TimeStamp viewStart;
        public TimeStamp viewEnd;
        public TimeStamp textCenter;

        protected TimeStruct() {
        }

        public abstract void setCalendar(TimeStamp var1, Calendar var2);

        public abstract void incrementCalendar(Calendar var1);
    }
}

