/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.listener.touch;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.listener.touch.AxisGestureListener;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.event.touch.GlimpseLongPressGestureEvent;
import com.metsci.glimpse.event.touch.GlimpsePanGestureEvent;
import com.metsci.glimpse.event.touch.GlimpsePinchGestureEvent;
import com.metsci.glimpse.event.touch.GlimpseSwipeGestureEvent;
import com.metsci.glimpse.event.touch.GlimpseTapGestureEvent;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;

public class AxisGestureListener2D
extends AxisGestureListener {
    protected GlimpseAxisLayout2D getAxisLayout(GlimpseTargetStack stack) {
        GlimpseTarget target = stack.getTarget();
        if (target instanceof GlimpseAxisLayout2D) {
            return (GlimpseAxisLayout2D)target;
        }
        return null;
    }

    @Override
    public void panDetected(GlimpsePanGestureEvent event) {
        GlimpseAxisLayout2D layout = this.getAxisLayout(event.getTargetStack());
        if (layout == null) {
            return;
        }
        Axis2D targetAxis = layout.getAxis(event.getTargetStack());
        this.pan(targetAxis.getAxisX(), true, event.getDxPixels(), event.getDyPixels());
        this.pan(targetAxis.getAxisY(), false, event.getDxPixels(), event.getDyPixels());
        this.applyAndUpdate(targetAxis.getAxisX(), targetAxis.getAxisY());
    }

    @Override
    public void pinchDetected(GlimpsePinchGestureEvent event) {
        GlimpseAxisLayout2D layout = this.getAxisLayout(event.getTargetStack());
        if (layout == null) {
            return;
        }
        Axis2D targetAxis = layout.getAxis(event.getTargetStack());
        this.zoom(targetAxis.getAxisX(), true, event.getCenterPixelX(), event.getCenterPixelY(), event.getScale());
        this.zoom(targetAxis.getAxisY(), false, event.getCenterPixelX(), event.getCenterPixelY(), event.getScale());
        this.applyAndUpdate(targetAxis.getAxisX(), targetAxis.getAxisY());
    }

    public void applyAndUpdate(Axis1D axisX, Axis1D axisY) {
        axisX.applyConstraints();
        axisY.applyConstraints();
        axisX.updateLinkedAxes(axisY);
        axisY.updateLinkedAxes();
    }

    @Override
    public void tapDetected(GlimpseTapGestureEvent event) {
    }

    @Override
    public void longPressDetected(GlimpseLongPressGestureEvent event) {
    }

    @Override
    public void swipeDetected(GlimpseSwipeGestureEvent event) {
    }
}

