/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.listener.touch;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.listener.touch.AxisGestureListener;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.event.touch.GlimpseLongPressGestureEvent;
import com.metsci.glimpse.event.touch.GlimpsePanGestureEvent;
import com.metsci.glimpse.event.touch.GlimpsePinchGestureEvent;
import com.metsci.glimpse.event.touch.GlimpseSwipeGestureEvent;
import com.metsci.glimpse.event.touch.GlimpseTapGestureEvent;
import com.metsci.glimpse.layout.GlimpseAxisLayout1D;

public class AxisGestureListener1D
extends AxisGestureListener {
    protected GlimpseAxisLayout1D getAxisLayout(GlimpseTargetStack stack) {
        GlimpseTarget target = stack.getTarget();
        if (target instanceof GlimpseAxisLayout1D) {
            return (GlimpseAxisLayout1D)target;
        }
        return null;
    }

    @Override
    public void panDetected(GlimpsePanGestureEvent event) {
        GlimpseAxisLayout1D layout = this.getAxisLayout(event.getTargetStack());
        if (layout == null) {
            return;
        }
        Axis1D targetAxis = layout.getAxis(event.getTargetStack());
        this.pan(targetAxis, layout.isHorizontal(), event.getDxPixels(), event.getDyPixels());
        this.validateAxes(targetAxis);
    }

    @Override
    public void pinchDetected(GlimpsePinchGestureEvent event) {
        GlimpseAxisLayout1D layout = this.getAxisLayout(event.getTargetStack());
        if (layout == null) {
            return;
        }
        Axis1D targetAxis = layout.getAxis(event.getTargetStack());
        this.zoom(targetAxis, layout.isHorizontal(), event.getCenterPixelX(), event.getCenterPixelY(), event.getScale());
        this.validateAxes(targetAxis);
    }

    protected void validateAxes(Axis1D axis) {
        axis.applyConstraints();
        if (axis.getLockedAspectAxis() != null) {
            axis.getLockedAspectAxis().applyConstraints();
        }
        axis.updateLinkedAxes();
        if (axis.getLockedAspectAxis() != null) {
            axis.getLockedAspectAxis().updateLinkedAxes();
        }
    }

    @Override
    public void tapDetected(GlimpseTapGestureEvent event) {
    }

    @Override
    public void longPressDetected(GlimpseLongPressGestureEvent event) {
    }

    @Override
    public void swipeDetected(GlimpseSwipeGestureEvent event) {
    }
}

