/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.listener.touch;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.event.touch.GlimpseGestureListener;
import com.metsci.glimpse.event.touch.Touchable;

public abstract class AxisGestureListener
implements GlimpseGestureListener {
    public final double zoomConstant = 0.12f;
    protected boolean allowSelectionLock = true;
    protected boolean allowSelectionZoom = true;
    protected boolean allowPan = true;
    protected boolean allowZoom = true;

    public void addAxisGestureListener(Touchable touchable) {
        touchable.addGlimpseGestureListener(this);
    }

    public void setAllowSelectionLock(boolean b) {
        this.allowSelectionLock = b;
    }

    public void setAllowSelectionZoom(boolean b) {
        this.allowSelectionZoom = b;
    }

    public void setAllowZoom(boolean b) {
        this.allowZoom = b;
    }

    public void setAllowPan(boolean b) {
        this.allowPan = b;
    }

    protected int getDim(boolean horizontal, int x, int y) {
        return horizontal ? x : y;
    }

    protected double getDim(boolean horizontal, double x, double y) {
        return horizontal ? x : y;
    }

    public void pan(Axis1D axis, boolean horizontal, float dX, float dY) {
        if (!this.allowPan) {
            return;
        }
        double panPixels = this.getDim(horizontal, dX, dY);
        double diffValue = axis.getMax() - axis.getMin();
        double newMinValue = axis.getMin() - panPixels / axis.getPixelsPerValue();
        double newMaxValue = newMinValue + diffValue;
        axis.setMin(newMinValue);
        axis.setMax(newMaxValue);
    }

    public void zoom(Axis1D axis, boolean horizontal, float posX, float posY, float scale) {
        if (!this.allowZoom) {
            return;
        }
        double mousePosPixels = this.getDim(horizontal, posX, (float)axis.getSizePixels() - posY);
        double mousePosValue = axis.screenPixelToValue(mousePosPixels);
        double oldPixelsPerValue = axis.getPixelsPerValue();
        double newPixelsPerValue = oldPixelsPerValue * (double)scale;
        double newMinValue = mousePosValue - mousePosPixels / newPixelsPerValue;
        double newMaxValue = newMinValue + (double)axis.getSizePixels() / newPixelsPerValue;
        axis.setMin(newMinValue);
        axis.setMax(newMaxValue);
    }

    public void zoomSelection(Axis1D axis, boolean horizontal, int zoomIncrements, int posX, int posY) {
        if (!this.allowSelectionZoom) {
            return;
        }
        double zoomPercentDbl = 1.0;
        for (int i = 0; i < Math.abs(zoomIncrements); ++i) {
            zoomPercentDbl *= 1.119999997317791;
        }
        zoomPercentDbl = zoomIncrements > 0 ? zoomPercentDbl : 1.0 / zoomPercentDbl;
        double newSelectionSize = axis.getSelectionSize() * zoomPercentDbl;
        axis.setSelectionSize(newSelectionSize);
    }

    public void move(Axis1D axis, boolean horizontal, int posX, int posY) {
        int mousePosPixels = this.getDim(horizontal, posX, axis.getSizePixels() - posY);
        double mousePosValue = axis.screenPixelToValue(mousePosPixels);
        axis.setMouseValue(mousePosValue);
        if (!axis.isSelectionLocked()) {
            axis.setSelectionCenter(mousePosValue);
        }
    }

    public void toggleSelectionLock(Axis1D axis) {
        if (!this.allowSelectionLock) {
            return;
        }
        axis.setSelectionLock(!axis.isSelectionLocked());
    }
}

