/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.listener.mouse;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;

public class AxisMouseListener2D
extends AxisMouseListener {
    protected GlimpseAxisLayout2D getAxisLayout(GlimpseMouseEvent event) {
        GlimpseTargetStack stack = event.getTargetStack();
        GlimpseTarget target = stack.getTarget();
        if (target instanceof GlimpseAxisLayout2D) {
            return (GlimpseAxisLayout2D)target;
        }
        return null;
    }

    @Override
    public void mousePressed(GlimpseMouseEvent event) {
        GlimpseAxisLayout2D layout = this.getAxisLayout(event);
        if (layout == null) {
            return;
        }
        Axis2D axis = layout.getAxis(event.getTargetStack());
        this.mousePressed(event, axis.getAxisX(), true);
        this.mousePressed(event, axis.getAxisY(), false);
        this.applyAndUpdate(axis.getAxisX(), axis.getAxisY());
    }

    @Override
    public void mouseMoved(GlimpseMouseEvent event) {
        GlimpseAxisLayout2D layout = this.getAxisLayout(event);
        if (layout == null) {
            return;
        }
        Axis2D axis = layout.getAxis(event.getTargetStack());
        this.mouseMoved(event, axis.getAxisX(), true);
        this.mouseMoved(event, axis.getAxisY(), false);
        this.applyAndUpdate(axis.getAxisX(), axis.getAxisY());
    }

    @Override
    public void mouseWheelMoved(GlimpseMouseEvent event) {
        GlimpseAxisLayout2D layout = this.getAxisLayout(event);
        if (layout == null) {
            return;
        }
        Axis2D axis = layout.getAxis(event.getTargetStack());
        this.mouseWheelMoved(event, axis.getAxisX(), true);
        this.mouseWheelMoved(event, axis.getAxisY(), false);
        this.applyAndUpdate(axis.getAxisX(), axis.getAxisY());
    }

    @Override
    public void mouseReleased(GlimpseMouseEvent event) {
        GlimpseAxisLayout2D layout = this.getAxisLayout(event);
        if (layout == null) {
            return;
        }
        Axis2D axis = layout.getAxis(event.getTargetStack());
        this.mouseReleased(event, axis.getAxisX(), true);
        this.mouseReleased(event, axis.getAxisY(), false);
        this.applyAndUpdate(axis.getAxisX(), axis.getAxisY());
    }

    @Override
    public void mouseEntered(GlimpseMouseEvent event) {
    }

    @Override
    public void mouseExited(GlimpseMouseEvent event) {
    }

    public void applyAndUpdate(Axis1D axisX, Axis1D axisY) {
        axisX.applyConstraints();
        axisY.applyConstraints();
        axisX.updateLinkedAxes(axisY);
        axisY.updateLinkedAxes();
    }
}

