/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.texture;

import com.metsci.glimpse.gl.util.GLUtils;
import com.metsci.glimpse.support.texture.ShortTextureProjected2D;
import com.metsci.glimpse.support.texture.TextureProjected2D;
import com.metsci.glimpse.util.logging.LoggerUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import javax.media.opengl.GL;

public class ByteTextureProjected2D
extends TextureProjected2D {
    private static final Logger logger = Logger.getLogger(ShortTextureProjected2D.class.getName());

    public ByteTextureProjected2D(int dataSizeX, int dataSizeY) {
        this(dataSizeX, dataSizeY, false);
    }

    public ByteTextureProjected2D(int dataSizeX, int dataSizeY, boolean useVertexZCoord) {
        super(dataSizeX, dataSizeY, useVertexZCoord);
    }

    protected Buffer prepare_setPixelStore(GL gl, int i) {
        gl.glPixelStorei(3317, 1);
        gl.glPixelStorei(3316, this.texStartsX[i]);
        gl.glPixelStorei(3314, this.dataSizeX);
        return this.data.position(this.texStartsY[i] * this.dataSizeX);
    }

    @Override
    protected void prepare_setData(GL gl) {
        for (int i = 0; i < this.numTextures; ++i) {
            gl.glBindTexture(GLUtils.getGLTextureDim(2), this.textureHandles[i]);
            this.prepare_setTexParameters(gl);
            Buffer positionedBuffer = this.prepare_setPixelStore(gl, i);
            gl.glTexImage2D(3553, 0, 36242, this.texSizesX[i], this.texSizesY[i], 0, 36252, 5120, positionedBuffer);
        }
        gl.glPixelStorei(3316, 0);
        gl.glPixelStorei(3315, 0);
        gl.glPixelStorei(3314, 0);
    }

    @Override
    protected int getRequiredCapacityBytes() {
        return this.dataSizeX * this.dataSizeY;
    }

    @Override
    protected float getData(int index) {
        return this.data.get(index);
    }

    public void setData(byte[][] data) {
        this.mutate(new SetDataMutator(data));
    }

    public void setData(byte[][] data, boolean flip) {
        this.mutate(new SetDataMutator(data, flip));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutate(MutatorByte2D mutator) {
        this.lock.lock();
        try {
            this.data.rewind();
            mutator.mutate(this.data, this.dataSizeX, this.dataSizeY);
            this.makeDirty();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static class SetDataMutator
    implements MutatorByte2D {
        public byte[][] data;
        public boolean flip;

        public SetDataMutator(byte[][] data, boolean flip) {
            this.data = data;
            this.flip = flip;
        }

        public SetDataMutator(byte[][] data) {
            this(data, false);
        }

        @Override
        public void mutate(ByteBuffer buffer, int dataSizeX, int dataSizeY) {
            if (this.data == null) {
                logger.warning("Null data array passed to SetDataMutator.");
                return;
            }
            buffer.clear();
            if (!this.flip) {
                if (this.data.length != dataSizeX || this.data[0].length != dataSizeY) {
                    LoggerUtils.logWarning((Logger)logger, (String)"Incorrectly sized data array passed to SetDataMutator. Expected %d %d. Got %d %d.", (Object[])new Object[]{dataSizeX, dataSizeY, this.data.length, this.data[0].length});
                    return;
                }
                for (int y = 0; y < dataSizeY; ++y) {
                    for (int x = 0; x < dataSizeX; ++x) {
                        buffer.put(this.data[x][y]);
                    }
                }
            } else {
                if (this.data.length != dataSizeY || this.data[0].length != dataSizeX) {
                    LoggerUtils.logWarning((Logger)logger, (String)"Incorrectly sized data array passed to SetDataMutator. Expected %d %d. Got %d %d.", (Object[])new Object[]{dataSizeX, dataSizeY, this.data[0].length, this.data.length});
                    return;
                }
                for (int y = 0; y < dataSizeY; ++y) {
                    for (int x = 0; x < dataSizeX; ++x) {
                        buffer.put(this.data[y][x]);
                    }
                }
            }
        }
    }

    public static interface MutatorByte2D {
        public void mutate(ByteBuffer var1, int var2, int var3);
    }
}

