/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.shader;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.listener.AxisListener1D;
import com.metsci.glimpse.gl.shader.Shader;
import com.metsci.glimpse.gl.shader.ShaderArg;
import com.metsci.glimpse.gl.shader.ShaderSource;
import com.metsci.glimpse.gl.shader.ShaderType;
import com.metsci.glimpse.util.io.StreamOpener;
import java.io.IOException;
import javax.media.opengl.GL;

public class SampledColorScaleShader
extends Shader
implements AxisListener1D {
    private ShaderArg dataMin;
    private ShaderArg dataMax;
    private ShaderArg alpha;
    private ShaderArg dataTexUnit;
    private ShaderArg colorTexUnit;

    public SampledColorScaleShader(Axis1D colorAxis, int targetTexUnit, int colorTexUnit) throws IOException {
        super("sampled_colorscale_shader", ShaderType.fragment, SampledColorScaleShader.readSource("shaders/colormap/sampled_colorscale_shader.fs"));
        this.initialize(colorAxis, targetTexUnit, colorTexUnit);
    }

    protected SampledColorScaleShader(String source) throws IOException {
        super("sampled_colorscale_shader", ShaderType.fragment, SampledColorScaleShader.readSource(source));
    }

    protected void initialize(Axis1D colorAxis, int targetTexUnit, int colorTexUnit) {
        colorAxis.addAxisListener(this);
        this.dataMin = this.getArg("dataMin");
        this.dataMin.setValue(this.getMin(colorAxis));
        this.dataMax = this.getArg("dataMax");
        this.dataMax.setValue(this.getMax(colorAxis));
        this.alpha = this.getArg("alpha");
        this.alpha.setValue(Float.valueOf(1.0f));
        this.dataTexUnit = this.getArg("datatex");
        this.dataTexUnit.setValue(targetTexUnit);
        this.colorTexUnit = this.getArg("colortex");
        this.colorTexUnit.setValue(colorTexUnit);
    }

    private static final ShaderSource readSource(String source) throws IOException {
        return new ShaderSource(source, StreamOpener.fileThenResource);
    }

    public void setAlpha(float alpha) {
        this.alpha.setValue(Float.valueOf(alpha));
    }

    @Override
    public boolean preLink(GL gl, int glProgramHandle) {
        return true;
    }

    @Override
    public void preDisplay(GL gl) {
    }

    @Override
    public void postDisplay(GL gl) {
    }

    @Override
    public void axisUpdated(Axis1D axis) {
        this.dataMin.setValue(this.getMin(axis));
        this.dataMax.setValue(this.getMax(axis));
    }

    public void setTargetTexUnit(int unit) {
        this.dataTexUnit.setValue(unit);
    }

    public void setColorTexUnit(int unit) {
        this.colorTexUnit.setValue(unit);
    }

    protected double getMin(Axis1D axis) {
        return axis.getMin();
    }

    protected double getMax(Axis1D axis) {
        return axis.getMax();
    }
}

