/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.polygon;

import com.metsci.glimpse.support.polygon.Polygon;
import com.metsci.glimpse.support.polygon.VertexAccumulator;
import java.util.Iterator;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallback;

public class PolygonTessellator {
    private final GLU glu;
    private final GLUtessellator tess;
    private final TessellatorCallback tessCallback;

    public PolygonTessellator(GLU glu) {
        this.glu = glu;
        this.tess = glu.gluNewTess();
        glu.gluTessProperty(this.tess, 100140, 100130.0);
        this.tessCallback = new TessellatorCallback();
        glu.gluTessCallback(this.tess, 100100, (GLUtessellatorCallback)this.tessCallback);
        glu.gluTessCallback(this.tess, 100102, (GLUtessellatorCallback)this.tessCallback);
        glu.gluTessCallback(this.tess, 100101, (GLUtessellatorCallback)this.tessCallback);
        glu.gluTessCallback(this.tess, 100105, (GLUtessellatorCallback)this.tessCallback);
        glu.gluTessCallback(this.tess, 100104, (GLUtessellatorCallback)this.tessCallback);
        glu.gluTessCallback(this.tess, 100103, (GLUtessellatorCallback)this.tessCallback);
    }

    public final int tessellate(Polygon poly, VertexAccumulator accumulator) throws TessellationException {
        this.tessCallback.reset(accumulator);
        this.glu.gluTessBeginPolygon(this.tess, null);
        Iterator<Polygon.Loop> loops = poly.getIterator();
        while (loops.hasNext()) {
            this.glu.gluTessBeginContour(this.tess);
            Polygon.Loop loop = loops.next();
            int n = loop.size();
            for (int i = 0; i < n; ++i) {
                double[] p = loop.get(i);
                this.glu.gluTessVertex(this.tess, p, 0, (Object)p);
                this.tessCallback.checkErrorFlag();
            }
            this.glu.gluTessEndContour(this.tess);
        }
        this.glu.gluTessEndPolygon(this.tess);
        this.tessCallback.checkErrorFlag();
        return this.tessCallback.getNumTrianglesGenerated();
    }

    public final void destroy() {
        this.glu.gluDeleteTess(this.tess);
    }

    private static interface Adapter {
        public void processVertex(double[] var1);
    }

    public static class TessellationException
    extends Exception {
    }

    private static class TessellatorCallback
    implements GLUtessellatorCallback {
        private Adapter currentAdapter;
        private VertexAccumulator currentAccumulator;
        private int nTrianglesGenerated;
        private boolean errorFlag;

        private TessellatorCallback() {
        }

        public void reset(VertexAccumulator accumulator) {
            this.errorFlag = false;
            this.currentAdapter = null;
            this.currentAccumulator = accumulator;
            this.nTrianglesGenerated = 0;
        }

        public void checkErrorFlag() throws TessellationException {
            if (this.errorFlag) {
                throw new TessellationException();
            }
        }

        public int getNumTrianglesGenerated() {
            return this.nTrianglesGenerated;
        }

        public void begin(int type) {
            if (type == 6) {
                this.currentAdapter = new TriangleFanAdapter();
            }
            if (type == 5) {
                this.currentAdapter = new TriangleStripAdapter();
            }
            if (type == 4) {
                this.currentAdapter = new TriangleAdapter();
            }
            if (this.currentAdapter == null) {
                this.errorFlag = true;
            }
        }

        public void end() {
            this.currentAdapter = null;
        }

        public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
            double[] vertex = new double[]{coords[0], coords[1], coords[2]};
            outData[0] = vertex;
        }

        public void vertex(Object vertexData) {
            this.currentAdapter.processVertex((double[])vertexData);
        }

        public void edgeFlag(boolean boundaryEdge) {
        }

        public void error(int errnum) {
            this.errorFlag = true;
        }

        public void beginData(int type, Object polygonData) {
        }

        public void endData(Object polygonData) {
        }

        public void vertexData(Object arg0, Object arg1) {
        }

        public void combineData(double[] coords, Object[] data, float[] weight, Object[] outData, Object polygonData) {
        }

        public void edgeFlagData(boolean boundaryEdge, Object polygonData) {
        }

        public void errorData(int errnum, Object polygonData) {
        }

        private final class TriangleAdapter
        implements Adapter {
            private double[] prevVertex;
            private double[] prevPrevVertex;

            private TriangleAdapter() {
            }

            @Override
            public void processVertex(double[] vertex) {
                if (this.prevPrevVertex == null) {
                    this.prevPrevVertex = vertex;
                    return;
                }
                if (this.prevVertex == null) {
                    this.prevVertex = vertex;
                    return;
                }
                TessellatorCallback.this.currentAccumulator.addVertices(this.prevPrevVertex, 1);
                TessellatorCallback.this.currentAccumulator.addVertices(this.prevVertex, 1);
                TessellatorCallback.this.currentAccumulator.addVertices(vertex, 1);
                this.prevPrevVertex = null;
                this.prevVertex = null;
                TessellatorCallback.this.nTrianglesGenerated++;
            }
        }

        private final class TriangleStripAdapter
        implements Adapter {
            private double[] prevVertex;
            private double[] prevPrevVertex;

            private TriangleStripAdapter() {
            }

            @Override
            public void processVertex(double[] vertex) {
                if (this.prevVertex == null) {
                    this.prevVertex = vertex;
                    return;
                }
                if (this.prevPrevVertex != null && TessellatorCallback.this.currentAccumulator != null) {
                    TessellatorCallback.this.currentAccumulator.addVertices(this.prevPrevVertex, 1);
                    TessellatorCallback.this.currentAccumulator.addVertices(this.prevVertex, 1);
                    TessellatorCallback.this.currentAccumulator.addVertices(vertex, 1);
                    TessellatorCallback.this.nTrianglesGenerated++;
                }
                this.prevPrevVertex = this.prevVertex;
                this.prevVertex = vertex;
            }
        }

        private final class TriangleFanAdapter
        implements Adapter {
            private double[] origin;
            private double[] prevVertex;

            private TriangleFanAdapter() {
            }

            @Override
            public void processVertex(double[] vertex) {
                if (this.origin == null) {
                    this.origin = vertex;
                    return;
                }
                if (this.prevVertex != null && TessellatorCallback.this.currentAccumulator != null) {
                    TessellatorCallback.this.currentAccumulator.addVertices(this.origin, 1);
                    TessellatorCallback.this.currentAccumulator.addVertices(vertex, 1);
                    TessellatorCallback.this.currentAccumulator.addVertices(this.prevVertex, 1);
                    TessellatorCallback.this.nTrianglesGenerated++;
                }
                this.prevVertex = vertex;
            }
        }
    }
}

