/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.polygon;

import com.metsci.glimpse.support.polygon.VertexAccumulator;
import com.metsci.glimpse.util.PrimitiveVector;
import java.util.ArrayList;
import java.util.Iterator;

public class Polygon {
    private ArrayList<Loop> loops = new ArrayList();

    public final void add(Loop loop) {
        this.loops.add(loop);
    }

    public Iterator<Loop> getIterator() {
        return this.loops.listIterator();
    }

    public static final class Loop {
        private final double[] data;
        private final Interior side;

        public static LoopBuilder start() {
            return new LoopBuilder();
        }

        private Loop(double[] data, Interior side) {
            this.data = data;
            this.side = side;
        }

        public final int size() {
            return this.data.length / 2;
        }

        public Interior getSide() {
            return this.side;
        }

        public final double[] get(int i) {
            return new double[]{this.data[2 * i], this.data[2 * i + 1], 0.0};
        }

        public static final class LoopBuilder
        implements VertexAccumulator {
            PrimitiveVector.Double data = new PrimitiveVector.Double();

            @Override
            public void addVertices(double[] vertexData, int nVertices) {
                this.data.add(vertexData, 0, 2 * nVertices);
            }

            @Override
            public void addVertices(float[] vertexData, int nVertices) {
                this.data.add(vertexData, 0, 2 * nVertices);
            }

            public final Loop complete(Interior side) {
                return new Loop(this.data.getCopiedData(), side);
            }
        }
    }

    public static enum Interior {
        onLeft,
        onRight;

    }
}

