/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.font;

import com.metsci.glimpse.util.io.StreamOpener;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.util.logging.Logger;

public class FontUtils {
    private static final Logger logger = Logger.getLogger(FontUtils.class.getSimpleName());
    private static final boolean foundVerdana;

    public static Font getDefaultPlain(float size) {
        return foundVerdana ? FontUtils.getVerdanaPlain(size) : FontUtils.getBitstreamVeraSansPlain(size);
    }

    public static Font getDefaultBold(float size) {
        return foundVerdana ? FontUtils.getVerdanaBold(size) : FontUtils.getBitstreamVeraSansBold(size);
    }

    public static Font getDefaultItalic(float size) {
        return foundVerdana ? FontUtils.getVerdanaItalic(size) : FontUtils.getBitstreamVeraSansItalic(size);
    }

    public static Font getDefaultBoldItalic(float size) {
        return foundVerdana ? FontUtils.getVerdanaBoldItalic(size) : FontUtils.getBitstreamVeraSansBoldItalic(size);
    }

    public static Font getBitstreamVeraSansPlain(float size) {
        return FontUtils.loadTrueTypeFont("fonts/bitstream/Vera.ttf", size, 0);
    }

    public static Font getBitstreamVeraSansBold(float size) {
        return FontUtils.loadTrueTypeFont("fonts/bitstream/VeraBd.ttf", size, 1);
    }

    public static Font getBitstreamVeraSansItalic(float size) {
        return FontUtils.loadTrueTypeFont("fonts/bitstream/Veralt.ttf", size, 2);
    }

    public static Font getBitstreamVeraSansBoldItalic(float size) {
        return FontUtils.loadTrueTypeFont("fonts/bitstream/Veralt.ttf", size, 3);
    }

    public static Font getSilkscreen() {
        return FontUtils.getSilkscreenPlain();
    }

    public static Font getSilkscreenPlain() {
        return FontUtils.loadTrueTypeFont("fonts/silkscreen/slkscr.ttf", 8.0f, 0);
    }

    public static Font getSilkscreenBold() {
        return FontUtils.loadTrueTypeFont("fonts/silkscreen/slkscrb.ttf", 8.0f, 1);
    }

    public static Font getSilkscreenItalic() {
        return FontUtils.loadTrueTypeFont("fonts/silkscreen/slkscre.ttf", 8.0f, 2);
    }

    public static Font getSilkscreenBoldItalic() {
        return FontUtils.loadTrueTypeFont("fonts/silkscreen/slkscreb.ttf", 8.0f, 3);
    }

    public static Font getVerdanaPlain(float size) {
        return Font.decode("Verdana").deriveFont(size).deriveFont(0);
    }

    public static Font getVerdanaBold(float size) {
        return Font.decode("Verdana").deriveFont(size).deriveFont(1);
    }

    public static Font getVerdanaItalic(float size) {
        return Font.decode("Verdana").deriveFont(size).deriveFont(2);
    }

    public static Font getVerdanaBoldItalic(float size) {
        return Font.decode("Verdana").deriveFont(size).deriveFont(3);
    }

    public static Font loadTrueTypeFont(String filename, float size, int style) {
        try {
            return Font.createFont(0, StreamOpener.fileThenResource.openForRead(filename)).deriveFont(style, size);
        }
        catch (FontFormatException e) {
            throw new RuntimeException("Could not load font.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load font.", e);
        }
    }

    static {
        boolean foundVerdanaTemp = false;
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        if (fonts != null) {
            for (String font : fonts) {
                if (font == null || !font.equals("Verdana")) continue;
                foundVerdanaTemp = true;
                break;
            }
        }
        if (!foundVerdanaTemp) {
            logger.warning("Verdana font is not installed. Falling back to Bitstream Vera Sans. Verdana looks *much* nicer but cannot be packaged with Glimpse due to licensing restrictions. For information on installing Verdana see: https://github.com/metsci/glimpse/wiki/Verdana-Font");
        }
        foundVerdana = foundVerdanaTemp;
    }
}

