/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.colormap;

import com.metsci.glimpse.support.colormap.ColorGradient;

public class ColorGradients {
    public static final ColorGradient clearToBlack = new ColorGradient(){

        @Override
        public void toColor(float fraction, float[] rgba) {
            rgba[0] = 0.0f;
            rgba[1] = 0.0f;
            rgba[2] = 0.0f;
            rgba[3] = fraction;
        }
    };
    public static final ColorGradient blackToClear = new ColorGradient(){

        @Override
        public void toColor(float fraction, float[] rgba) {
            rgba[0] = 0.0f;
            rgba[1] = 0.0f;
            rgba[2] = 0.0f;
            rgba[3] = 1.0f - fraction;
        }
    };
    public static final ColorGradient gray = new ColorGradient(){

        @Override
        public void toColor(float fraction, float[] rgba) {
            rgba[0] = fraction;
            rgba[1] = fraction;
            rgba[2] = fraction;
            rgba[3] = 1.0f;
        }
    };
    public static final ColorGradient jet = new ColorGradient(){

        @Override
        public void toColor(float fraction, float[] rgba) {
            float x = 4.0f * fraction;
            int segment = (int)(8.0f * fraction);
            switch (segment) {
                case 0: {
                    rgba[0] = 0.0f;
                    rgba[1] = 0.0f;
                    rgba[2] = 0.5f + x;
                    break;
                }
                case 1: 
                case 2: {
                    rgba[0] = 0.0f;
                    rgba[1] = -0.5f + x;
                    rgba[2] = 1.0f;
                    break;
                }
                case 3: 
                case 4: {
                    rgba[0] = -1.5f + x;
                    rgba[1] = 1.0f;
                    rgba[2] = 2.5f - x;
                    break;
                }
                case 5: 
                case 6: {
                    rgba[0] = 1.0f;
                    rgba[1] = 3.5f - x;
                    rgba[2] = 0.0f;
                    break;
                }
                default: {
                    rgba[0] = 4.5f - x;
                    rgba[1] = 0.0f;
                    rgba[2] = 0.0f;
                }
            }
            rgba[3] = 1.0f;
        }
    };
    public static final ColorGradient reverseBone = new ColorGradient(){

        @Override
        public void toColor(float fraction, float[] rgba) {
            float x = 1.0f - 0.875f * fraction;
            if ((double)fraction < 0.375) {
                rgba[0] = x;
                rgba[1] = x;
                rgba[2] = x - fraction / 3.0f;
            } else if ((double)fraction < 0.75) {
                rgba[0] = x;
                rgba[1] = x + 0.125f - fraction / 3.0f;
                rgba[2] = x - 0.125f;
            } else {
                rgba[0] = x + 0.375f - fraction * 0.5f;
                rgba[1] = x - 0.125f;
                rgba[2] = x - 0.125f;
            }
            rgba[3] = 1.0f;
        }
    };
    public static final ColorGradient bathymetry = new ColorGradient(){

        @Override
        public void toColor(float fraction, float[] rgba) {
            float bathyMin = -10000.0f;
            float dataVal = (1.0f - fraction) * -8000.0f;
            if ((double)dataVal < -5000.0) {
                rgba[0] = 0.0f;
                rgba[1] = 0.0f;
                rgba[2] = (192.0f / (-5000.0f - bathyMin) * dataVal + 192.0f + 960000.0f / (-5000.0f - bathyMin) + 0.5f) / 255.0f;
            } else if ((double)dataVal < -2500.0) {
                rgba[0] = 0.0f;
                rgba[1] = (0.0768f * dataVal + 384.0f + 0.5f) / 255.0f;
                rgba[2] = (0.0252f * dataVal + 318.0f + 0.5f) / 255.0f;
            } else if ((double)dataVal < -500.0) {
                rgba[0] = 0.0f;
                rgba[1] = (0.0315f * dataVal + 270.75f + 0.5f) / 255.0f;
                rgba[2] = 1.0f;
            } else {
                rgba[0] = (0.256f * dataVal + 128.0f + 0.5f) / 255.0f;
                rgba[1] = 1.0f;
                rgba[2] = 1.0f;
            }
            rgba[3] = 1.0f;
        }
    };
    public static final ColorGradient topography = new ColorGradient(){

        @Override
        public void toColor(float fraction, float[] rgba) {
            float bathyMax = 8000.0f;
            float dataVal = fraction * 8000.0f;
            if ((double)dataVal < 1000.0) {
                rgba[0] = (0.255f * dataVal + 0.5f) / 255.0f;
                rgba[1] = (0.081f * dataVal + 174.0f + 0.5f) / 255.0f;
                rgba[2] = 0.0f;
            } else if ((double)dataVal < 3000.0) {
                rgba[0] = 1.0f;
                rgba[1] = (-0.0635f * dataVal + 318.5f + 0.5f) / 255.0f;
                rgba[2] = 0.0f;
            } else if ((double)dataVal < 5000.0) {
                rgba[0] = 1.0f;
                rgba[1] = (-0.064f * dataVal + 320.0f + 0.5f) / 255.0f;
                rgba[2] = 0.0f;
            } else {
                rgba[0] = (255.0f / (5000.0f - bathyMax) * dataVal + 255.0f - 1275000.0f / (5000.0f - bathyMax) + 0.5f) / 255.0f;
                rgba[1] = 0.0f;
                rgba[2] = 0.0f;
            }
            rgba[3] = 1.0f;
        }
    };

    public static ColorGradient reverse(final ColorGradient gradient) {
        return new ColorGradient(){

            @Override
            public void toColor(float fraction, float[] rgba) {
                gradient.toColor(1.0f - fraction, rgba);
            }
        };
    }

    private ColorGradients() {
    }
}

