/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.timeline.listener;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.tagged.Tag;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.axis.tagged.TaggedAxisMouseListener1D;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.ModifierKey;
import com.metsci.glimpse.event.mouse.MouseButton;
import com.metsci.glimpse.plot.StackedPlot2D;
import com.metsci.glimpse.plot.timeline.StackedTimePlot2D;
import java.util.List;

public class TimelineMouseListener1D
extends TaggedAxisMouseListener1D {
    protected boolean dragTogether = false;
    protected boolean onlyMoveCurrent = false;
    protected StackedTimePlot2D plot;
    protected boolean timeIsX;

    public TimelineMouseListener1D(StackedTimePlot2D plot) {
        super(25);
        this.timeIsX = plot.getOrientation() == StackedPlot2D.Orientation.VERTICAL;
        this.plot = plot;
    }

    public Tag getSelectedTag() {
        return this.selectedTag;
    }

    @Override
    public void mousePressed(GlimpseMouseEvent e, Axis1D axis, boolean horizontal) {
        super.mousePressed(e, axis, horizontal);
        if (this.allowSelectionLock && e.isButtonDown(MouseButton.Button3)) {
            if (this.plot.isCurrentTimeLocked() || this.plot.isSelectionLocked()) {
                this.plot.setCurrentTimeLocked(false);
                this.plot.setSelectionLocked(false);
            } else {
                this.plot.setSelectionLocked(!this.plot.isSelectionLocked());
            }
        }
    }

    @Override
    protected Tag getSelectedTag(TaggedAxis1D taggedAxis, List<Tag> tags, int mousePos, int maxPixelDist) {
        Tag minTag = taggedAxis.getTag("min_time");
        Tag maxTag = taggedAxis.getTag("max_time");
        Tag currentTag = taggedAxis.getTag("current_time");
        this.dragTogether = false;
        double maxDistance = (double)maxPixelDist / taggedAxis.getPixelsPerValue();
        double mouseValue = taggedAxis.screenPixelToValue(mousePos);
        boolean closeToMin = Math.abs(mouseValue - minTag.getValue()) < maxDistance;
        boolean closeToMax = Math.abs(mouseValue - maxTag.getValue()) < maxDistance;
        Tag selectedTag = null;
        if (closeToMin) {
            selectedTag = minTag;
        } else if (closeToMax) {
            selectedTag = maxTag;
        } else if (Math.abs(mouseValue - currentTag.getValue()) < maxDistance) {
            selectedTag = currentTag;
        }
        return selectedTag;
    }

    @Override
    public void mouseMoved(GlimpseMouseEvent e, Axis1D axis, boolean horizontal) {
        TaggedAxis1D taggedAxis = (TaggedAxis1D)axis;
        Tag minTag = taggedAxis.getTag("min_time");
        Tag maxTag = taggedAxis.getTag("max_time");
        Tag currentTag = taggedAxis.getTag("current_time");
        if (e.isKeyDown(ModifierKey.Ctrl) && e.isButtonDown(MouseButton.Button1) && this.selectedTag != null) {
            this.anchor(axis, horizontal, e.getX(), e.getY());
            int mousePosPixels = this.getDim(horizontal, e.getX(), taggedAxis.getSizePixels() - e.getY());
            int panPixels = this.getDim(horizontal, this.anchorPixelsX, this.anchorPixelsY) - mousePosPixels;
            double panValue = (double)panPixels / taggedAxis.getPixelsPerValue();
            double newTagValue = this.tagAnchor - panValue;
            this.selectedTag.setValue(newTagValue);
        } else if (e.isButtonDown(MouseButton.Button1) && !this.plot.isCurrentTimeLocked()) {
            this.pan(axis, horizontal, e.getX(), e.getY());
        } else if (!this.plot.isSelectionLocked() && !this.plot.isCurrentTimeLocked()) {
            int mousePosPixels = this.getDim(horizontal, e.getX(), taggedAxis.getSizePixels() - e.getY());
            double mousePosValue = taggedAxis.screenPixelToValue(mousePosPixels);
            double minDiff = minTag.getValue() - currentTag.getValue();
            double maxDiff = maxTag.getValue() - currentTag.getValue();
            minTag.setValue(mousePosValue + minDiff);
            maxTag.setValue(mousePosValue + maxDiff);
            currentTag.setValue(mousePosValue);
        }
        taggedAxis.validateTags();
        taggedAxis.validate();
        this.notifyTagsUpdated(taggedAxis);
    }

    @Override
    public void mouseWheelMoved(GlimpseMouseEvent e) {
        TaggedAxis1D taggedAxis = this.getTaggedAxis1D(e);
        if (taggedAxis == null) {
            return;
        }
        if (e.isKeyDown(ModifierKey.Ctrl) || e.isKeyDown(ModifierKey.Meta)) {
            this.handleCtrlMouseWheel(e);
        } else if (this.timeIsX) {
            this.mouseWheelMoved(e, taggedAxis, true);
        } else {
            this.mouseWheelMoved(e, taggedAxis, false);
        }
        taggedAxis.validateTags();
        taggedAxis.validate();
        this.notifyTagsUpdated(taggedAxis);
    }

    public void handleCtrlMouseWheel(GlimpseMouseEvent e) {
        TaggedAxis1D taggedAxis = this.getTaggedAxis1D(e);
        if (taggedAxis == null) {
            return;
        }
        Tag minTag = taggedAxis.getTag("min_time");
        Tag maxTag = taggedAxis.getTag("max_time");
        Tag currentTag = taggedAxis.getTag("current_time");
        double minValue = minTag.getValue();
        double maxValue = maxTag.getValue();
        double selectionSize = maxValue - minValue;
        int zoomIncrements = e.getWheelIncrement();
        double zoomPercentDbl = 1.0;
        for (int i = 0; i < Math.abs(zoomIncrements); ++i) {
            zoomPercentDbl *= 1.119999997317791;
        }
        zoomPercentDbl = zoomIncrements > 0 ? 1.0 / zoomPercentDbl : zoomPercentDbl;
        double newSelectionSize = selectionSize * zoomPercentDbl;
        minTag.setValue(maxValue - newSelectionSize);
        maxTag.setValue(maxValue);
        currentTag.setValue(maxValue);
        taggedAxis.validateTags();
        taggedAxis.validate();
        this.notifyTagsUpdated(minTag.getValue(), maxTag.getValue(), currentTag.getValue());
    }

    protected TaggedAxis1D getTaggedAxis1D(GlimpseMouseEvent e) {
        return (TaggedAxis1D)e.getAxis1D();
    }

    protected void moveAllTags(TaggedAxis1D taggedAxis, double deltaTagValue) {
        for (Tag tag : taggedAxis.getSortedTags()) {
            tag.setValue(tag.getValue() + deltaTagValue);
        }
    }

    protected void notifyTagsUpdated(TaggedAxis1D timeAxis) {
        List<Tag> tags = timeAxis.getSortedTags();
        this.notifyTagsUpdated(tags.get(0).getValue(), tags.get(2).getValue(), tags.get(1).getValue());
    }

    protected void notifyTagsUpdated(double startValue, double endValue, double selectedValue) {
    }
}

