/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.timeline;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.painter.NumericXYAxisPainter;
import com.metsci.glimpse.axis.painter.TimeAxisPainter;
import com.metsci.glimpse.axis.painter.TimeXAxisPainter;
import com.metsci.glimpse.axis.painter.TimeYAxisPainter;
import com.metsci.glimpse.axis.painter.label.GridAxisLabelHandler;
import com.metsci.glimpse.axis.tagged.Constraint;
import com.metsci.glimpse.axis.tagged.Tag;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.layout.GlimpseAxisLayout1D;
import com.metsci.glimpse.layout.GlimpseAxisLayoutX;
import com.metsci.glimpse.layout.GlimpseAxisLayoutY;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.painter.decoration.BorderPainter;
import com.metsci.glimpse.painter.decoration.GridPainter;
import com.metsci.glimpse.painter.group.DelegatePainter;
import com.metsci.glimpse.painter.info.SimpleTextPainter;
import com.metsci.glimpse.plot.StackedPlot2D;
import com.metsci.glimpse.plot.timeline.data.Epoch;
import com.metsci.glimpse.plot.timeline.layout.TimePlotInfo;
import com.metsci.glimpse.plot.timeline.listener.TimelineMouseListener1D;
import com.metsci.glimpse.plot.timeline.listener.TimelineMouseListener2D;
import com.metsci.glimpse.plot.timeline.painter.SelectedTimeRegionPainter;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.FontUtils;
import com.metsci.glimpse.util.units.time.Time;
import com.metsci.glimpse.util.units.time.TimeStamp;
import java.awt.Font;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StackedTimePlot2D
extends GlimpseLayout {
    public static final String MIN_TIME = "min_time";
    public static final String MAX_TIME = "max_time";
    public static final String CURRENT_TIME = "current_time";
    public static final String BACKGROUND = "Timeline Background";
    public static final String TIMELINE = "Timeline";
    protected Tag minTag;
    protected Tag maxTag;
    protected Tag currentTag;
    protected GlimpseAxisLayout1D overlayLayout;
    protected GlimpseAxisLayout1D timeLayout;
    protected DelegatePainter timeAxisDelegate;
    protected TimeAxisPainter timeAxisPainter;
    protected StackedPlot2D delegatePlot;
    protected StackedPlot2D.PlotInfo selectedLayout;
    protected TimelineMouseListener1D timelineMouseListener;
    protected SimpleTextPainter timeUnitsPainter;
    protected boolean allowPanX = true;
    protected boolean allowPanY = true;
    protected boolean allowZoomX = true;
    protected boolean allowZoomY = true;
    protected boolean allowSelectionLock = true;
    protected boolean currentTimeLock;
    protected Epoch epoch;
    protected Map<String, TimePlotInfo> stackedTimePlots;

    public StackedTimePlot2D() {
        this(StackedPlot2D.Orientation.VERTICAL, Epoch.posixEpoch());
    }

    public StackedTimePlot2D(Epoch epoch) {
        this(StackedPlot2D.Orientation.VERTICAL, epoch);
    }

    public StackedTimePlot2D(StackedPlot2D.Orientation orientation) {
        this(orientation, Epoch.posixEpoch());
    }

    public StackedTimePlot2D(StackedPlot2D.Orientation orientation, Epoch epoch) {
        super(StackedTimePlot2D.class.getSimpleName());
        this.epoch = epoch;
        this.stackedTimePlots = new HashMap<String, TimePlotInfo>();
        this.delegatePlot = new StackedPlot2D(orientation){

            @Override
            protected TaggedAxis1D createCommonAxis() {
                return new TaggedAxis1D();
            }
        };
        this.initialize();
    }

    public GlimpseAxisLayout1D getOverlayLayout() {
        return this.overlayLayout;
    }

    public GlimpseAxisLayout1D getTimelineLayout() {
        return this.timeLayout;
    }

    public Collection<StackedPlot2D.PlotInfo> getAllPlots() {
        return this.delegatePlot.getAllPlots();
    }

    public Collection<TimePlotInfo> getAllTimePlots() {
        return Collections.unmodifiableCollection(this.stackedTimePlots.values());
    }

    public void deletePlot(String name) {
        this.delegatePlot.deletePlot(name);
        this.stackedTimePlots.remove(name);
    }

    public StackedPlot2D.PlotInfo getPlot(String name) {
        return this.delegatePlot.getPlot(name);
    }

    public TimePlotInfo getTimePlot(String name) {
        return this.stackedTimePlots.get(name);
    }

    public void setSelectedPlot(String name) {
        this.setSelectedPlot(this.getPlot(name));
    }

    public void setSelectedPlot(StackedPlot2D.PlotInfo layout) {
        this.selectedLayout = layout;
    }

    public StackedPlot2D.PlotInfo getSelectedPlot() {
        return this.selectedLayout;
    }

    public void setAllowSelectionLock(boolean lock) {
        this.allowSelectionLock = lock;
        this.timelineMouseListener.setAllowSelectionLock(lock);
        for (TimePlotInfo info : this.getAllTimePlots()) {
            info.getTimelineMouseListener().setAllowSelectionLock(lock);
        }
    }

    public void setAllowZoomY(boolean lock) {
        this.allowZoomY = lock;
        if (this.getOrientation() == StackedPlot2D.Orientation.HORIZONTAL) {
            this.timelineMouseListener.setAllowZoom(lock);
        }
        for (TimePlotInfo info : this.getAllTimePlots()) {
            info.getTimelineMouseListener().setAllowZoomY(lock);
        }
    }

    public void setAllowZoomX(boolean lock) {
        this.allowZoomX = lock;
        if (this.getOrientation() == StackedPlot2D.Orientation.VERTICAL) {
            this.timelineMouseListener.setAllowZoom(lock);
        }
        for (TimePlotInfo info : this.getAllTimePlots()) {
            info.getTimelineMouseListener().setAllowZoomX(lock);
        }
    }

    public void setAllowPanY(boolean lock) {
        this.allowPanY = lock;
        if (this.getOrientation() == StackedPlot2D.Orientation.HORIZONTAL) {
            this.timelineMouseListener.setAllowPan(lock);
        }
        for (TimePlotInfo info : this.getAllTimePlots()) {
            info.getTimelineMouseListener().setAllowPanY(lock);
        }
    }

    public void setAllowPanX(boolean lock) {
        this.allowPanX = lock;
        if (this.getOrientation() == StackedPlot2D.Orientation.VERTICAL) {
            this.timelineMouseListener.setAllowPan(lock);
        }
        for (TimePlotInfo info : this.getAllTimePlots()) {
            info.getTimelineMouseListener().setAllowPanX(lock);
        }
    }

    public Tag getTimeSelection() {
        return this.currentTag;
    }

    public Tag getTimeSelectionMin() {
        return this.minTag;
    }

    public Tag getTimeSelectionMax() {
        return this.maxTag;
    }

    public StackedPlot2D.Orientation getOrientation() {
        return this.delegatePlot.getOrientation();
    }

    public Epoch getEpoch() {
        return this.epoch;
    }

    public void setEpoch(Epoch epoch) {
        this.epoch = epoch;
        this.timeAxisPainter.setEpoch(epoch);
    }

    public TimeStamp toTimeStamp(double value) {
        return this.epoch.toTimeStamp(value);
    }

    public double fromTimeStamp(TimeStamp value) {
        return this.epoch.fromTimeStamp(value);
    }

    public TaggedAxis1D getTimeAxis() {
        return (TaggedAxis1D)this.delegatePlot.getCommonAxis();
    }

    public void setTimeAxisPainter(TimeAxisPainter painter) {
        this.timeAxisDelegate.removePainter(this.timeAxisPainter);
        this.timeAxisPainter = painter;
        this.timeAxisDelegate.addPainter(this.timeAxisPainter);
    }

    public TimeAxisPainter getTimeAxisPainter() {
        return this.timeAxisPainter;
    }

    public void setAxisColor(float[] rgba) {
        this.timeAxisPainter.setTextColor(rgba);
        this.timeAxisPainter.setTickColor(rgba);
    }

    public void setAxisFont(Font font) {
        this.timeAxisPainter.setFont(font);
    }

    public void setShowCurrentTime(boolean show) {
        this.timeAxisPainter.showCurrentTimeLabel(show);
    }

    public void setCurrentTimeColor(float[] rgba) {
        this.timeAxisPainter.setCurrentTimeTextColor(rgba);
        this.timeAxisPainter.setCurrentTimeTickColor(rgba);
    }

    public void setBackgroundColor(float[] rgba) {
        this.delegatePlot.setBackgroundColor(rgba);
    }

    public void setBorderSize(int size) {
        this.delegatePlot.setBorderSize(size);
    }

    public void validate() {
        this.delegatePlot.validate();
    }

    public GlimpseTargetStack pushLayoutTargetStack(GlimpseTargetStack stack, String name) {
        stack = this.pushPlotTargetStack(stack);
        StackedPlot2D.PlotInfo plot = this.delegatePlot.getPlot(name);
        stack.push(plot.getLayout());
        return stack;
    }

    public GlimpseTargetStack pushPlotTargetStack(GlimpseTargetStack stack) {
        stack.push(this);
        stack.push(this.delegatePlot);
        return stack;
    }

    public StackedPlot2D.PlotInfo createPlot(String name) {
        return this.createPlot(name, new Axis1D());
    }

    public StackedPlot2D.PlotInfo createPlot(String name, Axis1D axis) {
        StackedPlot2D.PlotInfo layoutInfo = this.delegatePlot.createPlot(name, axis);
        this.attachTimelineMouseListener(layoutInfo);
        return layoutInfo;
    }

    public TimePlotInfo createTimePlot(String name) {
        return this.createTimePlot(name, new Axis1D());
    }

    public TimePlotInfo createTimePlot(String name, Axis1D axis) {
        StackedPlot2D.PlotInfo layoutInfo = this.delegatePlot.createPlot(name, axis);
        GridAxisLabelHandler labelHandler = new GridAxisLabelHandler(){

            @Override
            protected String tickString(double number, int orderAxis) {
                return this.tickNumberFormatter.format(number);
            }

            @Override
            protected void updateFormatter(int orderAxis, int orderTick) {
                this.tickNumberFormatter.setMaximumFractionDigits(Math.abs(orderTick));
            }
        };
        DelegatePainter dataPainter = new DelegatePainter();
        layoutInfo.getLayout().addPainter(dataPainter);
        GridPainter gridPainter = new GridPainter(labelHandler, labelHandler);
        gridPainter.setShowMinorGrid(false);
        layoutInfo.getLayout().addPainter(gridPainter);
        NumericXYAxisPainter axisPainter = new NumericXYAxisPainter(labelHandler, labelHandler);
        axisPainter.setFont(FontUtils.getDefaultPlain(9.0f), false);
        axisPainter.setShowLabelsNearOrigin(true);
        axisPainter.setShowOriginLabel(true);
        layoutInfo.getLayout().addPainter(axisPainter);
        SimpleTextPainter labelPainter = new SimpleTextPainter();
        labelPainter.setHorizontalPosition(SimpleTextPainter.HorizontalPosition.Center);
        labelPainter.setVerticalPosition(SimpleTextPainter.VerticalPosition.Top);
        labelPainter.setFont(FontUtils.getDefaultBold(9.0f), false);
        labelPainter.setPadding(2);
        labelPainter.setText("");
        layoutInfo.getLayout().addPainter(labelPainter);
        BorderPainter borderPainter = new BorderPainter();
        layoutInfo.getLayout().addPainter(borderPainter);
        TimelineMouseListener2D listener = this.attachTimelineMouseListener(layoutInfo);
        TimePlotInfo timePlotInfo = new TimePlotInfo(this, layoutInfo, listener, gridPainter, axisPainter, labelPainter, borderPainter, dataPainter);
        if (this.timeIsX()) {
            gridPainter.setShowVerticalLines(false);
            labelHandler.setTickSpacing(16);
            axisPainter.setShowVerticalTicks(true);
            axisPainter.setShowHorizontalTicks(false);
            axisPainter.setLockLeft(true);
            labelPainter.setHorizontalPosition(SimpleTextPainter.HorizontalPosition.Center);
            labelPainter.setVerticalPosition(SimpleTextPainter.VerticalPosition.Top);
        } else {
            gridPainter.setShowHorizontalLines(false);
            labelHandler.setTickSpacing(45);
            axisPainter.setShowVerticalTicks(false);
            axisPainter.setShowHorizontalTicks(true);
            axisPainter.setLockTop(true);
            labelPainter.setHorizontalPosition(SimpleTextPainter.HorizontalPosition.Center);
            labelPainter.setVerticalPosition(SimpleTextPainter.VerticalPosition.Bottom);
        }
        this.stackedTimePlots.put(name, timePlotInfo);
        return timePlotInfo;
    }

    public boolean isLocked() {
        return this.isSelectionLocked() || this.isCurrentTimeLocked();
    }

    public boolean isSelectionLocked() {
        return this.getTimeAxis().isSelectionLocked();
    }

    public void setSelectionLocked(boolean lock) {
        this.getTimeAxis().setSelectionLock(lock);
        this.getTimeAxis().validate();
    }

    public boolean isCurrentTimeLocked() {
        return this.currentTimeLock;
    }

    public void setCurrentTimeLocked(boolean lock) {
        this.currentTimeLock = lock;
        if (lock) {
            double maxValue = this.maxTag.getValue();
            TimeStamp maxTime = this.epoch.toTimeStamp(maxValue);
            this.shiftTimeSelection(maxTime);
            this.shiftTimeAxisBounds(maxTime);
            this.getTimeAxis().lockMax(maxValue);
        } else {
            this.getTimeAxis().unlockMax();
        }
        this.getTimeAxis().validate();
    }

    public void setTimeSelection(TimeStamp minTime, TimeStamp selectedTime, TimeStamp maxTime) {
        this.minTag.setValue(this.epoch.fromTimeStamp(minTime));
        this.maxTag.setValue(this.epoch.fromTimeStamp(maxTime));
        this.currentTag.setValue(this.epoch.fromTimeStamp(selectedTime));
        TaggedAxis1D axis = this.getTimeAxis();
        axis.validateTags();
        axis.validate();
        if (this.isCurrentTimeLocked()) {
            this.shiftTimeAxisBounds(maxTime);
        }
    }

    public void setTimeAxisBounds(TimeStamp minTime, TimeStamp maxTime) {
        TaggedAxis1D axis = this.getTimeAxis();
        axis.setMax(this.epoch.fromTimeStamp(maxTime));
        axis.setMin(this.epoch.fromTimeStamp(minTime));
        axis.validate();
        if (this.isCurrentTimeLocked()) {
            this.shiftTimeSelection(maxTime);
        }
    }

    public void shiftTimeAxisBounds(TimeStamp maxTime) {
        TaggedAxis1D axis = this.getTimeAxis();
        double diff = axis.getMax() - axis.getMin();
        double max = this.epoch.fromTimeStamp(maxTime);
        axis.setMax(max);
        axis.setMin(max - diff);
        axis.validate();
    }

    public void setTimeSelection(TimeStamp minTime, TimeStamp maxTime) {
        this.setTimeSelection(minTime, maxTime, maxTime);
    }

    public void shiftTimeSelection(TimeStamp maxTime) {
        double diff = Time.fromSeconds((double)(this.maxTag.getValue() - this.minTag.getValue()));
        TimeStamp minTime = maxTime.subtract(diff);
        this.setTimeSelection(minTime, maxTime, maxTime);
    }

    protected void initialize() {
        TaggedAxis1D timeAxis = this.getTimeAxis();
        this.addTimeTags(this.getTimeAxis());
        this.minTag = timeAxis.getTag(MIN_TIME);
        this.maxTag = timeAxis.getTag(MAX_TIME);
        this.currentTag = timeAxis.getTag(CURRENT_TIME);
        StackedPlot2D.PlotInfo timelineInfo = this.delegatePlot.createPlot(TIMELINE);
        if (this.timeIsX()) {
            timelineInfo.setSize(45);
            timelineInfo.setOrder(Integer.MAX_VALUE);
        } else {
            timelineInfo.setSize(60);
            timelineInfo.setOrder(Integer.MIN_VALUE);
        }
        this.timeLayout = this.timeIsX() ? new GlimpseAxisLayoutX(timelineInfo.getLayout()) : new GlimpseAxisLayoutY(timelineInfo.getLayout());
        this.timelineMouseListener = new TimelineMouseListener1D(this);
        this.timeLayout.addGlimpseMouseAllListener(this.timelineMouseListener);
        this.timeAxisPainter = this.createTimeAxisPainter(this.timeIsX());
        this.timeAxisPainter.setFont(FontUtils.getDefaultPlain(12.0f), false);
        this.timeAxisPainter.showCurrentTimeLabel(false);
        this.timeAxisPainter.setCurrentTimeTickColor(GlimpseColor.getGreen());
        this.delegatePlot.setBorderSize(0);
        this.timeAxisDelegate = new DelegatePainter();
        this.timeAxisDelegate.addPainter(this.timeAxisPainter);
        this.timeLayout.addPainter(this.timeAxisDelegate);
        this.timeUnitsPainter = new SimpleTextPainter();
        this.timeUnitsPainter.setHorizontalPosition(SimpleTextPainter.HorizontalPosition.Right);
        this.timeUnitsPainter.setVerticalPosition(SimpleTextPainter.VerticalPosition.Bottom);
        this.timeUnitsPainter.setColor(GlimpseColor.getBlack());
        this.timeUnitsPainter.setFont(FontUtils.getDefaultBold(12.0f));
        this.timeUnitsPainter.setText("GMT");
        this.timeUnitsPainter.setBackgroundColor(GlimpseColor.getYellow());
        this.timeUnitsPainter.setPaintBackground(true);
        this.timeLayout.addPainter(this.timeUnitsPainter);
        this.timeLayout.addPainter(new BorderPainter().setColor(GlimpseColor.fromColorRgba(0.8f, 0.8f, 0.8f, 1.0f)));
        this.addLayout(this.delegatePlot);
        this.overlayLayout = this.timeIsX() ? new GlimpseAxisLayoutX(this, "Overlay", timeAxis) : new GlimpseAxisLayoutY(this, "Overlay", timeAxis);
        this.overlayLayout.setEventConsumer(false);
        this.overlayLayout.addPainter(new SelectedTimeRegionPainter(this));
        this.overlayLayout.setLayoutData("pos 0 0 container.w container.h");
    }

    protected TimelineMouseListener2D attachTimelineMouseListener(StackedPlot2D.PlotInfo layoutInfo) {
        boolean timeIsX = this.delegatePlot.getOrientation() == StackedPlot2D.Orientation.VERTICAL;
        TimelineMouseListener2D mouseListener = new TimelineMouseListener2D(this, layoutInfo, timeIsX);
        mouseListener.setAllowPanX(this.allowPanX);
        mouseListener.setAllowPanY(this.allowPanY);
        mouseListener.setAllowZoomX(this.allowZoomX);
        mouseListener.setAllowZoomY(this.allowZoomY);
        mouseListener.setAllowSelectionLock(this.allowSelectionLock);
        layoutInfo.getLayout().addGlimpseMouseAllListener(mouseListener);
        return mouseListener;
    }

    protected TimeAxisPainter createTimeAxisPainter(boolean timeIsX) {
        TimeAxisPainter painter = this.timeIsX() ? new TimeXAxisPainter(this.epoch) : new TimeYAxisPainter(this.epoch);
        painter.setFont(FontUtils.getDefaultPlain(12.0f), false);
        painter.showCurrentTimeLabel(false);
        painter.setCurrentTimeTickColor(GlimpseColor.getGreen());
        return painter;
    }

    protected void addTimeTags(TaggedAxis1D axis) {
        axis.addTag(MIN_TIME, 0.0);
        axis.addTag(MAX_TIME, 10.0);
        axis.addTag(CURRENT_TIME, 10.0);
        axis.addConstraint(new Constraint(){

            @Override
            public void applyConstraint(TaggedAxis1D axis) {
                Tag minTag = axis.getTag(StackedTimePlot2D.MIN_TIME);
                Tag maxTag = axis.getTag(StackedTimePlot2D.MAX_TIME);
                Tag currentTag = axis.getTag(StackedTimePlot2D.CURRENT_TIME);
                double minValue = minTag.getValue();
                double maxValue = maxTag.getValue();
                double currentValue = currentTag.getValue();
                if (minValue > maxValue) {
                    minTag.setValue(maxValue);
                }
                if (currentValue < minValue) {
                    currentTag.setValue(minValue);
                } else if (currentValue > maxValue) {
                    currentTag.setValue(maxValue);
                }
            }

            @Override
            public String getName() {
                return "order";
            }
        });
    }

    protected boolean timeIsX() {
        return this.delegatePlot.getOrientation() == StackedPlot2D.Orientation.VERTICAL;
    }
}

