/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener;
import com.metsci.glimpse.axis.painter.NumericAxisPainter;
import com.metsci.glimpse.axis.painter.NumericRotatedRightYAxisPainter;
import com.metsci.glimpse.axis.painter.NumericRotatedYAxisPainter;
import com.metsci.glimpse.axis.painter.NumericTopXAxisPainter;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.axis.painter.label.GridAxisLabelHandler;
import com.metsci.glimpse.axis.painter.label.LatLonAxisLabelHandler;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.layout.GlimpseAxisLayoutX;
import com.metsci.glimpse.layout.GlimpseAxisLayoutY;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.decoration.BackgroundPainter;
import com.metsci.glimpse.painter.decoration.CrosshairPainter;
import com.metsci.glimpse.painter.decoration.GridPainter;
import com.metsci.glimpse.painter.decoration.MapBorderPainter;
import com.metsci.glimpse.painter.group.DelegatePainter;
import com.metsci.glimpse.plot.Plot2D;
import com.metsci.glimpse.util.geo.projection.GeoProjection;
import java.awt.Font;

public class MapPlot2D
extends Plot2D {
    protected MapBorderPainter borderPainter;
    protected BackgroundPainter plotBackgroundPainter;
    protected GridPainter gridPainter;
    protected DelegatePainter mapContentPainter;
    protected CrosshairPainter crosshairPainter;
    protected Axis2D outerContentAxis;
    protected DelegatePainter outerContentPainter;
    protected GeoProjection geoProjection;
    protected AxisMouseListener listenerTopX;
    protected AxisMouseListener listenerRightY;
    protected GlimpseLayout axisLayoutRightY;
    protected GlimpseLayout axisLayoutTopX;
    protected GlimpseAxisLayout2D mapContentLayout;
    protected NumericAxisPainter painterTopX;
    protected NumericAxisPainter painterRightY;
    protected GridAxisLabelHandler tickTopX;
    protected GridAxisLabelHandler tickRightY;

    public MapPlot2D(GeoProjection projection) {
        this.geoProjection = projection;
        this.initialize();
    }

    @Override
    protected void initializeAxes() {
        super.initializeAxes();
        this.outerContentAxis = this.getAxis().clone();
    }

    @Override
    protected void initializePainters() {
        this.axisLayoutTopX = new GlimpseAxisLayoutX(this, "AxisTopX", this.outerContentAxis.getAxisX());
        this.axisLayoutRightY = new GlimpseAxisLayoutY(this, "AxisRightX", this.outerContentAxis.getAxisY());
        this.outerContentPainter = new DelegatePainter();
        super.initializePainters();
        this.axisLayoutXY.setAxis(this.outerContentAxis);
        this.tickTopX = this.createLabelHandlerTopX();
        this.tickRightY = this.createLabelHandlerRightY();
        this.painterTopX = this.createPainterTopX(this.tickTopX);
        this.painterRightY = this.createPainterRightY(this.tickRightY);
        if (this.painterTopX != null) {
            this.axisLayoutTopX.addPainter(this.painterTopX);
        }
        if (this.painterRightY != null) {
            this.axisLayoutRightY.addPainter(this.painterRightY);
        }
        this.listenerTopX = this.createAxisMouseListenerX();
        this.listenerRightY = this.createAxisMouseListenerY();
        this.plotBackgroundPainter = new BackgroundPainter(false);
        this.axisLayoutXY.addPainter(this.plotBackgroundPainter);
        this.gridPainter = new GridPainter(this.tickX, this.tickY);
        this.axisLayoutXY.addPainter(this.gridPainter);
        this.borderPainter = new MapBorderPainter(this.tickX, this.tickY);
        this.axisLayoutXY.addPainter(this.borderPainter);
        this.mapContentPainter = new DelegatePainter();
        this.mapContentLayout = new GlimpseAxisLayout2D((GlimpseLayout)this.axisLayoutXY, this.getAxis());
        this.mapContentLayout.setName("Map");
        this.mapContentLayout.addPainter(this.mapContentPainter);
        this.outerContentPainter.addPainter(this.mapContentLayout);
        this.axisLayoutXY.addPainter(this.outerContentPainter);
        this.crosshairPainter = new CrosshairPainter();
        this.outerContentPainter.addPainter(this.crosshairPainter);
        this.setShowAxisMarkerX(false);
        this.setShowAxisMarkerY(false);
        this.setTickSpacingX(200);
        this.setTickSpacingY(200);
        this.setAxisSizeX(25);
        this.setAxisSizeY(25);
        this.setAxisSizeZ(0);
    }

    @Override
    public void attachAxisMouseListeners() {
        super.attachAxisMouseListeners();
        this.attachAxisMouseListener(this.axisLayoutTopX, this.listenerTopX);
        this.attachAxisMouseListener(this.axisLayoutRightY, this.listenerRightY);
        this.attachAxisMouseListener(this.mapContentLayout, this.mouseListenerXY);
    }

    @Override
    protected void updatePainterLayout() {
        this.getLayoutManager().setLayoutConstraints(String.format("bottomtotop, gapx 0, gapy 0, insets %d %d %d %d", this.getTopInset(), this.outerBorder, this.outerBorder, this.outerBorder));
        this.titleLayout.setLayoutData(String.format("cell 1 0 1 1, pushx, growx, height %d!", this.showTitle ? this.titleSpacing : 0));
        this.axisLayoutY.setLayoutData(String.format("cell 0 2 1 1, pushy, growy, width %d!", this.axisThicknessY));
        this.axisLayoutRightY.setLayoutData(String.format("cell 2 2 1 1, pushy, growy, width %d!", this.axisThicknessY));
        this.axisLayoutX.setLayoutData(String.format("cell 1 3 1 1, pushx, growx, height %d!", this.axisThicknessX));
        this.axisLayoutTopX.setLayoutData(String.format("cell 1 1 1 1, pushx, growx, height %d!", this.axisThicknessX));
        this.axisLayoutXY.setLayoutData("cell 1 2 1 1, push, grow");
        this.axisLayoutZ.setLayoutData(String.format("cell 3 2 1 1, pushy, growy, width %d!", this.axisThicknessZ));
        this.mapContentLayout.setLayoutData(String.format("gap %1$d %1$d %1$d %1$d, push, grow", this.borderPainter.getBorderSize()));
    }

    protected GridAxisLabelHandler createLabelHandlerTopX() {
        return new LatLonAxisLabelHandler(this.geoProjection, true);
    }

    protected GridAxisLabelHandler createLabelHandlerRightY() {
        return new LatLonAxisLabelHandler(this.geoProjection, false);
    }

    protected NumericAxisPainter createPainterTopX(AxisLabelHandler tickHandler) {
        NumericTopXAxisPainter painter = new NumericTopXAxisPainter(tickHandler);
        painter.setShowMarker(false);
        return painter;
    }

    protected NumericAxisPainter createPainterRightY(AxisLabelHandler tickHandler) {
        return new NumericRotatedRightYAxisPainter(tickHandler);
    }

    @Override
    protected NumericAxisPainter createAxisPainterY(AxisLabelHandler tickHandler) {
        return new NumericRotatedYAxisPainter(tickHandler);
    }

    @Override
    protected GridAxisLabelHandler createLabelHandlerX() {
        return new LatLonAxisLabelHandler(this.geoProjection, true);
    }

    @Override
    protected GridAxisLabelHandler createLabelHandlerY() {
        return new LatLonAxisLabelHandler(this.geoProjection, false);
    }

    public NumericAxisPainter getAxisPainterTopX() {
        return this.painterTopX;
    }

    public NumericAxisPainter getAxisPainterRightY() {
        return this.painterRightY;
    }

    public GlimpseLayout getLayoutPainterTopX() {
        return this.axisLayoutTopX;
    }

    public GlimpseLayout getLayoutPainterRightY() {
        return this.axisLayoutRightY;
    }

    @Override
    public void setAxisFont(Font font) {
        this.setAxisFont(font, true);
    }

    @Override
    public void setAxisFont(Font font, boolean antialias) {
        if (this.painterX != null) {
            this.painterX.setFont(font);
        }
        if (this.painterY != null) {
            this.painterY.setFont(font);
        }
        if (this.painterZ != null) {
            this.painterZ.setFont(font);
        }
        if (this.painterTopX != null) {
            this.painterTopX.setFont(font);
        }
        if (this.painterRightY != null) {
            this.painterRightY.setFont(font);
        }
    }

    @Override
    public void setAxisLabelX(String label) {
        this.setAxisLabelX(label, "");
    }

    @Override
    public void setAxisLabelX(String label, String abbreviatedUnits) {
        this.tickX.setAxisLabel(label);
        this.tickX.setAxisUnits(abbreviatedUnits, true);
        this.tickTopX.setAxisLabel(label);
        this.tickTopX.setAxisUnits(abbreviatedUnits, true);
    }

    @Override
    public void setAxisLabelX(String label, String units, boolean abbreviated) {
        this.tickX.setAxisLabel(label);
        this.tickX.setAxisUnits(units, abbreviated);
        this.tickTopX.setAxisLabel(label);
        this.tickTopX.setAxisUnits(units, abbreviated);
    }

    @Override
    public void setShowAxisMarkerX(boolean show) {
        this.painterX.setShowMarker(show);
        this.painterTopX.setShowMarker(show);
    }

    @Override
    public void setMarkerWidthX(int width) {
        this.painterX.setMarkerWidth(width);
        this.painterTopX.setMarkerWidth(width);
    }

    @Override
    public void setShowMinorTicksX(boolean show) {
        this.painterX.setShowMinorTicks(show);
        this.painterTopX.setShowMinorTicks(show);
    }

    @Override
    public void setTickSpacingX(int spacing) {
        this.tickX.setTickSpacing(spacing);
        this.tickTopX.setTickSpacing(spacing);
    }

    @Override
    public void setMinorTickCountX(int count) {
        this.tickX.setMinorTickCount(count);
        this.tickTopX.setMinorTickCount(count);
    }

    @Override
    public void setAxisLabelY(String label) {
        this.setAxisLabelY(label, "");
    }

    @Override
    public void setAxisLabelY(String label, String abbreviatedUnits) {
        this.tickY.setAxisLabel(label);
        this.tickY.setAxisUnits(abbreviatedUnits, true);
        this.tickRightY.setAxisLabel(label);
        this.tickRightY.setAxisUnits(abbreviatedUnits, true);
    }

    @Override
    public void setAxisLabelY(String label, String units, boolean abbreviated) {
        this.tickY.setAxisLabel(label);
        this.tickY.setAxisUnits(units, abbreviated);
        this.tickRightY.setAxisLabel(label);
        this.tickRightY.setAxisUnits(units, abbreviated);
    }

    @Override
    public void setShowAxisMarkerY(boolean show) {
        this.painterY.setShowMarker(show);
        this.painterRightY.setShowMarker(show);
    }

    @Override
    public void setMarkerWidthY(int width) {
        this.painterY.setMarkerWidth(width);
        this.painterRightY.setMarkerWidth(width);
    }

    @Override
    public void setShowMinorTicksY(boolean show) {
        this.painterY.setShowMinorTicks(show);
        this.painterRightY.setShowMinorTicks(show);
    }

    @Override
    public void setTickSpacingY(int spacing) {
        this.tickY.setTickSpacing(spacing);
        this.tickRightY.setTickSpacing(spacing);
    }

    @Override
    public void setMinorTickCountY(int count) {
        this.tickY.setMinorTickCount(count);
        this.tickRightY.setMinorTickCount(count);
    }

    @Override
    public void addPainter(GlimpsePainter painter) {
        this.mapContentPainter.addPainter(painter);
    }

    @Override
    public void removePainter(GlimpsePainter painter) {
        this.mapContentPainter.removePainter(painter);
    }

    @Override
    public GlimpseAxisLayout2D getLayoutCenter() {
        return this.mapContentLayout;
    }

    public void setPlotBackgroundColor(float[] color) {
        this.plotBackgroundPainter.setColor(color);
    }

    @Override
    public void setBackgroundColor(float[] color) {
        this.backgroundPainter.setColor(color);
    }

    public CrosshairPainter getCrosshairPainter() {
        return this.crosshairPainter;
    }

    public MapBorderPainter getBorderPainter() {
        return this.borderPainter;
    }

    public GridPainter getGridPainter() {
        return this.gridPainter;
    }

    public GeoProjection getGeoProjection() {
        return this.geoProjection;
    }

    @Override
    public String toString() {
        return MapPlot2D.class.getSimpleName();
    }
}

