/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.track;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.painter.base.GlimpseDataPainter2D;
import com.metsci.glimpse.painter.track.Point;
import com.metsci.glimpse.support.font.FontUtils;
import com.metsci.glimpse.support.selection.SpatialSelectionAxisListener;
import com.metsci.glimpse.support.selection.SpatialSelectionListener;
import com.metsci.glimpse.support.selection.TemporalSelectionListener;
import com.metsci.glimpse.util.quadtree.QuadTreeXys;
import com.metsci.glimpse.util.quadtree.Xy;
import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Color;
import java.awt.Font;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class TrackPainter
extends GlimpseDataPainter2D {
    public static final int QUAD_TREE_BIN_MAX = 1000;
    public static final long SPATIAL_SELECTION_UPDATE_RATE = 50L;
    public static final int TRACK_SIZE_ESTIMATE = 100;
    public static final int TRACK_LABEL_OFFSET_X = 8;
    public static final int TRACK_LABEL_OFFSET_Y = 8;
    protected int dataBufferSize = 0;
    protected FloatBuffer dataBuffer = null;
    protected ReentrantLock trackUpdateLock = null;
    protected Map<Integer, Track> tracks;
    protected volatile boolean newData = false;
    protected Set<Track> updatedTracks;
    protected Map<Integer, LoadedTrack> loadedTracks;
    protected QuadTreeXys<Point> spatialIndex;
    protected Point startTimeRange = this.getStartPoint(Long.MIN_VALUE);
    protected Point endTimeRange = this.getEndPoint(Long.MAX_VALUE);
    protected Collection<TemporalSelectionListener<Point>> temporalSelectionListeners;
    private static final Font textFont = FontUtils.getDefaultBold(12.0f);
    protected TextRenderer fontRenderer;

    public TrackPainter() {
        this(false);
    }

    public TrackPainter(boolean enableSpatialIndex) {
        if (enableSpatialIndex) {
            this.spatialIndex = new QuadTreeXys(1000);
        }
        this.temporalSelectionListeners = new CopyOnWriteArrayList<TemporalSelectionListener<Point>>();
        this.tracks = new HashMap<Integer, Track>();
        this.updatedTracks = new HashSet<Track>();
        this.loadedTracks = new HashMap<Integer, LoadedTrack>();
        this.trackUpdateLock = new ReentrantLock();
        this.fontRenderer = new TextRenderer(textFont);
    }

    public void addTemporalSelectionListener(TemporalSelectionListener<Point> listener) {
        this.temporalSelectionListeners.add(listener);
    }

    public void removeTemporalSelectionListener(TemporalSelectionListener<Point> listener) {
        this.temporalSelectionListeners.remove(listener);
    }

    public void addSpatialSelectionListener(Axis2D axis, SpatialSelectionListener<Point> listener) {
        axis.addAxisListener(new SpatialSelectionAxisListener(this, listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Point> getTrackHeads() {
        this.trackUpdateLock.lock();
        try {
            ArrayList<Point> trackHeads = new ArrayList<Point>(this.tracks.size());
            for (Track track : this.tracks.values()) {
                if (track == null) continue;
                trackHeads.add(track.getTrackHead());
            }
            ArrayList<Point> arrayList = trackHeads;
            return arrayList;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getTrackHead(int trackId) {
        this.trackUpdateLock.lock();
        try {
            Track track = this.tracks.get(trackId);
            if (track != null) {
                Point point = track.getTrackHead();
                return point;
            }
            Point point = null;
            return point;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        this.trackUpdateLock.lock();
        try {
            for (Track track : this.tracks.values()) {
                track.deletePending = true;
                track.points.clear();
            }
            if (this.spatialIndex != null) {
                this.spatialIndex = new QuadTreeXys(1000);
            }
            this.updatedTracks.addAll(this.tracks.values());
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTrack(int trackId) {
        this.trackUpdateLock.lock();
        try {
            if (!this.tracks.containsKey(trackId)) {
                return;
            }
            Track track = this.tracks.get(trackId);
            if (this.spatialIndex != null) {
                for (Point p : track.points) {
                    this.spatialIndex.remove((Xy)p);
                }
            }
            track.delete();
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTrack(int trackId) {
        this.trackUpdateLock.lock();
        try {
            if (!this.tracks.containsKey(trackId)) {
                return;
            }
            Track track = this.tracks.get(trackId);
            if (this.spatialIndex != null) {
                for (Point p : track.points) {
                    this.spatialIndex.remove((Xy)p);
                }
            }
            track.clear();
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    public void addPoint(int trackId, int pointId, double x, double y, long time) {
        this.addPoint(trackId, new Point(trackId, pointId, x, y, time));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoints(int trackId, List<Point> points) {
        this.trackUpdateLock.lock();
        try {
            Track track = this.getOrCreateTrack(trackId);
            track.add(points);
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    public void setLineColor(int trackId, float[] color) {
        this.setLineColor(trackId, color[0], color[1], color[2], color[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineColor(int trackId, float r, float g, float b, float a) {
        this.trackUpdateLock.lock();
        try {
            Track track = this.getOrCreateTrack(trackId);
            track.setLineColor(r, g, b, a);
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineWidth(int trackId, float width) {
        this.trackUpdateLock.lock();
        try {
            Track track = this.getOrCreateTrack(trackId);
            track.setLineWidth(width);
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    public void setPointColor(int trackId, float[] color) {
        this.setPointColor(trackId, color[0], color[1], color[2], color[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPointColor(int trackId, float r, float g, float b, float a) {
        this.trackUpdateLock.lock();
        try {
            Track track = this.getOrCreateTrack(trackId);
            track.setPointColor(r, g, b, a);
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPointSize(int trackId, float size) {
        this.trackUpdateLock.lock();
        try {
            Track track = this.getOrCreateTrack(trackId);
            track.setPointSize(size);
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowPoints(int trackId, boolean show) {
        this.trackUpdateLock.lock();
        try {
            Track track = this.getOrCreateTrack(trackId);
            track.setShowPoints(show);
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    public void setHeadPointColor(int trackId, float[] color) {
        this.setHeadPointColor(trackId, color[0], color[1], color[2], color[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeadPointColor(int trackId, float r, float g, float b, float a) {
        this.trackUpdateLock.lock();
        try {
            Track track = this.getOrCreateTrack(trackId);
            track.setHeadPointColor(r, g, b, a);
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeadPointSize(int trackId, float size) {
        this.trackUpdateLock.lock();
        try {
            Track track = this.getOrCreateTrack(trackId);
            track.setHeadPointSize(size);
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowHeadPoint(int trackId, boolean show) {
        this.trackUpdateLock.lock();
        try {
            Track track = this.getOrCreateTrack(trackId);
            track.setShowHeadPoint(show);
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowLines(int trackId, boolean show) {
        this.trackUpdateLock.lock();
        try {
            Track track = this.getOrCreateTrack(trackId);
            track.setShowLines(show);
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDotted(int trackId, boolean dotted) {
        this.trackUpdateLock.lock();
        try {
            Track track = this.getOrCreateTrack(trackId);
            track.setTrackStipple(dotted);
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDotted(int trackId, int stippleFactor, short stipplePattern) {
        this.trackUpdateLock.lock();
        try {
            Track track = this.getOrCreateTrack(trackId);
            track.setTrackStipple(true);
            track.setTrackStipple(stippleFactor, stipplePattern);
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    public void setLabelColor(int trackId, float[] color) {
        this.setLabelColor(trackId, color[0], color[1], color[2], color[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabelColor(int trackId, float r, float g, float b, float a) {
        this.trackUpdateLock.lock();
        try {
            Track track = this.getOrCreateTrack(trackId);
            track.setLabelColor(r, g, b, a);
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    public void setLabelLineColor(int trackId, float[] color) {
        this.setLabelLineColor(trackId, color[0], color[1], color[2], color[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabelLineColor(int trackId, float r, float g, float b, float a) {
        this.trackUpdateLock.lock();
        try {
            Track track = this.getOrCreateTrack(trackId);
            track.setLabelLineColor(r, g, b, a);
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowLabelLine(int trackId, boolean show) {
        this.trackUpdateLock.lock();
        try {
            Track track = this.getOrCreateTrack(trackId);
            track.setShowLabelLine(show);
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabel(int trackId, String label) {
        this.trackUpdateLock.lock();
        try {
            Track track = this.getOrCreateTrack(trackId);
            track.setShowLabel(true);
            track.setLabel(label);
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowLabel(int trackId, boolean show) {
        this.trackUpdateLock.lock();
        try {
            Track track = this.getOrCreateTrack(trackId);
            track.setShowLabel(show);
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    public void displayTimeRange(int trackId, double startTime, double endTime) {
        this.displayTimeRange(trackId, (long)Math.ceil(startTime), (long)Math.floor(endTime));
    }

    public void displayTimeRange(double startTime, double endTime) {
        this.displayTimeRange((long)Math.ceil(startTime), (long)Math.floor(endTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayTimeRange(int trackId, long startTime, long endTime) {
        Point startPoint = this.getStartPoint(startTime);
        Point endPoint = this.getEndPoint(endTime);
        this.trackUpdateLock.lock();
        try {
            Track track = this.getOrCreateTrack(trackId);
            track.setTimeRange(startPoint, endPoint);
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayTimeRange(long startTime, long endTime) {
        this.startTimeRange = this.getStartPoint(startTime);
        this.endTimeRange = this.getEndPoint(endTime);
        this.trackUpdateLock.lock();
        try {
            for (Track track : this.tracks.values()) {
                track.setTimeRange(this.startTimeRange, this.endTimeRange);
            }
            this.updatedTracks.addAll(this.tracks.values());
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Point> getGeoRange(double minX, double maxX, double minY, double maxY) {
        if (this.spatialIndex != null) {
            this.trackUpdateLock.lock();
            try {
                Collection collection = this.spatialIndex.search((float)minX, (float)maxX, (float)minY, (float)maxY);
                return collection;
            }
            finally {
                this.trackUpdateLock.unlock();
            }
        }
        return Collections.emptyList();
    }

    public Collection<Point> getTimeGeoRange(double minTime, double maxTime, double minX, double maxX, double minY, double maxY) {
        return this.getTimeGeoRange((long)Math.ceil(minTime), (long)Math.floor(maxTime), minX, maxX, minY, maxY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Point> getTimeGeoRange(long minTime, long maxTime, double minX, double maxX, double minY, double maxY) {
        if (this.spatialIndex != null) {
            this.trackUpdateLock.lock();
            try {
                Collection<Point> collection = this.filter(this.spatialIndex.search((float)minX, (float)maxX, (float)minY, (float)maxY), minTime, maxTime);
                return collection;
            }
            finally {
                this.trackUpdateLock.unlock();
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Point> getTimeGeoRange(double minX, double maxX, double minY, double maxY) {
        if (this.spatialIndex != null) {
            this.trackUpdateLock.lock();
            try {
                Collection<Point> collection = this.filter(this.spatialIndex.search((float)minX, (float)maxX, (float)minY, (float)maxY));
                return collection;
            }
            finally {
                this.trackUpdateLock.unlock();
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gcDataBuffer() {
        this.trackUpdateLock.lock();
        try {
            this.dataBuffer = null;
            this.dataBufferSize = 0;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    protected Point getStartPoint(long time) {
        return new Point(Integer.MIN_VALUE, Integer.MIN_VALUE, 0.0f, 0.0f, time);
    }

    protected Point getEndPoint(long time) {
        return new Point(Integer.MAX_VALUE, Integer.MAX_VALUE, 0.0f, 0.0f, time);
    }

    protected Collection<Point> filter(Collection<Point> points) {
        ArrayList<Point> result = new ArrayList<Point>();
        for (Point point : points) {
            Track track = this.tracks.get(point.getTrackId());
            if (track == null || point.compareTo(track.selectionStart) < 0 || point.compareTo(track.selectionEnd) >= 0) continue;
            result.add(point);
        }
        return result;
    }

    protected Collection<Point> filter(Collection<Point> points, long minTime, long maxTime) {
        ArrayList<Point> result = new ArrayList<Point>();
        for (Point point : points) {
            if (point.getTime() <= minTime || point.getTime() > maxTime) continue;
            result.add(point);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPoint(int trackId, Point point) {
        this.trackUpdateLock.lock();
        try {
            Track track = this.getOrCreateTrack(trackId);
            track.add(point);
            this.updatedTracks.add(track);
            this.newData = true;
        }
        finally {
            this.trackUpdateLock.unlock();
        }
    }

    protected Track getOrCreateTrack(int trackId) {
        Track track = this.tracks.get(trackId);
        if (track == null) {
            track = new Track(trackId);
            track.setTimeRange(this.startTimeRange, this.endTimeRange);
            this.tracks.put(trackId, track);
        }
        return track;
    }

    protected void ensureDataBufferSize(int needed) {
        if (this.dataBuffer == null || this.dataBufferSize < needed) {
            this.dataBufferSize = needed;
            this.dataBuffer = ByteBuffer.allocateDirect(needed * 2 * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
    }

    protected void notifyTemporalSelectionListeners(Map<Integer, Point> newTrackHeads) {
        for (TemporalSelectionListener<Point> listener : this.temporalSelectionListeners) {
            listener.selectionChanged(newTrackHeads);
        }
    }

    protected LoadedTrack getOrCreateLoadedTrack(int id, Track track) {
        LoadedTrack loaded = this.loadedTracks.get(id);
        if (loaded == null) {
            loaded = new LoadedTrack(track);
            this.loadedTracks.put(id, loaded);
        }
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GL gl, GlimpseBounds bounds, Axis2D axis) {
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        if (this.newData) {
            this.trackUpdateLock.lock();
            try {
                for (Track track : this.updatedTracks) {
                    LoadedTrack loaded;
                    int id = track.trackId;
                    if (track.isDeletePending() || track.isClearPending()) {
                        loaded = this.getOrCreateLoadedTrack(id, track);
                        loaded.dispose(gl);
                        this.loadedTracks.remove(id);
                        if (track.isDeletePending() && !track.isDataInserted()) {
                            this.tracks.remove(id);
                            continue;
                        }
                    }
                    loaded = this.getOrCreateLoadedTrack(id, track);
                    loaded.loadSettings(track);
                    int trackSize = track.getSize();
                    if (track.isDataInserted()) {
                        if (!loaded.glBufferInitialized || loaded.glBufferMaxSize < trackSize) {
                            if (loaded.glBufferInitialized) {
                                gl.glDeleteBuffers(1, new int[]{loaded.glBufferHandle}, 0);
                                loaded.glBufferMaxSize = Math.max((int)((double)loaded.glBufferMaxSize * 1.5), trackSize);
                            } else {
                                loaded.glBufferMaxSize = trackSize;
                            }
                            this.ensureDataBufferSize(loaded.glBufferMaxSize);
                            this.dataBuffer.rewind();
                            track.loadIntoBuffer(this.dataBuffer, 0, trackSize);
                            int[] bufferHandle = new int[1];
                            gl.glGenBuffers(1, bufferHandle, 0);
                            loaded.glBufferHandle = bufferHandle[0];
                            loaded.glBufferInitialized = true;
                            gl.glBindBuffer(34962, loaded.glBufferHandle);
                            gl.glBufferData(34962, loaded.glBufferMaxSize * 2 * 4, this.dataBuffer.rewind(), 35048);
                        } else {
                            int insertOffset = track.getInsertOffset();
                            int insertCount = track.getInsertCount();
                            this.ensureDataBufferSize(insertCount);
                            this.dataBuffer.rewind();
                            track.loadIntoBuffer(this.dataBuffer, insertOffset, trackSize);
                            gl.glBindBuffer(34962, loaded.glBufferHandle);
                            gl.glBufferSubData(34962, insertOffset * 2 * 4, insertCount * 2 * 4, this.dataBuffer.rewind());
                        }
                    }
                    track.reset();
                }
                this.updatedTracks.clear();
                this.newData = false;
            }
            finally {
                this.trackUpdateLock.unlock();
            }
            this.glHandleError(gl);
        }
        if (this.loadedTracks.isEmpty()) {
            return;
        }
        gl.glEnableClientState(32884);
        boolean labelOn = false;
        for (LoadedTrack loaded : this.loadedTracks.values()) {
            if (!loaded.glBufferInitialized) continue;
            int glOffset = loaded.glSelectedOffset;
            int glSize = loaded.glSelectedSize;
            gl.glBindBuffer(34962, loaded.glBufferHandle);
            gl.glVertexPointer(2, 5126, 0, 0L);
            if (loaded.linesOn) {
                gl.glColor4fv(loaded.lineColor, 0);
                gl.glLineWidth(loaded.lineWidth);
                if (loaded.stippleOn) {
                    gl.glEnable(2852);
                    gl.glLineStipple(loaded.stippleFactor, loaded.stipplePattern);
                }
                gl.glEnable(2848);
                gl.glDrawArrays(3, glOffset, glSize);
                gl.glDisable(2848);
                if (loaded.stippleOn) {
                    gl.glDisable(2852);
                }
            }
            if (loaded.pointsOn) {
                gl.glColor4fv(loaded.pointColor, 0);
                gl.glPointSize(loaded.pointSize);
                gl.glEnable(2832);
                gl.glDrawArrays(0, glOffset, glSize);
                gl.glDisable(2832);
            }
            if (loaded.headPointOn) {
                gl.glColor4fv(loaded.headPointColor, 0);
                gl.glPointSize(loaded.headPointSize);
                gl.glEnable(2832);
                gl.glBegin(0);
                try {
                    gl.glVertex2d(loaded.headPosX, loaded.headPosY);
                }
                finally {
                    gl.glEnd();
                }
                gl.glDisable(2832);
            }
            if (!loaded.labelOn) continue;
            labelOn = true;
        }
        if (labelOn) {
            int posY;
            this.fontRenderer.beginRendering(width, height);
            try {
                for (LoadedTrack loaded : this.loadedTracks.values()) {
                    if (!loaded.labelOn) continue;
                    int posX = axis.getAxisX().valueToScreenPixel(loaded.headPosX);
                    posY = axis.getAxisY().valueToScreenPixel(loaded.headPosY);
                    this.fontRenderer.setColor(loaded.labelColor);
                    this.fontRenderer.draw(loaded.label, posX + 8, posY + 8);
                }
            }
            finally {
                this.fontRenderer.endRendering();
            }
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            gl.glOrtho(0.0, (double)width, 0.0, (double)height, -1.0, 1.0);
            gl.glMatrixMode(5888);
            gl.glLoadIdentity();
            for (LoadedTrack loaded : this.loadedTracks.values()) {
                if (!loaded.labelOn || !loaded.labelLineOn) continue;
                int posX = axis.getAxisX().valueToScreenPixel(loaded.headPosX);
                posY = axis.getAxisY().valueToScreenPixel(loaded.headPosY);
                gl.glColor3fv(loaded.labelLineColor, 0);
                gl.glBegin(1);
                try {
                    gl.glVertex2i(posX, posY);
                    gl.glVertex2i(posX + 8, posY + 8);
                }
                finally {
                    gl.glEnd();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(GLContext context) {
        GL gl = context.getGL();
        this.trackUpdateLock.lock();
        try {
            for (LoadedTrack track : this.loadedTracks.values()) {
                track.dispose(gl);
            }
        }
        finally {
            this.trackUpdateLock.unlock();
        }
        if (this.fontRenderer != null) {
            this.fontRenderer.dispose();
            this.fontRenderer = null;
        }
    }

    private class Track {
        int trackId;
        List<Point> points;
        int insertIndex;
        boolean dataInserted = false;
        boolean deletePending = false;
        boolean clearPending = false;
        int selectedOffset;
        int selectedSize;
        Point selectionStart;
        Point selectionEnd;
        Point trackHead;
        float[] lineColor = new float[]{1.0f, 1.0f, 0.0f, 1.0f};
        float lineWidth = 2.0f;
        boolean linesOn = true;
        float[] pointColor = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
        float pointSize = 4.0f;
        boolean pointsOn = true;
        int stippleFactor = 1;
        short stipplePattern = (short)255;
        boolean stippleOn = false;
        String label = null;
        boolean labelOn = false;
        double headPosX;
        double headPosY;
        Color labelColor = new Color(1.0f, 1.0f, 0.0f, 1.0f);
        boolean labelLineOn = true;
        float[] labelLineColor = new float[]{1.0f, 1.0f, 0.0f, 1.0f};
        float headPointSize = 7.0f;
        float[] headPointColor = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
        boolean headPointOn = false;

        public Track(int trackId) {
            this.trackId = trackId;
            this.points = new ArrayList<Point>(100);
        }

        public void setTimeRange(Point startPoint, Point endPoint) {
            this.selectionStart = startPoint;
            this.selectionEnd = endPoint;
            this.checkTimeRange();
        }

        public void checkTimeRange() {
            if (this.selectionStart == null || this.selectionEnd == null) {
                return;
            }
            int startIndex = this.firstIndexAfter(this.selectionStart);
            int endIndex = this.firstIndexBefore(this.selectionEnd);
            Point previousTrackHead = this.trackHead;
            if (endIndex < startIndex) {
                this.selectedOffset = 0;
                this.selectedSize = 0;
                this.trackHead = null;
                if (previousTrackHead != null) {
                    TrackPainter.this.notifyTemporalSelectionListeners(Collections.singletonMap(this.trackId, this.trackHead));
                }
            } else {
                this.selectedOffset = startIndex;
                this.selectedSize = endIndex - startIndex + 1;
                this.trackHead = this.points.get(endIndex);
                this.headPosX = this.trackHead.getX();
                this.headPosY = this.trackHead.getY();
                if (!this.trackHead.equals(previousTrackHead)) {
                    TrackPainter.this.notifyTemporalSelectionListeners(Collections.singletonMap(this.trackId, this.trackHead));
                }
            }
        }

        public void setHeadPointColor(float r, float g, float b, float a) {
            this.headPointColor[0] = r;
            this.headPointColor[1] = g;
            this.headPointColor[2] = b;
            this.headPointColor[3] = a;
        }

        public void setHeadPointSize(float size) {
            this.headPointSize = size;
        }

        public void setShowHeadPoint(boolean show) {
            this.headPointOn = show;
        }

        public void setPointColor(float r, float g, float b, float a) {
            this.pointColor[0] = r;
            this.pointColor[1] = g;
            this.pointColor[2] = b;
            this.pointColor[3] = a;
        }

        public void setPointSize(float size) {
            this.pointSize = size;
        }

        public void setShowPoints(boolean show) {
            this.pointsOn = show;
        }

        public void setLineColor(float r, float g, float b, float a) {
            this.lineColor[0] = r;
            this.lineColor[1] = g;
            this.lineColor[2] = b;
            this.lineColor[3] = a;
        }

        public void setLineWidth(float width) {
            this.lineWidth = width;
        }

        public void setShowLines(boolean show) {
            this.linesOn = show;
        }

        public void setTrackStipple(boolean activate) {
            this.stippleOn = activate;
        }

        public void setTrackStipple(int stippleFactor, short stipplePattern) {
            this.stippleFactor = stippleFactor;
            this.stipplePattern = stipplePattern;
        }

        public void setLabelColor(float r, float g, float b, float a) {
            this.labelColor = new Color(r, g, b, a);
        }

        public void setLabelLineColor(float r, float g, float b, float a) {
            this.labelLineColor[0] = r;
            this.labelLineColor[1] = g;
            this.labelLineColor[2] = b;
            this.labelLineColor[3] = a;
        }

        public void setShowLabelLine(boolean show) {
            this.labelLineOn = show;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setShowLabel(boolean show) {
            this.labelOn = show;
        }

        public void add(List<Point> _points) {
            if (_points == null || _points.size() == 0) {
                return;
            }
            ArrayList<Point> sortedPoints = new ArrayList<Point>(_points);
            Collections.sort(sortedPoints);
            Point firstPoint = (Point)sortedPoints.get(0);
            int index = this.firstIndexAfter(firstPoint);
            if (index == this.points.size()) {
                this.points.addAll(index, sortedPoints);
            } else {
                for (Point point : sortedPoints) {
                    index = this.firstIndexAfter(firstPoint);
                    this.points.add(index, point);
                }
            }
            if (TrackPainter.this.spatialIndex != null) {
                for (Point point : _points) {
                    TrackPainter.this.spatialIndex.add((Xy)point);
                }
            }
            this.checkTimeRange();
            this.insertIndex = 0;
            this.dataInserted = true;
        }

        public void add(Point point) {
            int index = this.firstIndexAfter(point);
            this.points.add(index, point);
            if (TrackPainter.this.spatialIndex != null) {
                TrackPainter.this.spatialIndex.add((Xy)point);
            }
            this.checkTimeRange();
            if (!this.dataInserted || index < this.insertIndex) {
                this.insertIndex = index;
                this.dataInserted = true;
            }
        }

        public void delete() {
            this.deletePending = true;
            this.clear();
        }

        public void clear() {
            this.clearPending = true;
            this.dataInserted = false;
            this.trackHead = null;
            this.points.clear();
            this.checkTimeRange();
        }

        public int firstIndexAfter(Point point) {
            int index = Collections.binarySearch(this.points, point);
            if (index < 0) {
                index = -(index + 1);
            }
            return index;
        }

        public int firstIndexBefore(Point point) {
            int index = Collections.binarySearch(this.points, point);
            if (index < 0) {
                index = -(index + 1) - 1;
            }
            return index;
        }

        public boolean isDataInserted() {
            return this.dataInserted;
        }

        public boolean isDeletePending() {
            return this.deletePending;
        }

        public boolean isClearPending() {
            return this.clearPending;
        }

        public int getInsertCount() {
            return this.getSize() - this.getInsertOffset();
        }

        public int getInsertOffset() {
            return this.insertIndex;
        }

        public void reset() {
            this.dataInserted = false;
            this.clearPending = false;
            this.deletePending = false;
        }

        public int getSize() {
            return this.points.size();
        }

        public Point getTrackHead() {
            return this.trackHead;
        }

        public void loadIntoBuffer(FloatBuffer buffer, int offset, int size) {
            for (int i = offset; i < size; ++i) {
                this.points.get(i).loadIntoBuffer(buffer);
            }
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            Track p = (Track)o;
            return p.trackId == this.trackId;
        }

        public int hashCode() {
            int prime = 227;
            return 227 + this.trackId;
        }
    }

    private static class LoadedTrack {
        int trackId;
        float[] lineColor = new float[4];
        float lineWidth;
        boolean linesOn;
        float[] pointColor = new float[4];
        float pointSize;
        boolean pointsOn;
        int stippleFactor;
        short stipplePattern;
        boolean stippleOn;
        String label;
        boolean labelOn;
        double headPosX;
        double headPosY;
        Color labelColor;
        float[] labelLineColor = new float[4];
        boolean labelLineOn;
        float headPointSize;
        float[] headPointColor = new float[4];
        boolean headPointOn;
        boolean glBufferInitialized = false;
        int glBufferHandle;
        int glBufferMaxSize;
        int glBufferCurrentSize;
        int glSelectedOffset;
        int glSelectedSize;

        public LoadedTrack(Track track) {
            this.trackId = track.trackId;
            this.loadSettings(track);
        }

        public void loadSettings(Track track) {
            this.glSelectedSize = track.selectedSize;
            this.glSelectedOffset = track.selectedOffset;
            this.copyColor(this.lineColor, track.lineColor);
            this.copyColor(this.pointColor, track.pointColor);
            this.lineWidth = track.lineWidth;
            this.pointSize = track.pointSize;
            this.pointsOn = track.pointsOn;
            this.linesOn = track.linesOn;
            this.stippleOn = track.stippleOn;
            this.stippleFactor = track.stippleFactor;
            this.stipplePattern = track.stipplePattern;
            this.glBufferCurrentSize = track.getSize();
            if (this.glBufferCurrentSize == 0 || track.selectedSize == 0) {
                this.headPointOn = false;
                this.labelOn = false;
            } else {
                this.copyColor(this.labelLineColor, track.labelLineColor);
                this.labelLineOn = track.labelLineOn;
                this.copyColor(this.headPointColor, track.headPointColor);
                this.headPointSize = track.headPointSize;
                this.headPointOn = track.headPointOn;
                this.label = track.label;
                this.labelOn = track.labelOn;
                this.headPosX = track.headPosX;
                this.headPosY = track.headPosY;
                this.labelColor = track.labelColor;
            }
        }

        protected void copyColor(float[] to, float[] from) {
            to[0] = from[0];
            to[1] = from[1];
            to[2] = from[2];
            to[3] = from[3];
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            LoadedTrack p = (LoadedTrack)o;
            return p.trackId == this.trackId;
        }

        public int hashCode() {
            int prime = 227;
            return 227 + this.trackId;
        }

        public void dispose(GL gl) {
            if (this.glBufferInitialized) {
                gl.glDeleteBuffers(1, new int[]{this.glBufferHandle}, 0);
            }
        }
    }
}

