/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.track;

import com.metsci.glimpse.util.GeneralUtils;
import com.metsci.glimpse.util.quadtree.Xy;
import java.nio.FloatBuffer;

public class Point
implements Comparable<Point>,
Xy {
    protected int trackId;
    protected int pointId;
    protected float x;
    protected float y;
    protected long time;

    public Point(long time) {
        this.time = time;
        this.trackId = Integer.MIN_VALUE;
        this.pointId = Integer.MIN_VALUE;
    }

    public Point(int trackId, int pointId, double x, double y, long time) {
        this.trackId = trackId;
        this.pointId = pointId;
        this.x = (float)x;
        this.y = (float)y;
        this.time = time;
    }

    public Point(int trackId, int pointId, float x, float y, long time) {
        this.trackId = trackId;
        this.pointId = pointId;
        this.x = x;
        this.y = y;
        this.time = time;
    }

    public void loadIntoBuffer(FloatBuffer buffer) {
        buffer.put(this.x).put(this.y);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int getPointId() {
        return this.pointId;
    }

    public int getTrackId() {
        return this.trackId;
    }

    public long getTime() {
        return this.time;
    }

    public int getId() {
        return this.pointId;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Point p = (Point)o;
        return p.trackId == this.trackId && p.pointId == this.pointId && p.time == this.time;
    }

    @Override
    public int compareTo(Point p) {
        if (this.time < p.time) {
            return -1;
        }
        if (this.time > p.time) {
            return 1;
        }
        if (this.trackId < p.trackId) {
            return -1;
        }
        if (this.trackId > p.trackId) {
            return 1;
        }
        if (this.pointId < p.pointId) {
            return -1;
        }
        if (this.pointId > p.pointId) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 227;
        int result = 1;
        result = 227 * result + this.trackId;
        result = 227 * result + this.pointId;
        result = 227 * result + GeneralUtils.hashCode((long)this.time);
        return result;
    }

    public String toString() {
        return "[ " + this.pointId + ", " + this.trackId + ", " + this.time + " ]";
    }
}

