/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.shape;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.gl.attribute.GLFloatBuffer;
import com.metsci.glimpse.gl.attribute.GLFloatBuffer2D;
import com.metsci.glimpse.gl.attribute.GLVertexAttribute;
import com.metsci.glimpse.gl.shader.Pipeline;
import com.metsci.glimpse.gl.texture.ColorTexture1D;
import com.metsci.glimpse.gl.texture.FloatTexture1D;
import com.metsci.glimpse.painter.base.GlimpseDataPainter2D;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.shader.SimplePointShader;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class ShadedPointPainter
extends GlimpseDataPainter2D {
    protected ReentrantLock lock = new ReentrantLock();
    protected FloatTexture1D sizeTexture;
    protected ColorTexture1D colorTexture;
    protected GLFloatBuffer2D positionBuffer;
    protected GLFloatBuffer colorAttributeBuffer;
    protected GLFloatBuffer sizeAttributeBuffer;
    protected Pipeline pipeline;
    protected int colorAttributeIndex = 6;
    protected int sizeAttributeIndex = 7;
    protected SimplePointShader vertShader;
    protected boolean constantSize = true;
    protected boolean constantColor = true;
    protected float constantPointSize = 5.0f;
    protected float[] constantPointColor = GlimpseColor.getBlack();
    protected boolean userPipeline = false;

    public ShadedPointPainter(Axis1D colorAxis, Axis1D sizeAxis, Pipeline pipeline) throws IOException {
        this.lock = new ReentrantLock();
        this.pipeline = pipeline;
        this.userPipeline = true;
    }

    public ShadedPointPainter(Axis1D colorAxis, Axis1D sizeAxis) throws IOException {
        this.lock = new ReentrantLock();
        this.initShaderPipeline(colorAxis, sizeAxis);
    }

    protected void initShaderPipeline(Axis1D colorAxis, Axis1D sizeAxis) throws IOException {
        this.vertShader = new SimplePointShader(0, 1, this.colorAttributeIndex, this.sizeAttributeIndex, colorAxis, sizeAxis);
        this.pipeline = new Pipeline("pointshader", null, this.vertShader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useVertexPositionData(GLFloatBuffer2D positionBuffer) {
        this.lock.lock();
        try {
            this.positionBuffer = positionBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useColorAttribData(GLFloatBuffer attributeBuffer) {
        this.lock.lock();
        try {
            this.colorAttributeBuffer = attributeBuffer;
            this.setVariablePointColor0();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useSizeAttribData(GLFloatBuffer attributeBuffer) {
        this.lock.lock();
        try {
            this.sizeAttributeBuffer = attributeBuffer;
            this.setVariablePointSize0();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useColorScale(ColorTexture1D colorTexture) {
        this.lock.lock();
        try {
            this.colorTexture = colorTexture;
            this.setVariablePointColor0();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useSizeScale(FloatTexture1D sizeTexture) {
        this.lock.lock();
        try {
            this.sizeTexture = sizeTexture;
            this.setVariablePointSize0();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiscardAboveSize(boolean discard) {
        this.lock.lock();
        try {
            this.vertShader.setDiscardAboveSize(discard);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiscardBelowSize(boolean discard) {
        this.lock.lock();
        try {
            this.vertShader.setDiscardBelowSize(discard);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiscardAboveColor(boolean discard) {
        this.lock.lock();
        try {
            this.vertShader.setDiscardAboveColor(discard);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiscardBelowColor(boolean discard) {
        this.lock.lock();
        try {
            this.vertShader.setDiscardBelowColor(discard);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConstantPointSize(float size) {
        this.lock.lock();
        try {
            this.constantPointSize = size;
            this.setConstantPointSize0();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConstantPointColor(float[] color) {
        this.lock.lock();
        try {
            this.constantPointColor = color;
            this.setConstantPointColor0();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useConstantColor() {
        this.lock.lock();
        try {
            this.setConstantPointColor0();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useConstantSize() {
        this.lock.lock();
        try {
            this.setConstantPointSize0();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useVariableSize() {
        this.lock.lock();
        try {
            this.setVariablePointSize0();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useVariableColor() {
        this.lock.lock();
        try {
            this.setVariablePointColor0();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void setConstantPointColor0() {
        this.constantColor = true;
        this.vertShader.setConstantColor(true);
    }

    protected void setConstantPointSize0() {
        this.constantSize = true;
        this.vertShader.setConstantSize(true);
    }

    protected void setVariablePointColor0() {
        if (this.colorTexture != null && this.colorAttributeBuffer != null) {
            this.constantColor = false;
            this.vertShader.setConstantColor(false);
        }
    }

    protected void setVariablePointSize0() {
        if (this.sizeTexture != null && this.sizeAttributeBuffer != null) {
            this.constantSize = false;
            this.vertShader.setConstantSize(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GL gl, GlimpseBounds bounds, Axis2D axis) {
        this.lock.lock();
        try {
            if (this.positionBuffer == null) {
                return;
            }
            if (!(this.constantSize || this.sizeTexture != null && this.sizeAttributeBuffer != null)) {
                return;
            }
            if (!(this.constantColor || this.colorTexture != null && this.colorAttributeBuffer != null)) {
                return;
            }
            if (this.constantSize) {
                gl.glPointSize(this.constantPointSize);
            } else {
                this.sizeTexture.prepare(gl, 1);
                this.sizeAttributeBuffer.bind(this.sizeAttributeIndex, gl);
                gl.glEnable(34370);
            }
            if (this.constantColor) {
                GlimpseColor.glColor(gl, this.constantPointColor);
            } else {
                this.colorTexture.prepare(gl, 0);
                this.colorAttributeBuffer.bind(this.colorAttributeIndex, gl);
            }
            this.positionBuffer.bind(GLVertexAttribute.ATTRIB_POSITION_2D, gl);
            this.pipeline.beginUse(gl);
            gl.glEnable(2832);
            gl.glBlendFunc(770, 771);
            gl.glEnable(3042);
            gl.glDrawArrays(0, 0, this.positionBuffer.getNumVertices());
        }
        finally {
            try {
                this.pipeline.endUse(gl);
                this.positionBuffer.unbind(gl);
                if (!this.constantColor) {
                    this.colorAttributeBuffer.unbind(gl);
                }
                if (!this.constantSize) {
                    this.sizeAttributeBuffer.unbind(gl);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void dispose(GLContext context) {
        if (!this.userPipeline && this.pipeline != null) {
            this.pipeline.dispose(context);
        }
    }
}

