/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.info;

import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.base.GlimpsePainterImpl;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.FontUtils;
import com.metsci.glimpse.support.settings.AbstractLookAndFeel;
import com.metsci.glimpse.support.settings.LookAndFeel;
import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL;

public class SimpleTextPainter
extends GlimpsePainterImpl {
    private Font textFont;
    private float[] textColor = GlimpseColor.getBlack();
    private boolean paintBackground = false;
    private float[] backgroundColor = GlimpseColor.getBlack(0.3f);
    private int padding = 5;
    protected HorizontalPosition hPos = HorizontalPosition.Left;
    protected VerticalPosition vPos = VerticalPosition.Bottom;
    private TextRenderer textRenderer;
    private String sizeText;
    private String text;
    private boolean fontSet = false;

    public SimpleTextPainter() {
        this.setFont(12, true, false);
    }

    public SimpleTextPainter setPaintBackground(boolean paintBackground) {
        this.paintBackground = paintBackground;
        return this;
    }

    public SimpleTextPainter setBackgroundColor(float[] backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public SimpleTextPainter setHorizontalPosition(HorizontalPosition hPos) {
        this.hPos = hPos;
        return this;
    }

    public SimpleTextPainter setVerticalPosition(VerticalPosition vPos) {
        this.vPos = vPos;
        return this;
    }

    public SimpleTextPainter setFont(Font font) {
        this.setFont(font, true);
        return this;
    }

    public SimpleTextPainter setFont(Font font, boolean antialias) {
        this.textFont = font;
        if (this.textRenderer != null) {
            this.textRenderer.dispose();
        }
        this.textRenderer = new TextRenderer(this.textFont, antialias, false);
        this.fontSet = true;
        return this;
    }

    public SimpleTextPainter setFont(int size, boolean bold) {
        this.setFont(size, bold, true);
        return this;
    }

    public SimpleTextPainter setFont(int size, boolean bold, boolean antialias) {
        if (bold) {
            this.setFont(FontUtils.getDefaultBold(size), antialias);
        } else {
            this.setFont(FontUtils.getDefaultPlain(size), antialias);
        }
        return this;
    }

    public SimpleTextPainter setSizeText(String sizeText) {
        this.sizeText = sizeText;
        return this;
    }

    public SimpleTextPainter setText(String text) {
        this.text = text;
        return this;
    }

    public SimpleTextPainter setPadding(int padding) {
        this.padding = padding;
        return this;
    }

    public SimpleTextPainter setColor(float[] rgba) {
        this.textColor = rgba;
        return this;
    }

    public SimpleTextPainter setColor(float r, float g, float b, float a) {
        this.textColor[0] = r;
        this.textColor[1] = g;
        this.textColor[2] = b;
        this.textColor[3] = a;
        return this;
    }

    public int getPadding() {
        return this.padding;
    }

    @Override
    public void setLookAndFeel(LookAndFeel laf) {
        if (!this.fontSet) {
            this.setFont(laf.getFont(AbstractLookAndFeel.TITLE_FONT), false);
            this.fontSet = false;
        }
    }

    @Override
    public void dispose(GlimpseContext context) {
        if (this.textRenderer != null) {
            this.textRenderer.dispose();
        }
        this.textRenderer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintTo(GlimpseContext context, GlimpseBounds bounds) {
        if (this.text == null) {
            return;
        }
        GL gl = context.getGL();
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        Rectangle2D textBounds = this.sizeText == null ? this.textRenderer.getBounds(this.text) : this.textRenderer.getBounds(this.sizeText);
        int xText = this.padding;
        int yText = this.padding;
        switch (this.hPos) {
            case Left: {
                xText = this.padding;
                break;
            }
            case Center: {
                xText = (int)((double)width / 2.0 - textBounds.getWidth() / 2.0);
                break;
            }
            case Right: {
                xText = (int)((double)width - textBounds.getWidth() - (double)this.padding);
            }
        }
        switch (this.vPos) {
            case Bottom: {
                yText = this.padding;
                break;
            }
            case Center: {
                yText = (int)((double)height / 2.0 - textBounds.getHeight() / 2.0);
                break;
            }
            case Top: {
                yText = (int)((double)height - textBounds.getHeight() - (double)this.padding);
            }
        }
        if (this.paintBackground) {
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            gl.glOrtho(-0.5, (double)(width - 1) + 0.5, -0.5, (double)(height - 1) + 0.5, -1.0, 1.0);
            gl.glMatrixMode(5888);
            gl.glLoadIdentity();
            gl.glBlendFunc(770, 771);
            gl.glEnable(3042);
            Rectangle2D bound = this.sizeText == null ? this.textRenderer.getBounds(this.text) : this.textRenderer.getBounds(this.sizeText);
            int xTextMax = (int)((double)xText + bound.getWidth() + bound.getMinX() - 1.0);
            int yTextMax = (int)((double)yText + bound.getHeight() - 3.0);
            gl.glColor4fv(this.backgroundColor, 0);
            gl.glBegin(7);
            try {
                gl.glVertex2f((float)xText - 0.5f - 2.0f, (float)yText - 0.5f - 2.0f);
                gl.glVertex2f((float)xTextMax + 0.5f + 2.0f, (float)yText - 0.5f - 2.0f);
                gl.glVertex2f((float)xTextMax + 0.5f + 2.0f, (float)yTextMax + 0.5f + 2.0f);
                gl.glVertex2f((float)xText - 0.5f - 2.0f, (float)yTextMax + 0.5f + 2.0f);
            }
            finally {
                gl.glEnd();
            }
        }
        this.textRenderer.beginRendering(width, height);
        try {
            this.textRenderer.setColor(this.textColor[0], this.textColor[1], this.textColor[2], this.textColor[3]);
            this.textRenderer.draw(this.text, xText, yText);
        }
        finally {
            this.textRenderer.endRendering();
        }
    }

    public static enum VerticalPosition {
        Bottom,
        Center,
        Top;

    }

    public static enum HorizontalPosition {
        Left,
        Center,
        Right;

    }
}

