/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.info;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.painter.base.GlimpseDataPainter2D;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.sun.opengl.util.GLUT;
import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL;

public class AnnotationPainter
extends GlimpseDataPainter2D {
    protected static final GLUT glut = new GLUT();
    protected static final float[] DEFAULT_COLOR = GlimpseColor.getBlack();
    protected static final AnnotationFont DEFAULT_FONT = AnnotationFont.Helvetical_12;
    protected Collection<Annotation> annotations;
    protected ReentrantLock lock;
    protected long minTime = Long.MIN_VALUE;
    protected long maxTime = Long.MAX_VALUE;

    public AnnotationPainter() {
        this.annotations = new ArrayList<Annotation>();
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Annotation addAnnotation(String text, float x, float y) {
        this.lock.lock();
        try {
            Annotation annotation = new Annotation(text, x, y);
            this.annotations.add(annotation);
            Annotation annotation2 = annotation;
            return annotation2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Annotation addAnnotation(String text, float x, float y, int offset_x, int offset_y, boolean centerX, boolean centerY, AnnotationFont font, float[] color) {
        this.lock.lock();
        try {
            Annotation annotation = new Annotation(text, x, y, offset_x, offset_y, centerX, centerY, font, color);
            this.annotations.add(annotation);
            Annotation annotation2 = annotation;
            return annotation2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Annotation addAnnotation(TextRenderer textRenderer, String text, float x, float y, int offset_x, int offset_y, boolean centerX, boolean centerY, float[] color) {
        this.lock.lock();
        try {
            Annotation annotation = new Annotation(textRenderer, text, x, y, offset_x, offset_y, centerX, centerY, color);
            this.annotations.add(annotation);
            Annotation annotation2 = annotation;
            return annotation2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Annotation addAnnotation(Annotation annotation) {
        this.lock.lock();
        try {
            this.annotations.add(annotation);
            Annotation annotation2 = annotation;
            return annotation2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAnnotations() {
        this.lock.lock();
        try {
            this.annotations.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayTime(long time) {
        this.lock.lock();
        try {
            this.minTime = time;
            this.maxTime = time;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayTimeRange(long minTime, long maxTime) {
        this.lock.lock();
        try {
            this.minTime = minTime;
            this.maxTime = maxTime;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GL gl, GlimpseBounds bounds, Axis2D axis) {
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        this.lock.lock();
        try {
            for (Annotation annotation : this.annotations) {
                if (!this.inTimeRange(annotation)) continue;
                float[] textColor = DEFAULT_COLOR;
                if (annotation.color != null) {
                    textColor = annotation.color;
                }
                if (annotation.getTextRenderer() != null) {
                    TextRenderer textRenderer = annotation.getTextRenderer();
                    Rectangle2D textBounds = textRenderer.getBounds(annotation.text);
                    int x = (int)((double)axis.getAxisX().valueToScreenPixel(annotation.x) - (annotation.centerX ? textBounds.getWidth() / 2.0 : 0.0));
                    int y = (int)((double)axis.getAxisY().valueToScreenPixel(annotation.y) - (annotation.centerY ? textBounds.getHeight() / 2.0 : 0.0));
                    textRenderer.beginRendering(width, height);
                    try {
                        textRenderer.setColor(textColor[0], textColor[1], textColor[2], textColor[3]);
                        textRenderer.draw(annotation.text, x + annotation.offset_x, y + annotation.offset_y);
                        continue;
                    }
                    finally {
                        textRenderer.endRendering();
                        continue;
                    }
                }
                gl.glColor3fv(textColor, 0);
                float posX = annotation.x;
                float posY = annotation.y;
                posX = (float)((double)posX + (double)annotation.offset_x / axis.getAxisX().getPixelsPerValue());
                posY = (float)((double)posY + (double)annotation.offset_y / axis.getAxisY().getPixelsPerValue());
                if (annotation.centerX) {
                    posX = (float)((double)posX - (double)glut.glutBitmapLength(annotation.font, annotation.text) / (2.0 * axis.getAxisX().getPixelsPerValue()));
                }
                if (annotation.centerY) {
                    posY = (float)((double)posY - (double)annotation.height / (3.0 * axis.getAxisY().getPixelsPerValue()));
                }
                gl.glRasterPos2f(posX, posY);
                glut.glutBitmapString(annotation.font, annotation.text);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean inTimeRange(Annotation annotation) {
        return annotation.getStartTime() <= this.maxTime && annotation.getEndTime() >= this.minTime || this.minTime <= annotation.getEndTime() && this.maxTime >= annotation.getStartTime();
    }

    public static class Annotation {
        protected float x;
        protected float y;
        protected int offset_x;
        protected int offset_y;
        protected float[] color;
        protected String text;
        protected TextRenderer textRenderer;
        protected int font;
        protected int height;
        protected boolean centerX;
        protected boolean centerY;
        protected long startTime;
        protected long endTime;

        public Annotation(String text, float x, float y) {
            this(text, x, y, 0, 0, false, false, null, null);
        }

        public Annotation(String text, float x, float y, boolean centerX, boolean centerY) {
            this(text, x, y, 0, 0, centerX, centerY, null, null);
        }

        public Annotation(String text, float x, float y, float[] color) {
            this(text, x, y, 0, 0, false, false, null, color);
        }

        public Annotation(TextRenderer textRenderer, String text, float x, float y, int offset_x, int offset_y, boolean centerX, boolean centerY, float[] color) {
            this(textRenderer, text, x, y, offset_x, offset_y, centerX, centerY, color, Long.MIN_VALUE, Long.MAX_VALUE);
        }

        public Annotation(String text, float x, float y, int offset_x, int offset_y, boolean centerX, boolean centerY, AnnotationFont font, float[] color) {
            this.x = x;
            this.y = y;
            this.offset_x = offset_x;
            this.offset_y = offset_y;
            this.text = text;
            this.color = color;
            this.centerX = centerX;
            this.centerY = centerY;
            font = font == null ? DEFAULT_FONT : font;
            this.font = font.getFont();
            this.height = font.getHeight();
        }

        public Annotation(TextRenderer textRenderer, String text, float x, float y, int offset_x, int offset_y, boolean centerX, boolean centerY, float[] color, long startTime, long endTime) {
            this.x = x;
            this.y = y;
            this.offset_x = offset_x;
            this.offset_y = offset_y;
            this.text = text;
            this.color = color;
            this.centerX = centerX;
            this.centerY = centerY;
            this.font = -1;
            this.height = -1;
            this.textRenderer = textRenderer;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public float getX() {
            return this.x;
        }

        public void setX(float x) {
            this.x = x;
        }

        public float getY() {
            return this.y;
        }

        public void setY(float y) {
            this.y = y;
        }

        public int getOffset_x() {
            return this.offset_x;
        }

        public void setOffset_x(int offset_x) {
            this.offset_x = offset_x;
        }

        public int getOffset_y() {
            return this.offset_y;
        }

        public void setOffset_y(int offset_y) {
            this.offset_y = offset_y;
        }

        public float[] getColor() {
            return this.color;
        }

        public void setColor(float[] color) {
            this.color = color;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public int getFont() {
            return this.font;
        }

        public void setFont(int font) {
            this.font = font;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public boolean isCenterX() {
            return this.centerX;
        }

        public void setCenterX(boolean centerX) {
            this.centerX = centerX;
        }

        public boolean isCenterY() {
            return this.centerY;
        }

        public void setCenterY(boolean centerY) {
            this.centerY = centerY;
        }

        public TextRenderer getTextRenderer() {
            return this.textRenderer;
        }
    }

    public static enum AnnotationFont {
        Monospace_8_BY_13(3, 13),
        Monospace_9_BY_15(2, 15),
        Times_Roman_10(4, 10),
        Times_Roman_24(5, 24),
        Helvetical_10(6, 10),
        Helvetical_12(7, 12),
        Helvetical_18(8, 18);

        private int font;
        private int height;

        private AnnotationFont(int font, int height) {
            this.font = font;
            this.height = height;
        }

        public int getFont() {
            return this.font;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

