/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.geo;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.painter.label.AxisUnitConverter;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.base.GlimpsePainterImpl;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.FontUtils;
import com.metsci.glimpse.util.units.Length;
import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class ScalePainter
extends GlimpsePainterImpl {
    protected float[] borderColor = GlimpseColor.fromColorRgba(0.0f, 0.0f, 0.0f, 1.0f);
    protected float[] primaryColor = GlimpseColor.fromColorRgba(1.0f, 1.0f, 1.0f, 0.5f);
    protected float[] secondaryColor = GlimpseColor.fromColorRgba(0.6f, 0.6f, 0.6f, 0.5f);
    protected float[] textColor = GlimpseColor.fromColorRgba(0.0f, 0.0f, 0.0f, 1.0f);
    protected int bufferX;
    protected int bufferY;
    protected int pixelHeight;
    protected int pixelWidth;
    protected Axis1D axis;
    protected AxisUnitConverter converter;
    protected String unitLabel;
    protected TextRenderer textRenderer;
    protected NumberFormat formatter;

    public ScalePainter(Axis1D axis) {
        this.axis = axis;
        this.textRenderer = this.createTextRenderer();
        this.converter = new AxisUnitConverter(){

            @Override
            public double fromAxisUnits(double value) {
                return Length.fromNauticalMiles((double)value);
            }

            @Override
            public double toAxisUnits(double value) {
                return Length.toNauticalMiles((double)value);
            }
        };
        this.formatter = NumberFormat.getNumberInstance();
        this.formatter.setGroupingUsed(false);
        this.unitLabel = "nmi";
        this.bufferX = 0;
        this.bufferY = 0;
        this.pixelHeight = 20;
        this.pixelWidth = 300;
    }

    protected TextRenderer createTextRenderer() {
        return new TextRenderer(FontUtils.getDefaultBold(16.0f), false, false);
    }

    public float[] getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(float[] borderColor) {
        this.borderColor = borderColor;
    }

    public float[] getPrimaryColor() {
        return this.primaryColor;
    }

    public void setPrimaryColor(float[] primaryColor) {
        this.primaryColor = primaryColor;
    }

    public float[] getSecondaryColor() {
        return this.secondaryColor;
    }

    public void setSecondaryColor(float[] secondaryColor) {
        this.secondaryColor = secondaryColor;
    }

    public float[] getTextColor() {
        return this.textColor;
    }

    public void setTextColor(float[] textColor) {
        this.textColor = textColor;
    }

    public int getPixelBufferX() {
        return this.bufferX;
    }

    public void setPixelBufferX(int buffer) {
        this.bufferX = buffer;
    }

    public int getPixelBufferY() {
        return this.bufferY;
    }

    public void setPixelBufferY(int buffer) {
        this.bufferY = buffer;
    }

    public int getScaleHeight() {
        return this.pixelHeight;
    }

    public void setPixelHeight(int pixelHeight) {
        this.pixelHeight = pixelHeight;
    }

    public int getPixelHeight() {
        return this.pixelWidth;
    }

    public void setPixelWidth(int pixelWidth) {
        this.pixelWidth = pixelWidth;
    }

    public AxisUnitConverter getUnitConverter() {
        return this.converter;
    }

    public void setUnitConverter(AxisUnitConverter converter) {
        this.converter = converter;
    }

    public String getUnitLabel() {
        return this.unitLabel;
    }

    public void setUnitLabel(String unitLabel) {
        this.unitLabel = unitLabel;
    }

    @Override
    public void dispose(GLContext context) {
        if (this.textRenderer != null) {
            this.textRenderer.dispose();
        }
        this.textRenderer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintTo(GlimpseContext context, GlimpseBounds bounds) {
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        double diff = this.axis.getMax() - this.axis.getMin();
        double ratio = (double)this.axis.getSizePixels() / this.converter.toAxisUnits(diff);
        double hintValue = (double)this.pixelWidth / ratio;
        double hintOrder = Math.log10(hintValue);
        int order = (int)Math.ceil(hintOrder);
        double scaleValueSize = Math.pow(10.0, order - 1);
        double scalePixelSize = scaleValueSize * ratio;
        int tickCount = (int)Math.floor((double)this.pixelWidth / scalePixelSize);
        if (tickCount < 5) {
            scalePixelSize = (scaleValueSize /= 2.0) * ratio;
            tickCount = (int)Math.floor((double)this.pixelWidth / scalePixelSize);
        }
        double totalSize = scalePixelSize * (double)tickCount;
        GL gl = context.getGL();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(0.0, (double)width, 0.0, (double)height, -1.0, 1.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glBlendFunc(770, 771);
        gl.glEnable(3042);
        gl.glBegin(7);
        try {
            for (int i = 0; i < tickCount; ++i) {
                if (i % 2 == 0) {
                    gl.glColor4fv(this.secondaryColor, 0);
                } else {
                    gl.glColor4fv(this.primaryColor, 0);
                }
                double offset1 = totalSize * ((double)i / (double)tickCount);
                double offset2 = totalSize * ((double)(i + 1) / (double)tickCount);
                gl.glVertex2d((double)(width - this.bufferX) - offset1, (double)this.bufferY);
                gl.glVertex2d((double)(width - this.bufferX) - offset2, (double)this.bufferY);
                gl.glVertex2d((double)(width - this.bufferX) - offset2, (double)(this.bufferY + this.pixelHeight));
                gl.glVertex2d((double)(width - this.bufferX) - offset1, (double)(this.bufferY + this.pixelHeight));
            }
        }
        finally {
            gl.glEnd();
        }
        gl.glLineWidth(1.0f);
        gl.glColor4fv(this.borderColor, 0);
        gl.glBegin(2);
        try {
            gl.glVertex2d((double)(width - this.bufferX), (double)this.bufferY);
            gl.glVertex2d((double)(width - this.bufferX) - totalSize, (double)this.bufferY);
            gl.glVertex2d((double)(width - this.bufferX) - totalSize, (double)(this.bufferY + this.pixelHeight));
            gl.glVertex2d((double)(width - this.bufferX), (double)(this.bufferY + this.pixelHeight));
        }
        finally {
            gl.glEnd();
        }
        gl.glDisable(3042);
        gl.glTranslatef(0.375f, 0.375f, 0.0f);
        if (order < 2) {
            this.formatter.setMaximumFractionDigits(Math.abs(order - 2));
        } else {
            this.formatter.setMaximumFractionDigits(0);
        }
        String text = this.formatter.format(scaleValueSize) + " " + this.unitLabel;
        Rectangle2D textBounds = this.textRenderer.getBounds(text);
        int posX = (int)((double)(width - 1 - this.bufferX) - textBounds.getWidth() - 1.0);
        int posY = (int)((double)(this.bufferY + this.pixelHeight / 2) - textBounds.getHeight() / 2.0);
        this.textRenderer.beginRendering(width, height);
        try {
            GlimpseColor.setColor(this.textRenderer, this.textColor);
            this.textRenderer.draw(text, posX, posY);
        }
        finally {
            this.textRenderer.endRendering();
        }
    }
}

