/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.decoration;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.painter.base.GlimpseDataPainter2D;
import com.metsci.glimpse.support.settings.AbstractLookAndFeel;
import com.metsci.glimpse.support.settings.LookAndFeel;
import javax.media.opengl.GL;

public class CrosshairPainter
extends GlimpseDataPainter2D {
    protected float[] xorColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    protected float[] cursorColor = new float[]{0.0f, 0.769f, 1.0f, 1.0f};
    protected float[] shadeColor = new float[]{0.0f, 0.769f, 1.0f, 0.25f};
    protected float lineWidth = 2.0f;
    protected boolean showSelectionBox = true;
    protected boolean shadeSelectionBox = false;
    protected boolean showSelectionCrosshairs = true;
    protected boolean hideHorizontalHairs = false;
    protected boolean hideVerticalHairs = false;
    protected boolean paintXor = false;
    protected boolean colorSet = false;

    public void setCursorColor(float[] rgba) {
        this.cursorColor = rgba;
        this.colorSet = true;
    }

    public void setCursorColor(float r, float g, float b, float a) {
        this.cursorColor[0] = r;
        this.cursorColor[1] = g;
        this.cursorColor[2] = b;
        this.cursorColor[3] = a;
        this.colorSet = true;
    }

    public void setShadeColor(float[] rgba) {
        this.shadeColor = rgba;
    }

    public void setShadeColor(float r, float g, float b, float a) {
        this.shadeColor[0] = r;
        this.shadeColor[1] = g;
        this.shadeColor[2] = b;
        this.shadeColor[3] = a;
    }

    public void setHideVerticalHairs(boolean doHide) {
        this.hideVerticalHairs = doHide;
    }

    public void setHideHorizontalHairs(boolean doHide) {
        this.hideHorizontalHairs = doHide;
    }

    public void setLineWidth(float width) {
        this.lineWidth = width;
    }

    public void showSelectionBox(boolean show) {
        this.showSelectionBox = show;
    }

    public void setShadeSelectionBox(boolean doShade) {
        this.shadeSelectionBox = doShade;
    }

    public void showSelectionCrosshairs(boolean show) {
        this.showSelectionCrosshairs = show;
        this.hideHorizontalHairs = false;
        this.hideVerticalHairs = false;
    }

    public void setXor(boolean xor) {
        this.paintXor = xor;
    }

    private void conditionallyEnableXor(GL gl) {
        if (this.paintXor) {
            gl.glEnable(3058);
            gl.glLogicOp(5382);
        }
    }

    private void conditionallyDisableXor(GL gl) {
        if (this.paintXor) {
            gl.glDisable(3058);
        }
    }

    @Override
    public void setLookAndFeel(LookAndFeel laf) {
        if (!this.colorSet) {
            this.setCursorColor(laf.getColor(AbstractLookAndFeel.CROSSHAIR_COLOR));
            this.colorSet = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void paintTo(GL gl, GlimpseBounds bounds, Axis2D axis) {
        if (axis == null || axis.getAxisX() == null || axis.getAxisY() == null) {
            return;
        }
        Axis1D axisX = axis.getAxisX();
        Axis1D axisY = axis.getAxisY();
        double minX = axisX.getMin();
        double maxX = axisX.getMax();
        double minY = axisY.getMin();
        double maxY = axisY.getMax();
        double centerX = axisX.getSelectionCenter();
        double sizeX = axisX.getSelectionSize() / 2.0;
        double centerY = axisY.getSelectionCenter();
        double sizeY = axisY.getSelectionSize() / 2.0;
        if (this.showSelectionBox) {
            gl.glLineWidth(this.lineWidth);
            gl.glColor4fv(this.paintXor ? this.xorColor : this.cursorColor, 0);
            this.conditionallyEnableXor(gl);
            gl.glBegin(2);
            try {
                gl.glVertex2d(centerX - sizeX, centerY - sizeY);
                gl.glVertex2d(centerX - sizeX, centerY + sizeY);
                gl.glVertex2d(centerX + sizeX, centerY + sizeY);
                gl.glVertex2d(centerX + sizeX, centerY - sizeY);
            }
            finally {
                gl.glEnd();
                this.conditionallyDisableXor(gl);
            }
            if (this.shadeSelectionBox) {
                gl.glColor4fv(this.shadeColor, 0);
                gl.glBegin(7);
                try {
                    gl.glVertex2d(centerX - sizeX, centerY - sizeY);
                    gl.glVertex2d(centerX - sizeX, centerY + sizeY);
                    gl.glVertex2d(centerX + sizeX, centerY + sizeY);
                    gl.glVertex2d(centerX + sizeX, centerY - sizeY);
                }
                finally {
                    gl.glEnd();
                }
            }
        }
        if (!this.showSelectionCrosshairs) return;
        if (this.showSelectionBox) {
            gl.glLineWidth(this.lineWidth);
            gl.glColor4fv(this.paintXor ? this.xorColor : this.cursorColor, 0);
            this.conditionallyEnableXor(gl);
            gl.glBegin(1);
            try {
                if (!this.hideVerticalHairs) {
                    gl.glVertex2d(centerX, minY);
                    gl.glVertex2d(centerX, centerY - sizeY);
                    gl.glVertex2d(centerX, centerY + sizeY);
                    gl.glVertex2d(centerX, maxY);
                }
                if (this.hideHorizontalHairs) return;
                gl.glVertex2d(minX, centerY);
                gl.glVertex2d(centerX - sizeX, centerY);
                gl.glVertex2d(centerX + sizeX, centerY);
                gl.glVertex2d(maxX, centerY);
                return;
            }
            finally {
                gl.glEnd();
                this.conditionallyDisableXor(gl);
            }
        }
        gl.glLineWidth(this.lineWidth);
        gl.glColor4fv(this.paintXor ? this.xorColor : this.cursorColor, 0);
        this.conditionallyEnableXor(gl);
        gl.glBegin(1);
        try {
            if (!this.hideVerticalHairs) {
                gl.glVertex2d(centerX, minY);
                gl.glVertex2d(centerX, maxY);
            }
            if (this.hideHorizontalHairs) return;
            gl.glVertex2d(minX, centerY);
            gl.glVertex2d(maxX, centerY);
            return;
        }
        finally {
            gl.glEnd();
            this.conditionallyDisableXor(gl);
        }
    }
}

