/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.base;

import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.gl.util.GLErrorUtils;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.support.settings.LookAndFeel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.glu.GLU;

public abstract class GlimpsePainterImpl
implements GlimpsePainter {
    public static final Logger logger = Logger.getLogger(GlimpsePainterImpl.class.getName());
    public static final int BYTES_PER_FLOAT = 4;
    protected final GLU glu = new GLU();
    protected boolean disposed = false;
    protected boolean displayOn = true;
    protected boolean doErrorHandling = true;

    protected abstract void paintTo(GlimpseContext var1, GlimpseBounds var2);

    public void setErrorHandling(boolean doErrorHandling) {
        this.doErrorHandling = doErrorHandling;
    }

    public void setVisible(boolean show) {
        this.displayOn = show;
    }

    public boolean isVisible() {
        return this.displayOn;
    }

    @Override
    public void setLookAndFeel(LookAndFeel laf) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GlimpseContext context) {
        if (!this.displayOn) {
            return;
        }
        GlimpseBounds bounds = context.getTargetStack().getBounds();
        if (bounds == null) {
            return;
        }
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        GL gl = context.getGL();
        gl.glPushClientAttrib(-1);
        gl.glPushAttrib(1048575);
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        try {
            this.paintTo(context, bounds);
            if (this.doErrorHandling) {
                this.glHandleError(gl, "GL ERROR: " + this.getClass().getName());
            }
        }
        finally {
            gl.glMatrixMode(5888);
            gl.glPopMatrix();
            gl.glMatrixMode(5889);
            gl.glPopMatrix();
            gl.glPopAttrib();
            gl.glPopClientAttrib();
        }
    }

    @Override
    public void dispose(GlimpseContext context) {
        if (!this.disposed) {
            this.disposed = true;
            this.dispose(context.getGLContext());
        }
    }

    protected void dispose(GLContext context) {
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    protected boolean glHandleError(GL gl) {
        return this.glHandleError(gl, "GL ERROR");
    }

    protected boolean glHandleError(GL gl, String prefix) {
        return GLErrorUtils.logGLError(logger, Level.WARNING, gl, prefix);
    }
}

