/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.layout;

import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GlimpseLayoutCache<D> {
    protected Map<List<GlimpseTarget>, Pair<List<GlimpseBounds>, D>> map = new HashMap<List<GlimpseTarget>, Pair<List<GlimpseBounds>, D>>();

    public D getValue(GlimpseContext context) {
        return this.getValue(context.getTargetStack());
    }

    public D getValue(GlimpseTargetStack layoutStack) {
        List<GlimpseBounds> contextBounds;
        List cachedBounds;
        Pair<List<GlimpseBounds>, D> entry = this.map.get(layoutStack.getTargetList());
        if (entry != null && GlimpseLayoutCache.compareBounds(cachedBounds = (List)entry.first(), contextBounds = layoutStack.getBoundsList())) {
            return (D)entry.second();
        }
        return null;
    }

    public D getValueNoBoundsCheck(GlimpseContext context) {
        return this.getValueNoBoundsCheck(context.getTargetStack());
    }

    public D getValueNoBoundsCheck(GlimpseTargetStack layoutStack) {
        Pair<List<GlimpseBounds>, D> entry = this.map.get(layoutStack.getTargetList());
        if (entry != null) {
            return (D)entry.second();
        }
        return null;
    }

    public void setValue(GlimpseTargetStack stack, D value) {
        this.map.put(stack.getTargetList(), new Pair(stack.getBoundsList(), value));
    }

    public void setValue(GlimpseContext context, D value) {
        this.setValue(context.getTargetStack(), value);
    }

    public void clear() {
        this.map.clear();
    }

    public static boolean compareBounds(List<GlimpseBounds> list1, List<GlimpseBounds> list2) {
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            GlimpseBounds otherBounds;
            GlimpseBounds ourBounds = list1.get(i);
            if (ourBounds.equals(otherBounds = list2.get(i))) continue;
            return false;
        }
        return true;
    }
}

