/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.gl.util;

import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLPbuffer;

public class GLPBufferUtils {
    private GLPBufferUtils() {
    }

    public static boolean canCreateGLPbuffer() {
        return GLDrawableFactory.getFactory().canCreateGLPbuffer();
    }

    public static GLPbuffer createPixelBuffer(int width, int height) {
        return GLPBufferUtils.createPixelBuffer(width, height, null, null);
    }

    public static GLPbuffer createPixelBuffer(int width, int height, GLContext context) {
        return GLPBufferUtils.createPixelBuffer(width, height, context, null);
    }

    public static GLPbuffer createPixelBuffer(int width, int height, GLCapabilities cap) {
        return GLPBufferUtils.createPixelBuffer(width, height, null, cap);
    }

    public static GLPbuffer createPixelBuffer(int width, int height, GLContext context, GLCapabilities cap) {
        if (!GLPBufferUtils.canCreateGLPbuffer()) {
            return null;
        }
        GLDrawableFactory fac = GLDrawableFactory.getFactory();
        if (cap == null) {
            cap = new GLCapabilities();
            cap.setDoubleBuffered(false);
            cap.setDepthBits(0);
            cap.setAlphaBits(0);
            cap.setRedBits(8);
            cap.setGreenBits(8);
            cap.setBlueBits(8);
        }
        GLPbuffer buffer = fac.createGLPbuffer(cap, null, width, height, context);
        return buffer;
    }

    public static void destroyPixelBuffer(GLPbuffer buffer) {
        if (buffer != null) {
            GLContext context = buffer.getContext();
            if (context != null) {
                context.destroy();
            }
            buffer.destroy();
        }
    }
}

