/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.gl.util;

import com.metsci.glimpse.util.logging.LoggerUtils;
import com.sun.opengl.impl.error.Error;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.opengl.GL;

public class GLErrorUtils {
    private GLErrorUtils() {
    }

    public static boolean logGLError(Logger logger, Level level, GL gl, String prefix) {
        int error = gl.glGetError();
        if (error != 0) {
            StackTraceElement[] traceArray = Thread.currentThread().getStackTrace();
            StringBuilder traceString = new StringBuilder();
            if (traceArray != null && traceArray.length > 0) {
                for (int i = 0; i < traceArray.length - 1; ++i) {
                    traceString.append(traceArray[i].toString()).append("\n");
                }
                traceString.append(traceArray[traceArray.length - 1].toString());
            }
            String errorString = Error.gluErrorString((int)error);
            LoggerUtils.logWarning((Logger)logger, (String)"%s (%d): %s%n%s", (Object[])new Object[]{prefix, error, errorString, traceString.toString()});
            return true;
        }
        return false;
    }
}

