/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.gl.shader;

import com.metsci.glimpse.gl.shader.ShaderArg;
import com.metsci.glimpse.gl.shader.grammar.GlslArgLexer;
import com.metsci.glimpse.gl.shader.grammar.GlslArgParser;
import com.metsci.glimpse.util.io.StreamOpener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

public class ShaderSource {
    private static final Logger logger = Logger.getLogger(ShaderSource.class.getName());
    private final String[] lines;

    public ShaderSource(String location, StreamOpener opener) throws IOException {
        this.lines = ShaderSource.readSource(opener.openForRead(location));
    }

    public String[] getSourceLines() {
        if (this.lines == null) {
            return null;
        }
        return Arrays.copyOf(this.lines, this.lines.length);
    }

    public String getSource() {
        StringBuffer r = new StringBuffer();
        for (String line : this.lines) {
            r.append(line).append("\n");
        }
        return r.toString();
    }

    public static String[] readSource(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder b = new StringBuilder();
        String line = null;
        String sep = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            b.append(line.trim() + sep);
        }
        return new String[]{b.toString()};
    }

    public boolean containsMain() {
        return this.getSource().contains(" main(");
    }

    public List<ShaderArg> extractArgs() {
        if (!this.containsMain()) {
            return null;
        }
        try {
            ANTLRStringStream stream = new ANTLRStringStream(this.getSource());
            GlslArgLexer l = new GlslArgLexer((CharStream)stream);
            GlslArgParser p = new GlslArgParser((TokenStream)new CommonTokenStream((TokenSource)l));
            List<ShaderArg> shaderArgs = p.shader().result;
            logger.log(Level.FINER, "Found " + shaderArgs.size() + " args.");
            if (shaderArgs.size() > 0) {
                for (ShaderArg arg : shaderArgs) {
                    logger.log(Level.FINEST, "Shader arg: " + arg.toString());
                }
            }
            return shaderArgs;
        }
        catch (RecognitionException e) {
            logger.severe("Unable to parse shader file.");
            return null;
        }
    }
}

