/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.gl.attribute;

import javax.media.opengl.GL;

public enum GLVertexAttribute {
    ATTRIB_POSITION_1D(1),
    ATTRIB_POSITION_2D(2),
    ATTRIB_POSITION_3D(3),
    ATTRIB_POSITION_4D(4),
    ATTRIB_COLOR_3D(3),
    ATTRIB_COLOR_4D(4),
    ATTRIB_NORMAL(4),
    ATTRIB_TEXCOORD_1D(1),
    ATTRIB_TEXCOORD_2D(2),
    ATTRIB_TEXCOORD_3D(3),
    ATTRIB_TEXCOORD_4D(4);

    public final int length;

    private GLVertexAttribute(int length) {
        this.length = length;
    }

    public void bind(GL gl, int stride, int offset) {
        this.toggle(gl, true, stride, offset);
    }

    public void unbind(GL gl) {
        this.toggle(gl, false, 0, 0);
    }

    private final void toggle(GL gl, boolean bind, int stride, int offset) {
        switch (this) {
            case ATTRIB_POSITION_1D: 
            case ATTRIB_POSITION_2D: 
            case ATTRIB_POSITION_3D: 
            case ATTRIB_POSITION_4D: {
                if (bind) {
                    gl.glEnableClientState(32884);
                    gl.glVertexPointer(this.length, 5126, stride, (long)offset);
                    break;
                }
                gl.glDisableClientState(32884);
                break;
            }
            case ATTRIB_COLOR_3D: 
            case ATTRIB_COLOR_4D: {
                if (bind) {
                    gl.glEnableClientState(32886);
                    gl.glColorPointer(this.length, 5126, stride, (long)offset);
                    break;
                }
                gl.glDisableClientState(32886);
                break;
            }
            case ATTRIB_NORMAL: {
                if (bind) {
                    gl.glEnableClientState(32885);
                    gl.glNormalPointer(5126, stride, (long)offset);
                    break;
                }
                gl.glDisableClientState(32885);
                break;
            }
            case ATTRIB_TEXCOORD_1D: 
            case ATTRIB_TEXCOORD_2D: 
            case ATTRIB_TEXCOORD_3D: 
            case ATTRIB_TEXCOORD_4D: {
                if (bind) {
                    gl.glEnableClientState(32888);
                    gl.glTexCoordPointer(this.length, 5126, 0, 0L);
                    break;
                }
                gl.glDisableClientState(32888);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported attribute.");
            }
        }
    }

    public static void bind(GL gl, int index, int length, int stride, int offset) {
        gl.glEnableVertexAttribArray(index);
        gl.glVertexAttribPointer(index, length, 5126, false, stride, (long)offset);
    }

    public static void unbind(GL gl, int index) {
        gl.glDisableVertexAttribArray(index);
    }
}

