/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.gl;

import com.metsci.glimpse.gl.GLSimpleListener;
import com.metsci.glimpse.gl.util.GLPBufferUtils;
import com.sun.opengl.util.Screenshot;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLPbuffer;

public class GLSimplePixelBuffer {
    private GLPbuffer buffer;
    private static final Logger logger = Logger.getLogger(GLSimplePixelBuffer.class.getName());
    private GLContext context;
    private List<ListenerEntry> listeners;

    public GLSimplePixelBuffer(int width, int height, GLContext _context) {
        this.createPixelBuffer(width, height, _context);
        this.listeners = new CopyOnWriteArrayList<ListenerEntry>();
    }

    protected void createPixelBuffer(int width, int height, GLContext _context) {
        this.buffer = GLPBufferUtils.createPixelBuffer(width, height);
        this.context = this.buffer.createContext(_context);
    }

    public void addListener(GLSimpleListener listener) {
        this.listeners.add(new ListenerEntry(listener));
    }

    public void removeListener(GLSimpleListener listener) {
        this.listeners.remove(listener);
    }

    public Dimension getDimension() {
        return new Dimension(this.buffer.getHeight(), this.buffer.getWidth());
    }

    public void resize(int width, int height, boolean notifyListeners) {
        int currHeight = this.buffer.getHeight();
        int currWidth = this.buffer.getWidth();
        if (currHeight != height || currWidth != width) {
            GLPbuffer oldBuffer = this.buffer;
            this.createPixelBuffer(width, height, this.context);
            oldBuffer.destroy();
            int newHeight = this.buffer.getHeight();
            int newWidth = this.buffer.getWidth();
            if (newHeight == height && newWidth == width && notifyListeners) {
                for (ListenerEntry l : this.listeners) {
                    l.requireReshape();
                }
            }
        }
    }

    public void draw() {
        this.glSyncExec(new GLRunnable(){

            @Override
            public Object run(GLContext context, Rectangle bounds, List<ListenerEntry> entries) {
                for (ListenerEntry l : entries) {
                    l.draw(context, bounds);
                }
                context.getGL().glFlush();
                return null;
            }
        });
    }

    public BufferedImage drawToBufferedImage() {
        return (BufferedImage)this.glSyncExec(new GLRunnable(){

            @Override
            public Object run(GLContext context, Rectangle bounds, List<ListenerEntry> entries) {
                for (ListenerEntry l : GLSimplePixelBuffer.this.listeners) {
                    l.draw(context, bounds);
                }
                context.getGL().glFlush();
                return Screenshot.readToBufferedImage((int)GLSimplePixelBuffer.this.buffer.getWidth(), (int)GLSimplePixelBuffer.this.buffer.getHeight());
            }
        });
    }

    public Object glSyncExec(GLRunnable runnable) {
        this.context.makeCurrent();
        Object result = runnable.run(this.context, this.getBounds(), new ArrayList<ListenerEntry>(this.listeners));
        this.context.release();
        return result;
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
    }

    public GLContext getGLContext() {
        return this.context;
    }

    public void dispose() {
        this.glSyncExec(new GLRunnable(){

            @Override
            public Object run(GLContext context, Rectangle bounds, List<ListenerEntry> entries) {
                for (ListenerEntry entry : entries) {
                    entry.listener.dispose(context);
                }
                return null;
            }
        });
        this.listeners.clear();
        this.context.destroy();
    }

    public static interface GLRunnable {
        public Object run(GLContext var1, Rectangle var2, List<ListenerEntry> var3);
    }

    public static class ListenerEntry {
        private final GLSimpleListener listener;
        private boolean needsInit;
        private boolean needsReshape;
        private boolean warnOnException;

        public ListenerEntry(GLSimpleListener listener) {
            this.listener = listener;
            this.needsInit = true;
            this.needsReshape = true;
            this.warnOnException = true;
        }

        public void requireReshape() {
            this.needsReshape = true;
        }

        public void draw(GLContext context, Rectangle bounds) {
            block4: {
                try {
                    if (this.needsInit) {
                        this.listener.init(context);
                        this.needsInit = false;
                    }
                    if (this.needsReshape) {
                        GL gl = context.getGL();
                        gl.glViewport(0, 0, bounds.width, bounds.height);
                        this.listener.reshape(context, 0, 0, bounds.width, bounds.height);
                        this.needsReshape = false;
                    }
                    this.listener.display(context);
                    this.warnOnException = true;
                }
                catch (Exception e) {
                    if (!this.warnOnException) break block4;
                    logger.log(Level.WARNING, "Listener failed to draw", e);
                    this.warnOnException = false;
                }
            }
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof ListenerEntry) {
                ListenerEntry l = (ListenerEntry)o;
                return this.listener.equals(l.listener);
            }
            return false;
        }
    }
}

