/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.event.mouse.swing;

import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.ModifierKey;
import com.metsci.glimpse.event.mouse.MouseButton;
import com.metsci.glimpse.event.mouse.swing.GlimpseSwingMouseEvent;
import com.metsci.glimpse.event.mouse.swing.GlimpseSwingMouseWheelEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.EnumSet;

public class GlimpseMouseWrapper {
    private GlimpseMouseWrapper() {
    }

    public static GlimpseMouseEvent fromMouseEvent(MouseEvent event) {
        int x = event.getX();
        int y = event.getY();
        int clickCount = event.getClickCount();
        EnumSet<MouseButton> buttons = GlimpseMouseWrapper.getMouseButtons(event);
        EnumSet<ModifierKey> modifiers = GlimpseMouseWrapper.getModifierKeys(event);
        GlimpseTargetStack stack = null;
        if (event instanceof GlimpseSwingMouseEvent) {
            stack = ((GlimpseSwingMouseEvent)event).getTargetStack();
        }
        return new GlimpseMouseEvent(stack, modifiers, buttons, x, y, 0, clickCount);
    }

    public static GlimpseMouseEvent fromMouseWheelEvent(MouseWheelEvent event) {
        int x = event.getX();
        int y = event.getY();
        int wheelRotation = event.getWheelRotation();
        int clickCount = event.getClickCount();
        EnumSet<MouseButton> buttons = GlimpseMouseWrapper.getMouseButtons(event);
        EnumSet<ModifierKey> modifiers = GlimpseMouseWrapper.getModifierKeys(event);
        GlimpseTargetStack stack = null;
        if (event instanceof GlimpseSwingMouseWheelEvent) {
            stack = ((GlimpseSwingMouseWheelEvent)event).getTargetStack();
        }
        return new GlimpseMouseEvent(stack, modifiers, buttons, x, y, wheelRotation, clickCount);
    }

    public static EnumSet<MouseButton> getMouseButtons(MouseEvent event) {
        EnumSet<MouseButton> buttons;
        switch (event.getButton()) {
            case 1: {
                buttons = EnumSet.of(MouseButton.Button1);
                break;
            }
            case 2: {
                buttons = EnumSet.of(MouseButton.Button2);
                break;
            }
            case 3: {
                buttons = EnumSet.of(MouseButton.Button3);
                break;
            }
            default: {
                buttons = EnumSet.noneOf(MouseButton.class);
            }
        }
        int mod = event.getModifiersEx();
        if ((mod & 0x400) == 1024) {
            buttons.add(MouseButton.Button1);
        }
        if ((mod & 0x800) == 2048) {
            buttons.add(MouseButton.Button2);
        }
        if ((mod & 0x1000) == 4096) {
            buttons.add(MouseButton.Button3);
        }
        return buttons;
    }

    public static EnumSet<ModifierKey> getModifierKeys(MouseEvent event) {
        EnumSet<ModifierKey> modifiers = EnumSet.noneOf(ModifierKey.class);
        int mod = event.getModifiersEx();
        if ((mod & 0x200) == 512) {
            modifiers.add(ModifierKey.Alt);
        }
        if ((mod & 0x80) == 128) {
            modifiers.add(ModifierKey.Ctrl);
        }
        if ((mod & 0x100) == 256) {
            modifiers.add(ModifierKey.Meta);
        }
        if ((mod & 0x40) == 64) {
            modifiers.add(ModifierKey.Shift);
        }
        return modifiers;
    }
}

