/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.event.mouse;

import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.context.GlimpseContextImpl;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.context.TargetStackUtil;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.Mouseable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class MouseWrapper<E> {
    protected GlimpseCanvas canvas;
    protected Set<GlimpseTargetStack> hoveredList;

    public MouseWrapper(GlimpseCanvas canvas) {
        this.canvas = canvas;
        this.hoveredList = new HashSet<GlimpseTargetStack>();
    }

    public List<GlimpseTargetStack> getContainingTargets(E e) {
        GlimpseContextImpl context = new GlimpseContextImpl(this.canvas);
        ArrayList<GlimpseTargetStack> result = new ArrayList<GlimpseTargetStack>();
        this.getContainingTargets(e, context, result);
        return result;
    }

    protected boolean getContainingTargets(E e, GlimpseContext context, List<GlimpseTargetStack> accumulator) {
        GlimpseTargetStack stack = context.getTargetStack();
        GlimpseTarget layout = stack.getTarget();
        GlimpseBounds bounds = stack.getBounds();
        List<GlimpseTarget> list = layout.getTargetChildren();
        int size = list.size();
        for (int i = size - 1; i >= 0; --i) {
            GlimpseTarget childLayout = list.get(i);
            GlimpseBounds childBounds = childLayout.getTargetBounds(context.getTargetStack());
            stack.push(childLayout, childBounds);
            boolean consumeEvent = this.getContainingTargets(e, context, accumulator);
            if (consumeEvent) {
                return true;
            }
            stack.pop();
        }
        if (!layout.isEventConsumer() && !layout.isEventGenerator()) {
            return false;
        }
        if (this.handleInterior(e, context, bounds)) {
            if (layout.isEventGenerator()) {
                accumulator.add(TargetStackUtil.newTargetStack(stack));
            }
            return layout.isEventConsumer();
        }
        return false;
    }

    protected boolean handleInterior(E e, GlimpseContext context, GlimpseBounds bounds) {
        if (bounds == null) {
            return false;
        }
        if (!this.isValid(e, bounds)) {
            return false;
        }
        boolean isButtonDown = this.isButtonDown(e);
        boolean isInterior = this.isInterior(e, bounds);
        if (isInterior && !isButtonDown) {
            this.addHovered(context.getTargetStack());
        }
        return isInterior;
    }

    protected Mouseable getMouseTarget(GlimpseTargetStack stack) {
        if (stack == null) {
            return null;
        }
        GlimpseTarget target = stack.getTarget();
        if (target == null || !(target instanceof Mouseable)) {
            return null;
        }
        Mouseable mouseTarget = (Mouseable)((Object)target);
        return mouseTarget;
    }

    protected void clearHovered() {
        this.hoveredList.clear();
    }

    protected void addHovered(GlimpseTargetStack stack) {
        this.hoveredList.add(TargetStackUtil.newTargetStack(stack));
    }

    protected void setHovered(Collection<GlimpseTargetStack> list) {
        this.clearHovered();
        for (GlimpseTargetStack stack : list) {
            this.addHovered(stack);
        }
    }

    protected boolean isHovered() {
        return this.hoveredList != null && !this.hoveredList.isEmpty();
    }

    protected Set<GlimpseTargetStack> getHovered() {
        return this.hoveredList;
    }

    protected GlimpseMouseEvent toLocalGlimpseEvent(E e, GlimpseTargetStack stack) {
        return this.toGlimpseEvent(this.toLocalCoords(e, stack));
    }

    protected abstract boolean isButtonDown(E var1);

    protected abstract boolean isInterior(E var1, GlimpseBounds var2);

    protected abstract boolean isValid(E var1, GlimpseBounds var2);

    protected abstract E toLocalCoords(E var1, GlimpseTargetStack var2);

    protected abstract GlimpseMouseEvent toGlimpseEvent(E var1);
}

