/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.canvas;

import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.context.GlimpseContextImpl;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.gl.GLListenerInfo;
import com.metsci.glimpse.gl.GLSimpleListener;
import com.metsci.glimpse.gl.GLSimplePixelBuffer;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.support.settings.LookAndFeel;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.media.opengl.GLContext;

public class OffscreenGlimpseCanvas
implements GlimpseCanvas {
    protected GLSimplePixelBuffer pixelBuffer;
    protected boolean isDisposed;
    protected List<GlimpseTarget> unmodifiableList;
    protected List<GlimpseLayout> layoutList;

    public OffscreenGlimpseCanvas(int width, int height) {
        this(width, height, null);
    }

    public OffscreenGlimpseCanvas(int width, int height, GLContext _context) {
        this.pixelBuffer = new GLSimplePixelBuffer(width, height, _context);
        this.isDisposed = false;
        this.layoutList = new ArrayList<GlimpseLayout>();
        this.unmodifiableList = Collections.unmodifiableList(this.layoutList);
        this.pixelBuffer.addListener(new GLSimpleListener(){

            @Override
            public void init(GLContext context) {
            }

            @Override
            public void display(GLContext context) {
                for (GlimpseLayout layout : OffscreenGlimpseCanvas.this.layoutList) {
                    layout.paintTo(OffscreenGlimpseCanvas.this.getGlimpseContext());
                }
            }

            @Override
            public void reshape(GLContext context, int x, int y, int width, int height) {
                for (GlimpseLayout layout : OffscreenGlimpseCanvas.this.layoutList) {
                    layout.layoutTo(OffscreenGlimpseCanvas.this.getGlimpseContext());
                }
            }

            @Override
            public void displayChanged(GLContext context, boolean modeChanged, boolean deviceChanged) {
            }

            @Override
            public void dispose(GLContext context) {
            }

            @Override
            public boolean isDisposed() {
                return false;
            }

            @Override
            public GLListenerInfo getInfo() {
                return null;
            }
        });
    }

    public Dimension getDimension() {
        return this.pixelBuffer.getDimension();
    }

    public Object glSyncExec(GLSimplePixelBuffer.GLRunnable runnable) {
        return this.pixelBuffer.glSyncExec(runnable);
    }

    public BufferedImage drawToBufferedImage() {
        return this.pixelBuffer.drawToBufferedImage();
    }

    public void resize(int width, int height, boolean notifyListeners) {
        this.pixelBuffer.resize(width, height, notifyListeners);
    }

    @Override
    public GlimpseContext getGlimpseContext() {
        return new GlimpseContextImpl(this);
    }

    @Override
    public void setLookAndFeel(LookAndFeel laf) {
        for (GlimpseLayout layout : this.layoutList) {
            layout.setLookAndFeel(laf);
        }
    }

    @Override
    public GlimpseBounds getTargetBounds(GlimpseTargetStack stack) {
        return new GlimpseBounds(this.getDimension());
    }

    @Override
    public GlimpseBounds getTargetBounds() {
        return this.getTargetBounds(null);
    }

    @Override
    public void addLayout(GlimpseLayout layout) {
        this.layoutList.add(layout);
    }

    @Override
    public void removeLayout(GlimpseLayout layout) {
        this.layoutList.remove(layout);
    }

    @Override
    public List<GlimpseTarget> getTargetChildren() {
        return this.unmodifiableList;
    }

    @Override
    public void paint() {
        this.pixelBuffer.draw();
    }

    @Override
    public GLContext getGLContext() {
        return this.pixelBuffer.getGLContext();
    }

    @Override
    public void dispose() {
        this.pixelBuffer.dispose();
        this.isDisposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    public String toString() {
        return OffscreenGlimpseCanvas.class.getSimpleName();
    }

    @Override
    public boolean isEventConsumer() {
        return false;
    }

    @Override
    public void setEventConsumer(boolean consume) {
    }

    @Override
    public boolean isEventGenerator() {
        return false;
    }

    @Override
    public void setEventGenerator(boolean generate) {
    }
}

