/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.tagged.painter;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.axis.tagged.Tag;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.axis.tagged.painter.TaggedColorXAxisPainter;
import com.sun.opengl.util.BufferUtil;
import java.nio.FloatBuffer;
import java.util.List;
import javax.media.opengl.GL;

public class TaggedPartialColorXAxisPainter
extends TaggedColorXAxisPainter {
    protected FloatBuffer vertexCoords;
    protected FloatBuffer textureCoords;

    public TaggedPartialColorXAxisPainter(AxisLabelHandler ticks) {
        super(ticks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintColorScale(GL gl, Axis1D axis, int width, int height) {
        if (this.colorTexture != null && axis instanceof TaggedAxis1D) {
            TaggedAxis1D taggedAxis = (TaggedAxis1D)axis;
            this.colorTexture.prepare(gl, 0);
            int count = this.updateCoordinateBuffers(taggedAxis, width, height);
            gl.glTexEnvf(8960, 8704, 7681.0f);
            gl.glPolygonMode(1028, 6914);
            gl.glEnable(3552);
            gl.glEnableClientState(32884);
            gl.glEnableClientState(32888);
            gl.glVertexPointer(2, 5126, 0, this.vertexCoords.rewind());
            gl.glTexCoordPointer(1, 5126, 0, this.textureCoords.rewind());
            try {
                gl.glDrawArrays(8, 0, count);
            }
            finally {
                gl.glDisableClientState(32884);
                gl.glDisableClientState(32888);
                gl.glDisable(3552);
            }
        }
        gl.glDisable(3552);
        this.outlineColorQuad(gl, axis, width, height);
    }

    protected int updateCoordinateBuffers(TaggedAxis1D taggedAxis, int width, int height) {
        List<Tag> tags = taggedAxis.getSortedTags();
        int size = tags.size();
        if (this.vertexCoords == null || this.vertexCoords.capacity() < size * 4) {
            this.vertexCoords = BufferUtil.newFloatBuffer((int)(size * 4));
        }
        if (this.textureCoords == null || this.textureCoords.capacity() < size * 2) {
            this.textureCoords = BufferUtil.newFloatBuffer((int)(size * 2));
        }
        this.vertexCoords.rewind();
        this.textureCoords.rewind();
        int y1 = this.getColorBarMinY(height);
        int y2 = this.getColorBarMaxY(height);
        int count = 0;
        for (Tag tag : tags) {
            Object attr = tag.getAttribute("TexCoord");
            if (attr == null || attr.getClass() != Float.class) continue;
            float textureCoord = ((Float)attr).floatValue();
            float vertexCoord = taggedAxis.valueToScreenPixel(tag.getValue());
            this.vertexCoords.put(vertexCoord).put(y1).put(vertexCoord).put(y2);
            this.textureCoords.put(textureCoord).put(textureCoord);
            count += 2;
        }
        return count;
    }
}

