/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.tagged.painter;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.painter.ColorXAxisPainter;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.axis.tagged.Tag;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.support.color.GlimpseColor;
import javax.media.opengl.GL;

public class TaggedColorXAxisPainter
extends ColorXAxisPainter {
    protected static final float DEFAULT_TAG_POINTER_OUTLINE_WIDTH = 2.0f;
    protected static final int DEFAULT_TAG_POINTER_HEIGHT = 7;
    protected static final int DEFAULT_TAG_HEIGHT = 15;
    protected static final int DEFAULT_TAG_HALFBASE = 5;
    protected float[] tagColor = GlimpseColor.fromColorRgba(0.0f, 0.0f, 0.0f, 0.2f);
    protected int tagHalfWidth = 5;
    protected int tagHeight = 15;
    protected int tagPointerHeight = 7;
    protected float tagPointerOutlineWidth = 2.0f;

    public TaggedColorXAxisPainter(AxisLabelHandler ticks) {
        super(ticks);
        this.tickBufferSize = 10;
    }

    public void setTagColor(float[] color) {
        this.tagColor = color;
    }

    public void setTagHalfWidth(int halfWidth) {
        this.tagHalfWidth = halfWidth;
    }

    public void setTagHeight(int height) {
        this.tagHeight = height;
    }

    @Override
    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis1D axis) {
        if (axis instanceof TaggedAxis1D) {
            TaggedAxis1D taggedAxis = (TaggedAxis1D)axis;
            GL gl = context.getGL();
            int width = bounds.getWidth();
            int height = bounds.getHeight();
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            gl.glOrtho(-0.5, (double)((float)(width - 1) + 0.5f), -0.5, (double)((float)(height - 1) + 0.5f), -1.0, 1.0);
            gl.glBlendFunc(770, 771);
            gl.glEnable(3042);
            this.paintColorScale(gl, taggedAxis, width, height);
            this.paintTicks(gl, taggedAxis, width, height);
            this.paintSelectionLine(gl, taggedAxis, width, height);
            this.paintTags(gl, taggedAxis, width, height);
        }
    }

    protected void paintTags(GL gl, TaggedAxis1D taggedAxis, int width, int height) {
        for (Tag tag : taggedAxis.getSortedTags()) {
            this.paintTag(gl, tag, taggedAxis, width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintTag(GL gl, Tag tag, TaggedAxis1D taggedAxis, int width, int height) {
        int x = taggedAxis.valueToScreenPixel(tag.getValue());
        int yMin = this.getTagMinY(height);
        int yMid = this.getTagPointerMaxY(height);
        int yMax = this.getTagMaxY(height);
        GlimpseColor.glColor(gl, this.tagColor);
        gl.glBegin(4);
        try {
            gl.glVertex2f((float)x, (float)yMin);
            gl.glVertex2f((float)(x - this.tagHalfWidth), (float)yMid);
            gl.glVertex2f((float)(x + this.tagHalfWidth), (float)yMid);
        }
        finally {
            gl.glEnd();
        }
        gl.glBegin(7);
        try {
            gl.glVertex2f((float)(x - this.tagHalfWidth), (float)yMax);
            gl.glVertex2f((float)(x - this.tagHalfWidth), (float)yMid);
            gl.glVertex2f((float)(x + this.tagHalfWidth), (float)yMid);
            gl.glVertex2f((float)(x + this.tagHalfWidth), (float)yMax);
        }
        finally {
            gl.glEnd();
        }
        GlimpseColor.glColor(gl, GlimpseColor.getBlack(), 1.0f);
        gl.glLineWidth(this.tagPointerOutlineWidth);
        gl.glEnable(2848);
        gl.glBegin(2);
        try {
            gl.glVertex2f((float)x, (float)yMin);
            gl.glVertex2f((float)(x + this.tagHalfWidth), (float)yMid);
            gl.glVertex2f((float)(x + this.tagHalfWidth), (float)yMax);
            gl.glVertex2f((float)(x - this.tagHalfWidth), (float)yMax);
            gl.glVertex2f((float)(x - this.tagHalfWidth), (float)yMid);
            gl.glVertex2f((float)x, (float)yMin);
        }
        finally {
            gl.glEnd();
        }
    }

    public int getTagMinY(int height) {
        return height - 1 - this.tickBufferSize - this.colorBarSize;
    }

    public int getTagMaxY(int height) {
        return this.getTagMinY(height) + this.tagHeight;
    }

    public int getTagPointerMaxY(int height) {
        return this.getTagMinY(height) + this.tagPointerHeight;
    }
}

