/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.painter;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.painter.NumericYAxisPainter;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.axis.painter.label.AxisUnitConverter;
import com.metsci.glimpse.support.color.GlimpseColor;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL;

public class NumericRotatedYAxisPainter
extends NumericYAxisPainter {
    public NumericRotatedYAxisPainter(AxisLabelHandler ticks) {
        super(ticks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintTicks(GL gl, Axis1D axis, int width, int height) {
        int i;
        double[] yTicks = this.ticks.getTickPositions(axis);
        String[] yLabels = this.ticks.getTickLabels(axis, yTicks);
        AxisUnitConverter converter = this.ticks.getAxisUnitConverter();
        int iTick0 = this.getTickRightX(width, this.tickSize);
        int iTick1 = this.getTickLeftX(width, this.tickSize);
        int min = -1;
        int max = yTicks.length;
        GlimpseColor.glColor(gl, this.tickColor);
        gl.glBegin(1);
        try {
            for (i = 0; i < yTicks.length; ++i) {
                int jTick = axis.valueToScreenPixel(converter.fromAxisUnits(yTicks[i]));
                if (jTick > height - 1 && !this.showLabelsForOffscreenTicks) {
                    max = i;
                    break;
                }
                if (jTick < 0 && !this.showLabelsForOffscreenTicks) {
                    min = i;
                    continue;
                }
                if (jTick == height) {
                    jTick = height - 1;
                }
                gl.glVertex2f((float)iTick0, (float)jTick);
                gl.glVertex2f((float)iTick1, (float)jTick);
            }
            if (this.showMinorTicks) {
                double[] xMinor = this.ticks.getMinorTickPositions(yTicks);
                iTick0 = this.getTickRightX(width, this.tickSize / 2);
                iTick1 = this.getTickLeftX(width, this.tickSize / 2);
                for (int i2 = 0; i2 < xMinor.length; ++i2) {
                    int jTick = axis.valueToScreenPixel(converter.fromAxisUnits(xMinor[i2]));
                    gl.glVertex2f((float)iTick0, (float)jTick);
                    gl.glVertex2f((float)iTick1, (float)jTick);
                }
            }
        }
        finally {
            gl.glEnd();
        }
        GlimpseColor.setColor(this.textRenderer, this.tickLabelColor);
        for (i = min + 1; i < max; ++i) {
            double yTick = yTicks[i];
            String yLabel = yLabels[i];
            Rectangle2D tickTextBounds = this.textRenderer.getBounds(yLabel);
            int iTickText = this.getTickTextPositionX(width, (int)tickTextBounds.getHeight());
            int jTickText = (int)Math.round((double)axis.valueToScreenPixel(converter.fromAxisUnits(yTick)) + tickTextBounds.getWidth() / 2.0);
            if (this.keepLabelsForExtremaFullyVisible) {
                if ((double)jTickText < tickTextBounds.getWidth()) {
                    jTickText = (int)tickTextBounds.getWidth();
                }
                if (jTickText > height) {
                    jTickText = height;
                }
            }
            this.textRenderer.beginRendering(width, height);
            try {
                gl.glMatrixMode(5889);
                gl.glTranslatef((float)iTickText, (float)jTickText, 0.0f);
                gl.glRotatef(-90.0f, 0.0f, 0.0f, 1.0f);
                this.textRenderer.draw(yLabel, 0, 0);
                continue;
            }
            finally {
                this.textRenderer.endRendering();
            }
        }
    }
}

