/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.listener.AxisListener1D;
import com.metsci.glimpse.axis.listener.AxisListener2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseTargetStack;

public class Axis2D {
    protected Axis1D x;
    protected Axis1D y;

    public Axis2D(Axis1D x, Axis1D y) {
        this.x = x;
        this.y = y;
    }

    public Axis2D() {
        this(new Axis1D(), new Axis1D());
    }

    public Axis2D clone() {
        Axis1D newX = this.x.clone();
        Axis1D newY = this.y.clone();
        if (this.x.getLockedAspectAxis() == this.y) {
            newX.lockAspectRatio(newY, this.x.getLockedAspectRatio());
        }
        if (this.y.getLockedAspectAxis() == this.x) {
            newY.lockAspectRatio(newX, this.y.getLockedAspectRatio());
        }
        return new Axis2D(newX, newY);
    }

    public void addAxisListener(final AxisListener2D listener) {
        this.x.addAxisListener(new AxisListener1D(){

            @Override
            public void axisUpdated(Axis1D axis) {
                listener.axisUpdated(Axis2D.this);
            }
        });
        this.y.addAxisListener(new AxisListener1D(){

            @Override
            public void axisUpdated(Axis1D axis) {
                listener.axisUpdated(Axis2D.this);
            }
        });
    }

    public void lockAspectRatioXY(double x_to_y_ratio) {
        this.x.lockAspectRatio(this.y, x_to_y_ratio);
        this.y.lockAspectRatio(this.x, 1.0 / x_to_y_ratio);
        this.applyConstraints();
        this.updateLinkedAxes();
    }

    public void applyConstraints() {
        this.x.applyConstraints();
        this.y.applyConstraints();
    }

    public void updateLinkedAxes() {
        this.x.updateLinkedAxes(this.y);
        this.y.updateLinkedAxes();
    }

    public void unlockAspectRatioXY() {
        this.x.unlockAspectRatio();
        this.y.unlockAspectRatio();
    }

    public void centerOnPoint(double newCenterX, double newCenterY) {
        double minX = this.getMinX();
        double maxX = this.getMaxX();
        double minY = this.getMinY();
        double maxY = this.getMaxY();
        double centerX = (maxX - minX) / 2.0 + minX;
        double centerY = (maxY - minY) / 2.0 + minY;
        double transX = newCenterX - centerX;
        double transY = newCenterY - centerY;
        this.x.setMin(minX + transX);
        this.x.setMax(maxX + transX);
        this.y.setMin(minY + transY);
        this.y.setMax(maxY + transY);
        this.x.validate();
        this.y.validate();
    }

    public void set(double minX, double maxX, double minY, double maxY) {
        this.x.setMin(minX);
        this.x.setMax(maxX);
        this.y.setMin(minY);
        this.y.setMax(maxY);
    }

    public double getMinX() {
        return this.x.getMin();
    }

    public double getMaxX() {
        return this.x.getMax();
    }

    public double getMinY() {
        return this.y.getMin();
    }

    public double getMaxY() {
        return this.y.getMax();
    }

    public Axis1D getAxisX() {
        return this.x;
    }

    public Axis1D getAxisY() {
        return this.y;
    }

    public void setParent(Axis2D parent) {
        if (this.x != null) {
            this.x.setParent(parent == null ? null : parent.getAxisX());
        }
        if (this.y != null) {
            this.y.setParent(parent == null ? null : parent.getAxisY());
        }
    }

    public void setLinkChildren(boolean link) {
        if (this.x != null) {
            this.x.setLinkChildren(link);
        }
        if (this.y != null) {
            this.y.setLinkChildren(link);
        }
    }

    public void setSizePixels(GlimpseTargetStack stack) {
        this.setSizePixels(stack.getBounds());
    }

    public void setSizePixels(GlimpseBounds bounds) {
        if (this.x != null) {
            this.x.setSizePixels(bounds.getWidth(), false);
        }
        if (this.y != null) {
            this.y.setSizePixels(bounds.getHeight(), false);
        }
        if (this.x != null) {
            this.x.setInitialized();
        }
        if (this.y != null) {
            this.y.setInitialized();
        }
    }

    public String toString() {
        return String.format("[%s %s]", this.x, this.y);
    }
}

