/*
 * Copyright (c) 2012, Metron, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Metron, Inc. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL METRON, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.metsci.glimpse.charts.shoreline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author hogye
 */
public class LandSegment
{
    public final List<LandVertex> vertices;

    public boolean isFillable;
    public final List<LandVertex> ghostVertices;


    public static LandSegment newFillableSegment(List<LandVertex> vertices)
    {
        return new LandSegment(vertices, true, new ArrayList<LandVertex>());
    }

    public static LandSegment newFillableSegment(List<LandVertex> vertices, List<LandVertex> ghostVertices)
    {
        return new LandSegment(vertices, true, ghostVertices);
    }

    public static LandSegment newUnfillableSegment(List<LandVertex> vertices)
    {
        return new LandSegment(vertices, false, new ArrayList<LandVertex>());
    }

    private LandSegment(List<LandVertex> vertices, boolean isFillable, List<LandVertex> ghostVertices)
    {
        this.vertices = Collections.unmodifiableList(new ArrayList<LandVertex>(vertices));

        this.isFillable = isFillable;
        this.ghostVertices = Collections.unmodifiableList(new ArrayList<LandVertex>(ghostVertices));
    }

}
