/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.docking;

import com.metsci.glimpse.docking.DockingPane;
import com.metsci.glimpse.docking.DockingTheme;
import com.metsci.glimpse.docking.DockingThemes;
import com.metsci.glimpse.docking.DockingUtils;
import com.metsci.glimpse.docking.View;
import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class DockingExample {
    protected static final Logger logger = Logger.getLogger(DockingExample.class.getName());

    public static void main(String[] args) throws Exception {
        Theme.loadTheme((URL)DockingExample.class.getClassLoader().getResource("tinylaf/radiance.theme"));
        UIManager.setLookAndFeel((LookAndFeel)new TinyLookAndFeel());
        DockingTheme dockingTheme = DockingThemes.tinyLafDockingTheme();
        JPanel aPanel = new JPanel(){
            {
                this.setBackground(Color.red);
            }
        };
        JPanel bPanel = new JPanel(){
            {
                this.setBackground(Color.green);
            }
        };
        JPanel cPanel = new JPanel(){
            {
                this.setBackground(Color.blue);
            }
        };
        JPanel dPanel = new JPanel(){
            {
                this.setBackground(Color.cyan);
            }
        };
        JPanel ePanel = new JPanel(){
            {
                this.setBackground(Color.magenta);
            }
        };
        JPanel fPanel = new JPanel(){
            {
                this.setBackground(Color.yellow);
            }
        };
        JPanel gPanel = new JPanel(){
            {
                this.setBackground(Color.gray);
            }
        };
        JPanel hPanel = new JPanel(){
            {
                this.setBackground(Color.white);
            }
        };
        JToolBar aToolbar = DockingUtils.newToolbar((boolean)true);
        aToolbar.add(new JButton("A1"));
        aToolbar.add(new JButton("A2"));
        aToolbar.add(new JButton("A3"));
        JToggleButton aOptionsButton = new JToggleButton(dockingTheme.optionsIcon);
        JPopupMenu aOptionsPopup = DockingUtils.newButtonPopup((JToggleButton)aOptionsButton);
        aOptionsPopup.add(new JMenuItem("Option 1"));
        aToolbar.add(aOptionsButton);
        JToolBar bToolbar = DockingUtils.newToolbar((boolean)true);
        bToolbar.add(new JButton("B1"));
        JToolBar cToolbar = null;
        JToolBar dToolbar = DockingUtils.newToolbar((boolean)true);
        dToolbar.add(new JButton("D1"));
        dToolbar.add(new JButton("D2"));
        dToolbar.add(new JButton("D3"));
        dToolbar.add(new JButton("D4"));
        dToolbar.add(new JButton("D5"));
        JToolBar eToolbar = DockingUtils.newToolbar((boolean)true);
        eToolbar.add(new JButton("E1"));
        eToolbar.add(new JButton("E2"));
        JToolBar fToolbar = DockingUtils.newToolbar((boolean)true);
        fToolbar.add(new JButton("F1"));
        fToolbar.add(new JButton("F2"));
        fToolbar.add(new JButton("F3"));
        JToolBar gToolbar = DockingUtils.newToolbar((boolean)true);
        JToolBar hToolbar = DockingUtils.newToolbar((boolean)true);
        hToolbar.add(new JButton("H1"));
        final DockingPane dockingPane = new DockingPane(dockingTheme);
        dockingPane.addView(new View("aView", "View A", (Icon)DockingUtils.requireIcon((String)"icons/ViewA.png"), null, (Component)aPanel, aToolbar));
        dockingPane.addView(new View("bView", "View B", (Icon)DockingUtils.requireIcon((String)"icons/ViewB.png"), null, (Component)bPanel, bToolbar));
        dockingPane.addView(new View("cView", "View C", (Icon)DockingUtils.requireIcon((String)"icons/ViewC.png"), null, (Component)cPanel, cToolbar));
        dockingPane.addView(new View("dView", "View D", (Icon)DockingUtils.requireIcon((String)"icons/ViewD.png"), null, (Component)dPanel, dToolbar));
        dockingPane.addView(new View("eView", "View E", (Icon)DockingUtils.requireIcon((String)"icons/ViewE.png"), null, (Component)ePanel, eToolbar));
        dockingPane.addView(new View("fView", "View F", (Icon)DockingUtils.requireIcon((String)"icons/ViewF.png"), null, (Component)fPanel, fToolbar));
        dockingPane.addView(new View("gView", "View G", (Icon)DockingUtils.requireIcon((String)"icons/ViewG.png"), null, (Component)gPanel, gToolbar));
        dockingPane.addView(new View("hView", "View H", (Icon)DockingUtils.requireIcon((String)"icons/ViewH.png"), null, (Component)hPanel, hToolbar));
        JFrame frame = new JFrame("Docking Example");
        frame.setDefaultCloseOperation(3);
        frame.setContentPane((Container)dockingPane);
        frame.setPreferredSize(new Dimension(1600, 900));
        frame.pack();
        DockingUtils.swingRun((DockingUtils.Runnable1)dockingPane.restoreArrangement, (Object)DockingExample.loadDockingArrangement("docking-example"));
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                DockingExample.saveDockingArrangement("docking-example", dockingPane.captureArrangement());
            }
        });
        frame.setVisible(true);
    }

    public static void saveDockingArrangement(String appName, DockingPane.Arrangement.ArrangementNode arrangement) {
        try {
            File arrangementFile = new File(DockingUtils.createAppDir((String)appName), "arrangement.xml");
            DockingPane.Arrangement.writeDockingArrangementXml((DockingPane.Arrangement.ArrangementNode)arrangement, (File)arrangementFile);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to write docking arrangement to file", e);
        }
    }

    public static DockingPane.Arrangement.ArrangementNode loadDockingArrangement(String appName) {
        try {
            File arrangementFile = new File(DockingUtils.createAppDir((String)appName), "arrangement.xml");
            if (arrangementFile.exists()) {
                return DockingPane.Arrangement.readDockingArrangementXml((File)arrangementFile);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to load docking arrangement from file", e);
        }
        try {
            return DockingPane.Arrangement.readDockingArrangementXml((InputStream)DockingExample.class.getClassLoader().getResourceAsStream("docking/arrangement-default.xml"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

