/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.texture.mutator;

import com.metsci.glimpse.gl.texture.ColorTexture1D;
import com.metsci.glimpse.support.colormap.ColorGradient;
import java.nio.FloatBuffer;

public class ColorGradientConcatenator
implements ColorTexture1D.MutatorColor1D {
    protected ColorGradient[] colorGradients;

    public ColorGradientConcatenator(ColorGradient ... gradients) {
        this.colorGradients = gradients;
    }

    @Override
    public void mutate(FloatBuffer floatBuffer, int dim) {
        for (int i = 0; i < this.colorGradients.length; ++i) {
            ColorGradient colorScale = this.colorGradients[i];
            int size = (int)Math.floor((double)dim / (double)this.colorGradients.length);
            int startIndex = size * i;
            int endIndex = Math.min(size * (i + 1), dim);
            this.mutate(floatBuffer, colorScale, startIndex, endIndex);
        }
    }

    protected void mutate(FloatBuffer floatBuffer, ColorGradient colorGradient, int startIndex, int endIndex) {
        floatBuffer.position(startIndex * 4);
        float[] rgbaBytes = new float[4];
        int length = endIndex - startIndex;
        for (int i = 0; i < length; ++i) {
            colorGradient.toColor((float)i / (float)(length - 1), rgbaBytes);
            floatBuffer.put(rgbaBytes[0]);
            floatBuffer.put(rgbaBytes[1]);
            floatBuffer.put(rgbaBytes[2]);
            floatBuffer.put(rgbaBytes[3]);
        }
    }
}

