/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.texture;

import com.metsci.glimpse.gl.texture.DrawableTexture;
import com.metsci.glimpse.gl.util.GLUtils;
import com.metsci.glimpse.support.projection.InvertibleProjection;
import com.metsci.glimpse.support.projection.Projection;
import com.sun.opengl.util.BufferUtil;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public abstract class TextureProjected2D
implements DrawableTexture {
    public static final int NUM_DIMENSIONS = 2;
    public static final int VERTICES_PER_QUAD = 4;
    public static final int BYTES_PER_FLOAT = 4;
    private static final Logger logger = Logger.getLogger(TextureProjected2D.class.getName());
    protected Projection projection;
    protected ByteBuffer data;
    protected FloatBuffer coordBuffer;
    protected boolean useVertexZCoord;
    protected int floatsPerVertex;
    protected int numTextures;
    protected int textureCountX;
    protected int textureCountY;
    protected int maxTextureSize;
    protected int[] textureHandles;
    protected int[] vertexCoordHandles;
    protected int[] texCoordHandles;
    protected int[] texStartsX;
    protected int[] texStartsY;
    protected int[] texSizesX;
    protected int[] texSizesY;
    protected int[] texQuadCounts;
    protected ReentrantLock lock = new ReentrantLock();
    protected boolean glAllocated;
    protected boolean dirty;
    protected boolean projectionDirty;
    protected int dataSizeX;
    protected int dataSizeY;

    public TextureProjected2D(int dataSizeX, int dataSizeY, boolean useVertexZCoord) {
        this.useVertexZCoord = useVertexZCoord;
        this.floatsPerVertex = useVertexZCoord ? 3 : 2;
        this.dataSizeX = dataSizeX;
        this.dataSizeY = dataSizeY;
        this.data = this.newByteBuffer();
    }

    protected abstract void prepare_setData(GL var1);

    protected abstract int getRequiredCapacityBytes();

    protected abstract float getData(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDataValue(double coordX, double coordY) {
        this.lock.lock();
        try {
            Projection projection = this.getProjection();
            if (projection == null) {
                double d = 0.0;
                return d;
            }
            if (projection instanceof InvertibleProjection) {
                InvertibleProjection invProjection = (InvertibleProjection)((Object)projection);
                double fracX = invProjection.getTextureFractionX(coordX, coordY);
                double fracY = invProjection.getTextureFractionY(coordX, coordY);
                int x = (int)Math.floor(fracX * (double)this.dataSizeX);
                int y = (int)Math.floor(fracY * (double)this.dataSizeY);
                double d = this.getDataValue(x, y);
                return d;
            }
        }
        finally {
            this.lock.unlock();
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getDataValue(int indexX, int indexY) {
        this.lock.lock();
        try {
            if (indexX < 0 || indexY < 0 || indexX >= this.dataSizeX || indexY >= this.dataSizeY) {
                float f = 0.0f;
                return f;
            }
            float f = this.getData(indexY * this.dataSizeX + indexX);
            return f;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void makeProjectionDirty() {
        this.projectionDirty = true;
    }

    @Override
    public void makeDirty() {
        this.dirty = true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty || this.projectionDirty;
    }

    @Override
    public int getNumDimension() {
        return 2;
    }

    @Override
    public int getDimensionSize(int n) {
        switch (n) {
            case 0: {
                return this.dataSizeX;
            }
            case 1: {
                return this.dataSizeY;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepare(GL gl, int texUnit) {
        this.lock.lock();
        try {
            if (!this.glAllocated) {
                this.allocate_calcSizes(gl);
                this.allocate_genTextureHandles(gl);
                this.allocate_genBuffers(gl);
            }
            gl.glActiveTexture(GLUtils.getGLTextureUnit(texUnit));
            this.prepare_glState(gl);
            if (this.glAllocated && this.dirty) {
                this.prepare_setData(gl);
                this.dirty = false;
            }
            if (this.glAllocated && this.projectionDirty) {
                this.prepare_setCoords(gl);
                this.projectionDirty = false;
            }
            boolean bl = !this.isDirty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(GL gl, int texUnit) {
        boolean ready = this.prepare(gl, texUnit);
        if (!ready) {
            logger.log(Level.WARNING, "Unable to make ready.");
            return;
        }
        gl.glTexEnvf(8960, 8704, 7681.0f);
        gl.glPolygonMode(1028, 6914);
        gl.glEnableClientState(32884);
        gl.glEnableClientState(32888);
        try {
            for (int i = 0; i < this.numTextures; ++i) {
                gl.glBindTexture(GLUtils.getGLTextureDim(2), this.textureHandles[i]);
                gl.glBindBuffer(34962, this.vertexCoordHandles[i]);
                gl.glVertexPointer(this.floatsPerVertex, 5126, 0, 0L);
                gl.glBindBuffer(34962, this.texCoordHandles[i]);
                gl.glTexCoordPointer(2, 5126, 0, 0L);
                int vertexCount = 4 * this.texQuadCounts[i];
                gl.glDrawArrays(7, 0, vertexCount);
            }
        }
        finally {
            gl.glBindBuffer(34962, 0);
            gl.glDisableClientState(32884);
            gl.glDisableClientState(32888);
        }
    }

    @Override
    public void dispose(GLContext context) {
        GL gl = context.getGL();
        if (this.textureHandles != null) {
            gl.glDeleteTextures(this.numTextures, this.textureHandles, 0);
        }
        if (this.vertexCoordHandles != null) {
            gl.glDeleteBuffers(this.numTextures, this.vertexCoordHandles, 0);
        }
        if (this.texCoordHandles != null) {
            gl.glDeleteBuffers(this.numTextures, this.texCoordHandles, 0);
        }
    }

    protected void prepare_glState(GL gl) {
        gl.glEnable(3553);
        gl.glBlendFunc(770, 771);
        gl.glEnable(3042);
    }

    protected void allocate_calcSizes(GL gl) {
        this.maxTextureSize = TextureProjected2D.getMaxGLTextureSize(gl);
        this.textureCountX = this.dataSizeX / this.maxTextureSize;
        this.textureCountY = this.dataSizeY / this.maxTextureSize;
        if (this.dataSizeX % this.maxTextureSize != 0) {
            ++this.textureCountX;
        }
        if (this.dataSizeY % this.maxTextureSize != 0) {
            ++this.textureCountY;
        }
        this.numTextures = this.textureCountX * this.textureCountY;
    }

    protected void allocate_genTextureHandles(GL gl) {
        if (this.textureHandles != null) {
            gl.glDeleteTextures(this.numTextures, this.textureHandles, 0);
        }
        if (this.numTextures == 0 || this.projection == null) {
            return;
        }
        this.textureHandles = new int[this.numTextures];
        gl.glGenTextures(this.numTextures, this.textureHandles, 0);
    }

    protected void allocate_genBuffers(GL gl) {
        if (this.vertexCoordHandles != null) {
            gl.glDeleteBuffers(this.numTextures, this.vertexCoordHandles, 0);
        }
        if (this.texCoordHandles != null) {
            gl.glDeleteBuffers(this.numTextures, this.texCoordHandles, 0);
        }
        if (this.numTextures == 0 || this.projection == null) {
            return;
        }
        this.vertexCoordHandles = new int[this.numTextures];
        gl.glGenBuffers(this.numTextures, this.vertexCoordHandles, 0);
        this.texCoordHandles = new int[this.numTextures];
        gl.glGenBuffers(this.numTextures, this.texCoordHandles, 0);
        this.texStartsX = new int[this.numTextures];
        this.texStartsY = new int[this.numTextures];
        this.texSizesX = new int[this.numTextures];
        this.texSizesY = new int[this.numTextures];
        this.texQuadCounts = new int[this.numTextures];
        int index = 0;
        for (int x = 0; x < this.textureCountX; ++x) {
            for (int y = 0; y < this.textureCountY; ++y) {
                int startX = x * this.maxTextureSize;
                int startY = y * this.maxTextureSize;
                int endX = Math.min(startX + this.maxTextureSize, this.dataSizeX);
                int endY = Math.min(startY + this.maxTextureSize, this.dataSizeY);
                int sizeX = endX - startX;
                int sizeY = endY - startY;
                this.texStartsX[index] = startX;
                this.texStartsY[index] = startY;
                this.texSizesX[index] = sizeX;
                this.texSizesY[index] = sizeY;
                this.texQuadCounts[index] = this.getQuadCountForTexture(index, startX, startY, sizeX, sizeY);
                ++index;
            }
        }
        this.glAllocated = true;
        this.makeDirty();
        this.makeProjectionDirty();
    }

    public static int getMaxGLTextureSize(GL gl) {
        int[] result = new int[1];
        gl.glGetIntegerv(3379, result, 0);
        return result[0];
    }

    protected int getQuadCountForTexture(int texIndex, int texStartX, int texStartY, int texSizeX, int texSizeY) {
        int quadCountX = this.projection.getSizeX(texSizeX);
        int quadCountY = this.projection.getSizeY(texSizeY);
        return quadCountX * quadCountY;
    }

    protected void prepare_setCoords(GL gl) {
        float[] temp = new float[this.floatsPerVertex];
        for (int i = 0; i < this.numTextures; ++i) {
            int projectFloats = this.texQuadCounts[i] * 4 * this.floatsPerVertex;
            if (this.coordBuffer == null || this.coordBuffer.capacity() < projectFloats) {
                this.coordBuffer = BufferUtil.newFloatBuffer((int)projectFloats);
            }
            this.coordBuffer.rewind();
            this.putVerticesCoords(i, this.texStartsX[i], this.texStartsY[i], this.texSizesX[i], this.texSizesY[i], temp);
            gl.glBindBuffer(34962, this.vertexCoordHandles[i]);
            gl.glBufferData(34962, projectFloats * 4, this.coordBuffer.rewind(), 35044);
            this.coordBuffer.rewind();
            this.putVerticesTexCoords(i, this.texStartsX[i], this.texStartsY[i], this.texSizesX[i], this.texSizesY[i]);
            gl.glBindBuffer(34962, this.texCoordHandles[i]);
            gl.glBufferData(34962, projectFloats * 4, this.coordBuffer.rewind(), 35044);
        }
    }

    protected void putVerticesCoords(int texIndex, int texStartX, int texStartY, int texSizeX, int texSizeY, float[] temp) {
        int quadCountX = this.projection.getSizeX(texSizeX);
        int quadCountY = this.projection.getSizeY(texSizeY);
        for (int x = 0; x < quadCountX; ++x) {
            double texFracX0 = (double)x / (double)quadCountX;
            double texFracX1 = (double)(x + 1) / (double)quadCountX;
            for (int y = 0; y < quadCountY; ++y) {
                double texFracY0 = (double)y / (double)quadCountY;
                double texFracY1 = (double)(y + 1) / (double)quadCountY;
                this.putVertexCoords(texIndex, texFracX0, texFracY0, temp);
                this.putVertexCoords(texIndex, texFracX1, texFracY0, temp);
                this.putVertexCoords(texIndex, texFracX1, texFracY1, temp);
                this.putVertexCoords(texIndex, texFracX0, texFracY1, temp);
            }
        }
    }

    protected void putVertexCoords(int texIndex, double texFracX, double texFracY, float[] temp) {
        double dataFracX = ((double)this.texStartsX[texIndex] + (double)this.texSizesX[texIndex] * texFracX) / (double)this.dataSizeX;
        double dataFracY = ((double)this.texStartsY[texIndex] + (double)this.texSizesY[texIndex] * texFracY) / (double)this.dataSizeY;
        if (this.useVertexZCoord) {
            this.projection.getVertexXYZ(dataFracX, dataFracY, temp);
            this.coordBuffer.put(temp[0]).put(temp[1]).put(temp[2]);
        } else {
            this.projection.getVertexXY(dataFracX, dataFracY, temp);
            this.coordBuffer.put(temp[0]).put(temp[1]);
        }
    }

    protected void putVerticesTexCoords(int texIndex, int texStartX, int texStartY, int texSizeX, int texSizeY) {
        int quadCountX = this.projection.getSizeX(texSizeX);
        int quadCountY = this.projection.getSizeY(texSizeY);
        for (int x = 0; x < quadCountX; ++x) {
            double texFracX0 = (double)x / (double)quadCountX;
            double texFracX1 = (double)(x + 1) / (double)quadCountX;
            for (int y = 0; y < quadCountY; ++y) {
                double texFracY0 = (double)y / (double)quadCountY;
                double texFracY1 = (double)(y + 1) / (double)quadCountY;
                this.putVertexTexCoords(texIndex, texFracX0, texFracY0);
                this.putVertexTexCoords(texIndex, texFracX1, texFracY0);
                this.putVertexTexCoords(texIndex, texFracX1, texFracY1);
                this.putVertexTexCoords(texIndex, texFracX0, texFracY1);
            }
        }
    }

    protected void putVertexTexCoords(int texIndex, double texFracX, double texFracY) {
        this.coordBuffer.put((float)texFracX).put((float)texFracY);
    }

    protected void prepare_setTexParameters(GL gl) {
        gl.glTexParameteri(3553, 10240, 9728);
        gl.glTexParameteri(3553, 10241, 9728);
        gl.glTexParameteri(3553, 10242, 10496);
        gl.glTexParameteri(3553, 10243, 10496);
    }

    protected ByteBuffer newByteBuffer() {
        return BufferUtil.newByteBuffer((int)this.getRequiredCapacityBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isResident(GL gl) {
        this.lock.lock();
        try {
            if (!this.glAllocated) {
                boolean bl = false;
                return bl;
            }
            byte[] resident = new byte[this.textureHandles.length];
            gl.glAreTexturesResident(1, this.textureHandles, 0, resident, 0);
            for (int i = 0; i < resident.length; ++i) {
                if (resident[i] > 0) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int dataSizeX, int dataSizeY) {
        this.lock.lock();
        try {
            this.dataSizeX = dataSizeX;
            this.dataSizeY = dataSizeY;
            this.glAllocated = false;
            if (this.data == null || this.data.capacity() < this.getRequiredCapacityBytes()) {
                this.data = this.newByteBuffer();
            }
            this.makeDirty();
            this.makeProjectionDirty();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProjection(Projection projection) {
        this.lock.lock();
        try {
            this.projection = projection;
            this.makeProjectionDirty();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Projection getProjection() {
        this.lock.lock();
        try {
            Projection projection = this.projection;
            return projection;
        }
        finally {
            this.lock.unlock();
        }
    }
}

