/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.texture;

import com.metsci.glimpse.gl.util.GLUtils;
import com.metsci.glimpse.support.texture.FloatTextureProjected2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.opengl.GL;

public class ColorTextureProjected2D
extends FloatTextureProjected2D {
    private static final Logger logger = Logger.getLogger(FloatTextureProjected2D.class.getName());
    public static final int FLOATS_PER_PIXEL = 4;

    public ColorTextureProjected2D() {
        this(0, 0, false);
    }

    public ColorTextureProjected2D(int dataSizeX, int dataSizeY) {
        this(dataSizeX, dataSizeY, false);
    }

    public ColorTextureProjected2D(int dataSizeX, int dataSizeY, boolean useVertexZCoord) {
        super(dataSizeX, dataSizeY, useVertexZCoord);
    }

    @Override
    protected int getRequiredCapacityBytes() {
        return this.dataSizeX * this.dataSizeY * 4 * 4;
    }

    @Override
    protected Buffer prepare_setPixelStore(GL gl, int i) {
        gl.glPixelStorei(3317, 1);
        gl.glPixelStorei(3316, this.texStartsX[i]);
        gl.glPixelStorei(3314, this.dataSizeX);
        return this.data.asFloatBuffer().position(this.texStartsY[i] * this.dataSizeX * 4);
    }

    @Override
    protected void prepare_setData(GL gl) {
        for (int i = 0; i < this.numTextures; ++i) {
            gl.glBindTexture(GLUtils.getGLTextureDim(2), this.textureHandles[i]);
            this.prepare_setTexParameters(gl);
            Buffer positionBuffer = this.prepare_setPixelStore(gl, i);
            gl.glTexImage2D(3553, 0, 6408, this.texSizesX[i], this.texSizesY[i], 0, 6408, 5126, positionBuffer);
        }
        gl.glPixelStorei(3316, 0);
        gl.glPixelStorei(3315, 0);
        gl.glPixelStorei(3314, 0);
    }

    public void setData(InputStream in) throws IOException {
        this.setData(ImageIO.read(in));
    }

    public void setData(BufferedImage image) {
        this.setData0(image, false, -1.0f);
    }

    public void setData(BufferedImage image, float alpha) {
        this.setData0(image, true, alpha);
    }

    protected void setData0(final BufferedImage image, final boolean alphaOverride, final float alpha) {
        this.resize(image.getWidth(), image.getHeight());
        this.mutate(new FloatTextureProjected2D.MutatorFloat2D(){

            @Override
            public void mutate(FloatBuffer data, int dataSizeX, int dataSizeY) {
                WritableRaster r = image.getAlphaRaster();
                for (int y = 0; y < dataSizeY; ++y) {
                    for (int x = 0; x < dataSizeX; ++x) {
                        int rgb = image.getRGB(x, image.getHeight() - y - 1);
                        float a = alphaOverride ? alpha : (r == null ? 1.0f : (float)r.getSample(x, image.getHeight() - y - 1, 0) / 255.0f);
                        data.put((float)(rgb >> 16 & 0xFF) / 255.0f);
                        data.put((float)(rgb >> 8 & 0xFF) / 255.0f);
                        data.put((float)(rgb & 0xFF) / 255.0f);
                        data.put(a);
                    }
                }
            }
        });
    }

    public void setData(float[][][] data) {
        this.mutate(new SetDataMutator(data));
    }

    public void setData(double[][][] data) {
        this.mutate(new SetDataMutator(data));
    }

    @Override
    public void setData(float[][] data) {
        this.mutate(new SetDataMutatorGrayscale(data));
    }

    @Override
    public void setData(double[][] data) {
        this.mutate(new SetDataMutatorGrayscale(data));
    }

    public static class SetDataMutatorGrayscale
    implements FloatTextureProjected2D.MutatorFloat2D {
        public float[][] dataf;
        public double[][] datad;

        public SetDataMutatorGrayscale(float[][] data) {
            this.dataf = data;
        }

        public SetDataMutatorGrayscale(double[][] data) {
            this.datad = data;
        }

        @Override
        public void mutate(FloatBuffer buffer, int dataSizeX, int dataSizeY) {
            if (this.dataf != null) {
                this.mutatef(buffer, dataSizeX, dataSizeY);
            } else if (this.datad != null) {
                this.mutated(buffer, dataSizeX, dataSizeY);
            }
        }

        public void mutatef(FloatBuffer buffer, int dataSizeX, int dataSizeY) {
            if (this.dataf == null) {
                logger.warning("Null data array passed to SetDataMutator.");
                return;
            }
            if (this.dataf.length != dataSizeX || this.dataf[0].length != dataSizeY) {
                logger.warning("Incorrectly sized data array passed to SetDataMutator.");
                return;
            }
            buffer.clear();
            for (int y = 0; y < dataSizeY; ++y) {
                for (int x = 0; x < dataSizeX; ++x) {
                    for (int i = 0; i < 4; ++i) {
                        float d = this.dataf[x][y];
                        buffer.put(d).put(d).put(d).put(d);
                    }
                }
            }
        }

        public void mutated(FloatBuffer buffer, int dataSizeX, int dataSizeY) {
            if (this.datad == null) {
                logger.warning("Null data array passed to SetDataMutator.");
                return;
            }
            if (this.datad.length != dataSizeX || this.datad[0].length != dataSizeY) {
                logger.warning("Incorrectly sized data array passed to SetDataMutator.");
                return;
            }
            buffer.clear();
            for (int y = 0; y < dataSizeY; ++y) {
                for (int x = 0; x < dataSizeX; ++x) {
                    for (int i = 0; i < 4; ++i) {
                        float d = (float)this.datad[x][y];
                        buffer.put(d).put(d).put(d).put(d);
                    }
                }
            }
        }
    }

    public static class SetDataMutator
    implements FloatTextureProjected2D.MutatorFloat2D {
        public float[][][] dataf;
        public double[][][] datad;

        public SetDataMutator(float[][][] data) {
            this.dataf = data;
        }

        public SetDataMutator(double[][][] data) {
            this.datad = data;
        }

        @Override
        public void mutate(FloatBuffer buffer, int dataSizeX, int dataSizeY) {
            if (this.dataf != null) {
                this.mutatef(buffer, dataSizeX, dataSizeY);
            } else if (this.datad != null) {
                this.mutated(buffer, dataSizeX, dataSizeY);
            }
        }

        public void mutatef(FloatBuffer buffer, int dataSizeX, int dataSizeY) {
            if (this.dataf == null) {
                logger.warning("Null data array passed to SetDataMutator.");
                return;
            }
            if (this.dataf.length != dataSizeX || this.dataf[0].length != dataSizeY) {
                logger.warning("Incorrectly sized data array passed to SetDataMutator.");
                return;
            }
            buffer.clear();
            for (int y = 0; y < dataSizeY; ++y) {
                for (int x = 0; x < dataSizeX; ++x) {
                    for (int i = 0; i < 4; ++i) {
                        buffer.put(this.dataf[x][y][i]);
                    }
                }
            }
        }

        public void mutated(FloatBuffer buffer, int dataSizeX, int dataSizeY) {
            if (this.datad == null) {
                logger.warning("Null data array passed to SetDataMutator.");
                return;
            }
            if (this.datad.length != dataSizeX || this.datad[0].length != dataSizeY) {
                logger.warning("Incorrectly sized data array passed to SetDataMutator.");
                return;
            }
            buffer.clear();
            for (int y = 0; y < dataSizeY; ++y) {
                for (int x = 0; x < dataSizeX; ++x) {
                    for (int i = 0; i < 4; ++i) {
                        buffer.put((float)this.datad[x][y][i]);
                    }
                }
            }
        }
    }
}

