/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.shader;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.listener.AxisListener1D;
import com.metsci.glimpse.gl.shader.Shader;
import com.metsci.glimpse.gl.shader.ShaderArg;
import com.metsci.glimpse.gl.shader.ShaderSource;
import com.metsci.glimpse.gl.shader.ShaderType;
import com.metsci.glimpse.util.io.StreamOpener;
import java.io.IOException;
import javax.media.opengl.GL;

public class SimplePointShader
extends Shader {
    protected ShaderArg colorTexUnit;
    protected ShaderArg colorMin;
    protected ShaderArg colorMax;
    protected ShaderArg sizeTexUnit;
    protected ShaderArg sizeMin;
    protected ShaderArg sizeMax;
    protected ShaderArg discardBelowColor;
    protected ShaderArg discardAboveColor;
    protected ShaderArg discardBelowSize;
    protected ShaderArg discardAboveSize;
    protected ShaderArg constantSize;
    protected ShaderArg constantColor;
    protected int colorAttributeIndex;
    protected int sizeAttributeIndex;

    public SimplePointShader(int colorTextureUnit, int sizeTextureUnit, int colorAttributeIndex, int sizeAttributeIndex, Axis1D colorAxis, Axis1D sizeAxis) throws IOException {
        this(colorTextureUnit, sizeTextureUnit, colorAttributeIndex, sizeAttributeIndex, colorAxis, sizeAxis, SimplePointShader.readSource());
    }

    protected SimplePointShader(int colorTextureUnit, int sizeTextureUnit, int colorAttributeIndex, int sizeAttributeIndex, Axis1D colorAxis, Axis1D sizeAxis, ShaderSource ... source) throws IOException {
        super("point_shader", ShaderType.vertex, source);
        this.initializeShaderArgs();
        this.initializeShaderValues(colorTextureUnit, sizeTextureUnit, colorAttributeIndex, sizeAttributeIndex, colorAxis, sizeAxis);
    }

    protected void initializeShaderArgs() {
        this.colorTexUnit = this.getArg("valTexture_color");
        this.colorMin = this.getArg("valMin_color");
        this.colorMax = this.getArg("valMax_color");
        this.sizeTexUnit = this.getArg("valTexture_size");
        this.sizeMin = this.getArg("valMin_size");
        this.sizeMax = this.getArg("valMax_size");
        this.discardAboveColor = this.getArg("discardAbove_color");
        this.discardBelowColor = this.getArg("discardBelow_color");
        this.discardAboveSize = this.getArg("discardAbove_size");
        this.discardBelowSize = this.getArg("discardBelow_size");
        this.constantColor = this.getArg("constant_color");
        this.constantSize = this.getArg("constant_size");
    }

    protected void initializeShaderValues(int colorTextureUnit, int sizeTextureUnit, int colorAttributeIndex, int sizeAttributeIndex, Axis1D colorAxis, Axis1D sizeAxis) {
        this.colorAttributeIndex = colorAttributeIndex;
        this.sizeAttributeIndex = sizeAttributeIndex;
        this.colorTexUnit.setValue(colorTextureUnit);
        this.colorMin.setValue(colorAxis.getMin());
        this.colorMax.setValue(colorAxis.getMax());
        colorAxis.addAxisListener(new AxisListener1D(){

            @Override
            public void axisUpdated(Axis1D handler) {
                SimplePointShader.this.colorMin.setValue(handler.getMin());
                SimplePointShader.this.colorMax.setValue(handler.getMax());
            }
        });
        this.sizeTexUnit.setValue(sizeTextureUnit);
        this.sizeMin.setValue(sizeAxis.getMin());
        this.sizeMax.setValue(sizeAxis.getMax());
        sizeAxis.addAxisListener(new AxisListener1D(){

            @Override
            public void axisUpdated(Axis1D handler) {
                SimplePointShader.this.sizeMin.setValue(handler.getMin());
                SimplePointShader.this.sizeMax.setValue(handler.getMax());
            }
        });
        this.discardAboveColor.setValue(false);
        this.discardBelowColor.setValue(false);
        this.discardAboveSize.setValue(false);
        this.discardBelowSize.setValue(false);
        this.constantColor.setValue(true);
        this.constantSize.setValue(true);
    }

    private static final ShaderSource readSource() throws IOException {
        return new ShaderSource("shaders/point/point_shader.vs", StreamOpener.fileThenResource);
    }

    @Override
    public boolean preLink(GL gl, int glProgramHandle) {
        gl.glBindAttribLocation(glProgramHandle, this.colorAttributeIndex, "valColor");
        gl.glBindAttribLocation(glProgramHandle, this.sizeAttributeIndex, "valSize");
        return true;
    }

    @Override
    public void preDisplay(GL gl) {
    }

    @Override
    public void postDisplay(GL gl) {
    }

    public void setConstantColor(boolean constant) {
        this.constantColor.setValue(constant);
    }

    public void setConstantSize(boolean constant) {
        this.constantSize.setValue(constant);
    }

    public void setDiscardAboveSize(boolean discard) {
        this.discardAboveSize.setValue(discard);
    }

    public void setDiscardBelowSize(boolean discard) {
        this.discardBelowSize.setValue(discard);
    }

    public void setDiscardAboveColor(boolean discard) {
        this.discardAboveColor.setValue(discard);
    }

    public void setDiscardBelowColor(boolean discard) {
        this.discardBelowColor.setValue(discard);
    }
}

