/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.repaint;

import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.support.repaint.RepaintManager;
import com.metsci.glimpse.util.logging.LoggerUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class SwingRepaintManager
extends RepaintManager {
    public static SwingRepaintManager newRepaintManager(GlimpseCanvas canvas) {
        SwingRepaintManager manager = new SwingRepaintManager();
        manager.addGlimpseCanvas(canvas);
        manager.start();
        return manager;
    }

    @Override
    public void asyncExec(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    public void syncExec(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException e) {
            LoggerUtils.logWarning((Logger)logger, (String)"Trouble in RepaintManager", (Throwable)e, (Object[])new Object[0]);
        }
        catch (InvocationTargetException e) {
            LoggerUtils.logWarning((Logger)logger, (String)"Trouble in RepaintManager", (Throwable)e, (Object[])new Object[0]);
        }
    }

    @Override
    public boolean checkThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    @Override
    public Runnable newRepaintRunnable() {
        return new RepaintRunnable();
    }

    public class RepaintRunnable
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SwingRepaintManager.this.lock.lock();
                try {
                    while (SwingRepaintManager.this.paused) {
                        SwingRepaintManager.this.pause.await();
                    }
                }
                finally {
                    SwingRepaintManager.this.lock.unlock();
                }
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        for (GlimpseCanvas canvas : SwingRepaintManager.this.canvasList) {
                            canvas.paint();
                        }
                    }
                });
            }
            catch (Exception e) {
                LoggerUtils.logWarning((Logger)RepaintManager.logger, (String)"Problem Repainting...", (Throwable)e, (Object[])new Object[0]);
            }
        }
    }
}

