/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.repaint;

import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.util.logging.LoggerUtils;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public class RepaintManager {
    public static final Logger logger = Logger.getLogger(RepaintManager.class.getName());
    public static final int DELAY = 10;
    protected ScheduledExecutorService executor;
    protected Thread thread;
    protected boolean started = false;
    protected boolean shutdown = false;
    protected boolean paused = false;
    protected ReentrantLock lock;
    protected Condition pause;
    protected Set<GlimpseCanvas> canvasList = new CopyOnWriteArraySet<GlimpseCanvas>();

    public static RepaintManager newRepaintManager(GlimpseCanvas canvas) {
        RepaintManager manager = new RepaintManager(canvas);
        manager.start();
        return manager;
    }

    public RepaintManager(GlimpseCanvas canvas) {
        this();
        this.addGlimpseCanvas(canvas);
    }

    public RepaintManager() {
        this.lock = new ReentrantLock();
        this.pause = this.lock.newCondition();
        this.executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                RepaintManager.this.thread = new Thread(runnable);
                RepaintManager.this.thread.setName("repaint-manager");
                RepaintManager.this.thread.setDaemon(true);
                return RepaintManager.this.thread;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGlimpseCanvas(GlimpseCanvas canvas) {
        this.lock.lock();
        try {
            this.canvasList.add(canvas);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGlimpseCanvas(GlimpseCanvas canvas) {
        this.lock.lock();
        try {
            this.canvasList.remove(canvas);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.lock.lock();
        try {
            this.executor.shutdown();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.lock.lock();
        try {
            if (!this.started) {
                this.executor.scheduleWithFixedDelay(this.newRepaintRunnable(), 0L, 10L, TimeUnit.MILLISECONDS);
                this.started = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        this.lock.lock();
        try {
            this.paused = false;
            this.pause.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        this.lock.lock();
        try {
            this.paused = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void asyncExec(Runnable runnable) {
        this.executor.execute(runnable);
    }

    public void syncExec(Runnable runnable) {
        try {
            this.executor.submit(runnable).get();
        }
        catch (InterruptedException e) {
            LoggerUtils.logWarning((Logger)logger, (String)"Trouble in RepaintManager", (Throwable)e, (Object[])new Object[0]);
        }
        catch (ExecutionException e) {
            LoggerUtils.logWarning((Logger)logger, (String)"Trouble in RepaintManager", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public boolean checkThread() {
        return Thread.currentThread().equals(this.thread);
    }

    public Runnable newRepaintRunnable() {
        return new RepaintRunnable();
    }

    public class RepaintRunnable
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                RepaintManager.this.lock.lock();
                try {
                    while (RepaintManager.this.paused) {
                        RepaintManager.this.pause.await();
                    }
                }
                finally {
                    RepaintManager.this.lock.unlock();
                }
                for (GlimpseCanvas canvas : RepaintManager.this.canvasList) {
                    canvas.paint();
                }
            }
            catch (Exception e) {
                LoggerUtils.logWarning((Logger)logger, (String)"Problem Repainting...", (Throwable)e, (Object[])new Object[0]);
            }
        }
    }
}

