/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.projection;

import com.metsci.glimpse.support.projection.Projection;
import com.metsci.glimpse.util.geo.projection.GeoProjection;
import com.metsci.glimpse.util.vector.Vector2d;

public class GeoReprojection
implements Projection {
    protected Projection flat;
    protected GeoProjection from;
    protected GeoProjection to;
    protected double sizeDownsample;

    public GeoReprojection(Projection flat, GeoProjection from, GeoProjection to, double sizeDownsample) {
        this.from = from;
        this.to = to;
        this.flat = flat;
        this.sizeDownsample = sizeDownsample;
    }

    @Override
    public void getVertexXY(double dataFractionX, double dataFractionY, float[] resultXY) {
        this.flat.getVertexXY(dataFractionX, dataFractionY, resultXY);
        Vector2d v = this.to.reprojectFrom((double)resultXY[0], (double)resultXY[1], this.from);
        resultXY[0] = (float)v.getX();
        resultXY[1] = (float)v.getY();
    }

    @Override
    public void getVertexXYZ(double dataFractionX, double dataFractionY, float[] resultXYZ) {
        this.getVertexXYZ(dataFractionX, dataFractionY, resultXYZ);
        resultXYZ[2] = 0.0f;
    }

    @Override
    public int getSizeX(int textureSizeX) {
        return (int)Math.max(1.0, (double)textureSizeX * this.sizeDownsample);
    }

    @Override
    public int getSizeY(int textureSizeY) {
        return (int)Math.max(1.0, (double)textureSizeY * this.sizeDownsample);
    }
}

