/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.projection;

import com.metsci.glimpse.support.projection.Projection;

public class GenericProjection
implements Projection {
    protected double[][] coordsX;
    protected double[][] coordsY;
    protected int sizeX;
    protected int sizeY;

    public GenericProjection(double[][] coordsX, double[][] coordsY) {
        this.coordsX = coordsX;
        this.coordsY = coordsY;
        this.sizeX = this.coordsX.length - 1;
        this.sizeY = this.coordsX[0].length - 1;
    }

    @Override
    public void getVertexXY(double dataFractionX, double dataFractionY, float[] resultXY) {
        resultXY[0] = (float)this.getVertex(this.coordsX, dataFractionX, dataFractionY);
        resultXY[1] = (float)this.getVertex(this.coordsY, dataFractionX, dataFractionY);
    }

    @Override
    public void getVertexXYZ(double textureFractionX, double textureFractionY, float[] resultXYZ) {
        this.getVertexXY(textureFractionX, textureFractionY, resultXYZ);
        resultXYZ[2] = 0.0f;
    }

    protected double getVertex(double[][] data, double dataFractionX, double dataFractionY) {
        double avgTopX;
        double avgBotX;
        double indexX = dataFractionX * (double)this.sizeX;
        double indexY = dataFractionY * (double)this.sizeY;
        int minIndexX = (int)Math.floor(indexX);
        int minIndexY = (int)Math.floor(indexY);
        if (minIndexX < 0) {
            minIndexX = 0;
        }
        if (minIndexX > this.sizeX) {
            minIndexX = this.sizeX;
        }
        if (minIndexY < 0) {
            minIndexY = 0;
        }
        if (minIndexY > this.sizeY) {
            minIndexY = this.sizeY;
        }
        int maxIndexX = minIndexX + 1;
        int maxIndexY = minIndexY + 1;
        if (maxIndexX > this.sizeX) {
            maxIndexX = this.sizeX;
        }
        if (maxIndexY > this.sizeY) {
            maxIndexY = this.sizeY;
        }
        if (maxIndexX == minIndexX) {
            avgBotX = data[minIndexX][minIndexY];
            avgTopX = data[minIndexX][maxIndexY];
        } else {
            double fracX = (indexX - (double)minIndexX) / (double)(maxIndexX - minIndexX);
            avgBotX = (1.0 - fracX) * data[minIndexX][minIndexY] + fracX * data[maxIndexX][minIndexY];
            avgTopX = (1.0 - fracX) * data[minIndexX][maxIndexY] + fracX * data[maxIndexX][maxIndexY];
        }
        if (maxIndexY == minIndexY) {
            return avgBotX;
        }
        double fracY = (indexY - (double)minIndexY) / (double)(maxIndexY - minIndexY);
        return (1.0 - fracY) * avgBotX + fracY * avgTopX;
    }

    @Override
    public int getSizeX(int textureSizeX) {
        return this.sizeX;
    }

    @Override
    public int getSizeY(int textureSizeY) {
        return this.sizeY;
    }
}

