/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.font;

import com.metsci.glimpse.support.font.SimpleTextLayout;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.text.BreakIterator;
import java.util.ArrayList;

public class SimpleTextLayoutCenter
extends SimpleTextLayout {
    public SimpleTextLayoutCenter(Font font, FontRenderContext frc) {
        super(font, frc);
    }

    public SimpleTextLayoutCenter(Font font, FontRenderContext frc, BreakIterator breaker) {
        super(font, frc, breaker);
    }

    public void doLayout(String text, float leftX, float topY, float maxWidth, float maxHeight) {
        super.doLayout(text, leftX, topY, maxWidth);
        this.centerRectangles(leftX, topY, maxWidth, maxHeight);
    }

    protected void centerRectangles(float leftX, float topY, float maxWidth, float maxHeight) {
        float centerLineX = leftX + maxWidth / 2.0f;
        float minY = Float.POSITIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        for (SimpleTextLayout.TextBoundingBox box : this.lines) {
            minY = Math.min(minY, box.getMinY());
            maxY = Math.max(maxY, box.getMaxY());
        }
        float subtractY = (maxHeight - (maxY - minY)) / 2.0f;
        subtractY = Math.max(0.0f, subtractY);
        ArrayList<SimpleTextLayout.TextBoundingBox> newLines = new ArrayList<SimpleTextLayout.TextBoundingBox>(this.lines.size());
        for (SimpleTextLayout.TextBoundingBox box : this.lines) {
            float newX = centerLineX - box.width / 2.0f;
            newX = Math.max(newX, leftX);
            newLines.add(new SimpleTextLayout.TextBoundingBox(box.text, box.baselineY - subtractY, newX, box.maxDescent, box.width, box.maxHeight));
        }
        this.lines.clear();
        this.lines.addAll(newLines);
    }
}

