/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.font;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleTextLayout {
    protected Font font;
    protected FontRenderContext frc;
    protected BreakIterator breaker;
    protected float ascent;
    protected float descent;
    protected String text;
    protected List<TextBoundingBox> lines;
    private float lineSpacing;
    private boolean breakOnEol;

    public SimpleTextLayout(Font font, FontRenderContext frc) {
        this(font, frc, BreakIterator.getWordInstance());
    }

    public SimpleTextLayout(Font font, FontRenderContext frc, BreakIterator breaker) {
        this.font = font;
        this.frc = frc;
        this.breaker = breaker;
        Rectangle2D rect = font.getMaxCharBounds(frc);
        this.ascent = (float)(rect.getMaxY() - rect.getY());
        this.descent = (float)(-rect.getY());
        this.setLineSpacing(0.0f);
        this.setBreakOnEol(true);
    }

    public double getDescent() {
        return this.descent;
    }

    public double getAscent() {
        return this.ascent;
    }

    public void setBreakOnEol(boolean breakOnEol) {
        this.breakOnEol = breakOnEol;
    }

    public boolean getBreakOnEol() {
        return this.breakOnEol;
    }

    public void setLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public void doLayout(String text, float leftX, float topY, float maxWidth) {
        this.text = text;
        GlyphVector glyphs = this.font.createGlyphVector(this.frc, text);
        IntList breaks = this.getBreaks(glyphs, maxWidth);
        if (breaks.size() == 2) {
            this.layoutNoBreaks(glyphs, leftX, topY);
            return;
        }
        this.layout(breaks, glyphs, leftX, topY, maxWidth);
    }

    protected IntList getBreaks(GlyphVector glyphs, float maxWidth) {
        IntArrayList breaks = new IntArrayList();
        breaks.add(0);
        this.breaker.setText(this.text);
        int lastBreakIdx = 0;
        while (lastBreakIdx < this.text.length()) {
            double currentWidth = 0.0;
            int breakAt = -1;
            for (int i = lastBreakIdx; i < this.text.length() && breakAt == -1; ++i) {
                if (this.forceBreakAfter(i)) {
                    breakAt = i + 1;
                    continue;
                }
                Shape l = glyphs.getGlyphLogicalBounds(i);
                double width = l.getBounds2D().getWidth();
                if (currentWidth + width > (double)maxWidth) {
                    breakAt = this.breaker.preceding(i);
                    if (breakAt == -1 || breakAt <= lastBreakIdx) {
                        breakAt = this.breaker.following(i);
                    }
                    if (breakAt != -1) continue;
                    breakAt = this.text.length();
                    continue;
                }
                currentWidth += width;
            }
            if (breakAt == -1) {
                breakAt = this.text.length();
            }
            breaks.add(breakAt);
            lastBreakIdx = breakAt;
            assert (breaks.size() <= this.text.length());
        }
        return breaks;
    }

    protected void layoutNoBreaks(GlyphVector glyphs, float leftX, float topY) {
        Rectangle2D visualBounds = glyphs.getVisualBounds();
        float baseline = (float)(-visualBounds.getY());
        float width = (float)visualBounds.getWidth();
        float height = (float)visualBounds.getHeight();
        float minX = (float)visualBounds.getMinX();
        float minY = topY - this.ascent;
        this.lines = Collections.singletonList(new TextBoundingBox(this.text, baseline, minX, minY, width, height));
    }

    protected void layout(IntList breaks, GlyphVector glyphs, float leftX, float topY, float maxWidth) {
        this.lines = new ArrayList<TextBoundingBox>(breaks.size() - 1);
        double prevMinX = 0.0;
        for (int i = 1; i < breaks.size(); ++i) {
            int firstIdx = breaks.getInt(i - 1);
            int lastIdx = breaks.getInt(i) - 1;
            firstIdx = this.trimLeft(this.text, firstIdx);
            if ((lastIdx = this.trimRight(this.text, lastIdx)) <= firstIdx) continue;
            double minX = Double.POSITIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            for (int j = firstIdx; j <= lastIdx; ++j) {
                Rectangle2D b = glyphs.getGlyphLogicalBounds(j).getBounds2D();
                minX = Math.min(minX, b.getMinX());
                minY = Math.min(minY, b.getMinY());
                maxX = Math.max(maxX, b.getMaxX());
                maxY = Math.max(maxY, b.getMaxY());
            }
            prevMinX = minX;
            double height = maxY - minY;
            double width = maxX - minX;
            float baseline = topY - this.ascent;
            String line = this.text.substring(firstIdx, lastIdx + 1);
            TextBoundingBox box = new TextBoundingBox(line, baseline, (float)(minX - prevMinX), (float)minY, (float)width, (float)height);
            this.lines.add(box);
            topY = baseline - this.getLineSpacing();
        }
    }

    protected int trimLeft(String text, int index) {
        while (index < text.length() && this.trimFromLine(text.charAt(index))) {
            ++index;
        }
        return index;
    }

    protected int trimRight(String text, int index) {
        while (0 < index && this.trimFromLine(text.charAt(index))) {
            --index;
        }
        return index;
    }

    protected boolean trimFromLine(char c) {
        return Character.isWhitespace(c);
    }

    protected boolean forceBreakAfter(int index) {
        char c = this.text.charAt(index);
        return this.getBreakOnEol() && (c == '\n' || c == '\r' || c == '\f');
    }

    public String getSourceText() {
        return this.text;
    }

    public int numberOfLines() {
        return this.lines.size();
    }

    public TextBoundingBox getLine(int line) {
        return this.lines.get(line);
    }

    public List<TextBoundingBox> getLines() {
        return new ArrayList<TextBoundingBox>(this.lines);
    }

    public static class TextBoundingBox {
        public final String text;
        public final float baselineY;
        public final float leftX;
        public final float maxDescent;
        public final float width;
        public final float maxHeight;

        public TextBoundingBox(String text, float baselineY, float leftX, float descent, float width, float height) {
            this.text = text;
            this.baselineY = baselineY;
            this.leftX = leftX;
            this.maxDescent = descent;
            this.width = width;
            this.maxHeight = height;
        }

        public float getMaxY() {
            return this.baselineY + this.maxHeight - this.maxDescent;
        }

        public float getMinY() {
            return this.baselineY - this.maxDescent;
        }

        public float getMinX() {
            return this.leftX;
        }

        public float getMaxX() {
            return this.leftX + this.width;
        }
    }
}

